/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.dssapi.v3.pathinfo;

import ch.ethz.sis.openbis.generic.dssapi.v3.dto.datasetfile.create.DataSetFileCreation;
import ch.ethz.sis.openbis.generic.server.dssapi.v3.pathinfo.DataSetContentNode;
import ch.ethz.sis.openbis.generic.server.dssapi.v3.pathinfo.DirectoryNode;
import ch.systemsx.cisd.etlserver.path.IPathsInfoDAO;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;

public class PathInfoFeeder {
    private DirectoryNode root = new DirectoryNode(null, null);
    private final long dataSetId;
    private String dataSetCode;

    public PathInfoFeeder(long dataSetId, String dataSetCode, Collection<DataSetFileCreation> files) {
        this.dataSetCode = dataSetCode;
        PathInfoFeeder.checkInput(files);
        for (DataSetFileCreation file : files) {
            if (file.isDirectory()) {
                this.root = this.root.addDirectory(Paths.get(file.getPath(), new String[0]));
                continue;
            }
            String checksum = file.getChecksum();
            if (checksum != null) {
                String checksumType = file.getChecksumType();
                checksum = checksumType + ":" + checksum;
            }
            this.root = this.root.addFile(Paths.get(file.getPath(), new String[0]), file.getFileLength(), file.getChecksumCRC32(), checksum);
        }
        this.dataSetId = dataSetId;
    }

    public void storeFilesWith(IPathsInfoDAO dao) {
        this.storeFilesWith(dao, this.root, null, this.dataSetCode, new Date());
    }

    private void storeFilesWith(IPathsInfoDAO dao, DataSetContentNode node, Long parentId, String name, Date timestamp) {
        String fullPath = node.getFullPath() == null ? "" : node.getFullPath();
        long id = dao.createDataSetFile(this.dataSetId, parentId, fullPath, name, node.getLength(), node.isDirectory(), node.getChecksumCRC32(), node.getChecksum(), timestamp);
        if (node.isDirectory()) {
            for (Map.Entry<String, DataSetContentNode> entry : ((DirectoryNode)node).getChildren().entrySet()) {
                this.storeFilesWith(dao, entry.getValue(), id, entry.getKey(), timestamp);
            }
        }
    }

    private static void checkInput(Collection<DataSetFileCreation> files) {
        HashSet<String> paths = new HashSet<String>();
        for (DataSetFileCreation file : files) {
            PathInfoFeeder.checkInput(file);
            PathInfoFeeder.check(paths.contains(file.getPath()), "Path '" + file.getPath() + "' appears twice");
            paths.add(file.getPath());
        }
    }

    private static void checkInput(DataSetFileCreation file) {
        String path = file.getPath();
        PathInfoFeeder.check(path == null || path.length() == 0, "Path of " + file + " was null");
        PathInfoFeeder.check(path.startsWith("/"), "Path '" + path + "' is absolute");
        PathInfoFeeder.check(file.getChecksum() != null && file.getChecksumType() == null, "Checksum with out type specified: " + file.getChecksum());
        PathInfoFeeder.check(!file.isDirectory() && file.getFileLength() == null, "Size of '" + path + "' is null");
        PathInfoFeeder.check(file.isDirectory() && file.getFileLength() != null, "Directory '" + path + "' has size " + file.getFileLength());
        PathInfoFeeder.check(file.isDirectory() && file.getChecksumCRC32() != null, "Directory '" + path + "' has CRC32 checksum " + file.getChecksumCRC32());
        PathInfoFeeder.check(file.isDirectory() && file.getChecksum() != null && file.getChecksumType() != null, "Directory '" + path + "' has checksum of type " + file.getChecksumType() + ": " + file.getChecksum());
    }

    private static void check(boolean condition, String message) {
        if (condition) {
            throw new IllegalArgumentException(message);
        }
    }
}

