/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.dssapi.v3.upload;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.etlserver.api.v1.PutDataSetService;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class StoreShareFileUploadServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    protected static Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, StoreShareFileUploadServlet.class);
    public static final String SESSION_ID_PARAM = "sessionID";
    public static final String DATA_SET_TYPE_PARAM = "dataSetType";
    public static final String IGNORE_FILE_PATH_PARAM = "ignoreFilePath";
    public static final String FOLDER_PATH_PARAM = "folderPath";
    public static final String UPLOAD_ID_PARAM = "uploadID";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        StoreShareFileUploadRequest uploadRequest = new StoreShareFileUploadRequest(request);
        uploadRequest.validate();
        try {
            FileItemIterator iterator = uploadRequest.getFiles();
            if (!iterator.hasNext()) {
                throw new UserFailureException("Please upload at least one file");
            }
            PutDataSetService putService = (PutDataSetService)ServiceProvider.getDataStoreService().getPutDataSetService();
            while (iterator.hasNext()) {
                FileItemStream file = null;
                InputStream stream = null;
                try {
                    file = iterator.next();
                    stream = file.openStream();
                    String filePath = uploadRequest.isIgnoreFilePath() ? FilenameUtils.getName((String)file.getName()) : file.getName();
                    operationLog.info((Object)("Received file '" + filePath + "' for upload id '" + uploadRequest.getUploadId() + "' and data set type '" + uploadRequest.getDataSetType() + "'"));
                    putService.putFileToStoreShare(uploadRequest.getSessionId(), uploadRequest.getFolderPath(), filePath, uploadRequest.getDataSetType(), uploadRequest.getUploadId(), stream);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(stream);
                    throw throwable;
                    return;
                }
                IOUtils.closeQuietly((InputStream)stream);
            }
        }
        catch (Exception e) {
            operationLog.error((Object)e.getMessage());
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)e);
        }
    }

    private class StoreShareFileUploadRequest {
        private HttpServletRequest request;

        public StoreShareFileUploadRequest(HttpServletRequest request) {
            this.request = request;
        }

        public String getSessionId() {
            return this.request.getParameter(StoreShareFileUploadServlet.SESSION_ID_PARAM);
        }

        public String getDataSetType() {
            return this.request.getParameter(StoreShareFileUploadServlet.DATA_SET_TYPE_PARAM);
        }

        public String getUploadId() {
            return this.request.getParameter(StoreShareFileUploadServlet.UPLOAD_ID_PARAM);
        }

        public boolean isIgnoreFilePath() {
            String str = this.request.getParameter(StoreShareFileUploadServlet.IGNORE_FILE_PATH_PARAM);
            if (str == null || str.isEmpty()) {
                return true;
            }
            return Boolean.valueOf(str);
        }

        public String getFolderPath() {
            return this.request.getParameter(StoreShareFileUploadServlet.FOLDER_PATH_PARAM);
        }

        public FileItemIterator getFiles() throws FileUploadException, IOException {
            ServletFileUpload upload = new ServletFileUpload();
            return upload.getItemIterator(this.request);
        }

        public void validate() {
            if (!ServletFileUpload.isMultipartContent((HttpServletRequest)this.request)) {
                throw new UserFailureException("The file upload accepts only multipart requests");
            }
        }
    }
}

