/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.etlserver.IStorageProcessorTransactional;
import ch.systemsx.cisd.openbis.generic.shared.dto.StorageFormat;
import java.io.File;
import java.util.Properties;
import org.apache.commons.io.FilenameUtils;

public abstract class AbstractStorageProcessor
implements IStorageProcessorTransactional {
    private static final String MOVE_UNREGISTERED_DATASETS_TO_ERROR_DIR_PROPERTY = "move-unregistered-datasets-to-error-dir";
    private static final String[] ZIP_FILE_EXTENSIONS = new String[]{"zip"};
    protected final Properties properties;
    private final boolean moveUnregisteredDatasetsToErrorDir;
    private File storeRootDir;

    protected AbstractStorageProcessor(Properties properties) {
        this.properties = properties;
        this.moveUnregisteredDatasetsToErrorDir = PropertyUtils.getBoolean((Properties)properties, (String)MOVE_UNREGISTERED_DATASETS_TO_ERROR_DIR_PROPERTY, (boolean)true);
    }

    protected final String getMandatoryProperty(String propertyKey) {
        return PropertyUtils.getMandatoryProperty((Properties)this.properties, (String)propertyKey);
    }

    protected static final void checkParameters(File incomingDataSetPath, File targetPath) {
        assert (incomingDataSetPath != null) : "Given incoming data set path can not be null.";
        assert (targetPath != null) : "Given target path can not be null.";
    }

    @Override
    public final File getStoreRootDirectory() {
        return this.storeRootDir;
    }

    @Override
    public final void setStoreRootDirectory(File storeRootDirectory) {
        this.storeRootDir = storeRootDirectory;
    }

    @Override
    public StorageFormat getStorageFormat() {
        return StorageFormat.PROPRIETARY;
    }

    protected static boolean isZipFile(File file) {
        if (file.isDirectory()) {
            return false;
        }
        String fileExtension = FilenameUtils.getExtension((String)file.getName());
        for (String currentExt : ZIP_FILE_EXTENSIONS) {
            if (!currentExt.equalsIgnoreCase(fileExtension)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IStorageProcessorTransactional.UnstoreDataAction getDefaultUnstoreDataAction(Throwable exception) {
        return this.moveUnregisteredDatasetsToErrorDir ? IStorageProcessorTransactional.UnstoreDataAction.MOVE_TO_ERROR : IStorageProcessorTransactional.UnstoreDataAction.LEAVE_UNTOUCHED;
    }
}

