/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.common.filesystem.FileOperations;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.etlserver.AbstractDelegatingStorageProcessor;
import ch.systemsx.cisd.etlserver.AbstractDelegatingStorageProcessorTransaction;
import ch.systemsx.cisd.etlserver.IStorageProcessorTransactional;
import ch.systemsx.cisd.etlserver.ITypeExtractor;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class CifexStorageProcessor
extends AbstractDelegatingStorageProcessor {
    private static final Logger notificationLog = LogFactory.getLogger((LogCategory)LogCategory.NOTIFY, CifexStorageProcessor.class);
    public static final String KEEP_FILE_REGEX_KEY = "keep-file-regex";
    public static final String MOVE_TO_ERROR_FOLDER_KEY = "move-to-error-folder";
    private final String keepFileRegex;
    private final boolean moveToErrorFolder;

    public CifexStorageProcessor(Properties properties) {
        super(properties);
        this.keepFileRegex = PropertyUtils.getProperty((Properties)properties, (String)KEEP_FILE_REGEX_KEY);
        this.moveToErrorFolder = PropertyUtils.getBoolean((Properties)properties, (String)MOVE_TO_ERROR_FOLDER_KEY, (boolean)false);
    }

    @Override
    public IStorageProcessorTransactional.IStorageProcessorTransaction createTransaction(IStorageProcessorTransactional.StorageProcessorTransactionParameters parameters) {
        IStorageProcessorTransactional.IStorageProcessorTransaction superTransaction = super.createTransaction(parameters);
        return new CifexStorageProcessorTransaction(parameters, superTransaction, this.keepFileRegex, this.moveToErrorFolder);
    }

    private static final class CifexStorageProcessorTransaction
    extends AbstractDelegatingStorageProcessorTransaction {
        private static final long serialVersionUID = 1L;
        private final String keepFileRegex;
        private final boolean moveToErrorFolder;
        private transient File dirToRestore;
        private transient File fileToMove;
        private transient boolean dirDeleted = false;

        private CifexStorageProcessorTransaction(IStorageProcessorTransactional.StorageProcessorTransactionParameters parameters, IStorageProcessorTransactional.IStorageProcessorTransaction transaction, String keepFileRegex, boolean moveErrorToFolder) {
            super(parameters, transaction);
            this.keepFileRegex = keepFileRegex;
            this.moveToErrorFolder = moveErrorToFolder;
        }

        @Override
        protected File executeStoreData(ITypeExtractor typeExtractor, IMailClient mailClient) {
            File newIncomingDataSetDirectory = this.incomingDataSetDirectory;
            if (!StringUtils.isBlank((CharSequence)this.keepFileRegex)) {
                newIncomingDataSetDirectory = this.clean(this.incomingDataSetDirectory, this.keepFileRegex);
            }
            this.nestedTransaction.storeData(typeExtractor, mailClient, newIncomingDataSetDirectory);
            return this.nestedTransaction.getStoredDataDirectory();
        }

        @Override
        protected void executeCommit() {
            this.nestedTransaction.commit();
        }

        @Override
        protected IStorageProcessorTransactional.UnstoreDataAction executeRollback(Throwable ex) {
            this.nestedTransaction.rollback(ex);
            if (this.dirDeleted) {
                FileOperations.getMonitoredInstanceForCurrentThread().mkdir(this.dirToRestore);
                FileOperations.getMonitoredInstanceForCurrentThread().moveToDirectory(this.fileToMove, this.dirToRestore);
            }
            return this.moveToErrorFolder ? IStorageProcessorTransactional.UnstoreDataAction.MOVE_TO_ERROR : IStorageProcessorTransactional.UnstoreDataAction.DELETE;
        }

        @Private
        public File clean(File dir, String pattern) {
            assert (dir != null);
            if (StringUtils.isBlank((CharSequence)pattern) || !dir.isDirectory()) {
                return dir;
            }
            RegexFileFilter filter = new RegexFileFilter(pattern);
            List<File> matchingFiles = Arrays.asList(dir.listFiles((FileFilter)filter));
            File newDataDir = dir;
            try {
                this.removeUnmatchedFiles(dir, matchingFiles);
                if (matchingFiles.size() == 1) {
                    boolean movedToDestPlace;
                    File matchingFile = matchingFiles.get(0);
                    String root = dir.getParent();
                    File destinationFile = new File(root, matchingFile.getName());
                    File tmpFile = FileUtilities.createNextNumberedFile((File)destinationFile, null);
                    boolean movedToTmp = FileOperations.getMonitoredInstanceForCurrentThread().rename(matchingFile, tmpFile);
                    if (movedToTmp) {
                        newDataDir = tmpFile;
                        this.fileToMove = tmpFile;
                    }
                    boolean bl = this.dirDeleted = movedToTmp && FileOperations.getMonitoredInstanceForCurrentThread().delete(dir);
                    if (this.dirDeleted) {
                        this.dirToRestore = dir;
                    }
                    boolean bl2 = movedToDestPlace = movedToTmp && FileOperations.getMonitoredInstanceForCurrentThread().rename(tmpFile, destinationFile);
                    if (movedToDestPlace) {
                        newDataDir = destinationFile;
                        this.fileToMove = destinationFile;
                    }
                    if (!(movedToDestPlace && this.dirDeleted)) {
                        this.createCleaningErrorMessage(dir, pattern);
                    }
                }
            }
            catch (IOExceptionUnchecked ex) {
                this.createCleaningErrorMessage(dir, pattern);
            }
            return newDataDir;
        }

        private void createCleaningErrorMessage(File dir, String pattern) {
            notificationLog.error((Object)String.format("Cleaning '%s' by file name pattern '%s' failed.", dir.getPath(), pattern));
        }

        private void removeUnmatchedFiles(File dir, List<File> matchingFiles) {
            for (File f : dir.listFiles()) {
                if (matchingFiles.contains(f)) continue;
                FileOperations.getMonitoredInstanceForCurrentThread().deleteRecursively(f);
            }
        }
    }
}

