/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.etlserver.DataStoreStrategyKey;
import ch.systemsx.cisd.etlserver.IDataStoreStrategy;
import ch.systemsx.cisd.etlserver.IDataStrategyStore;
import ch.systemsx.cisd.etlserver.IdentifiedDataStrategy;
import ch.systemsx.cisd.etlserver.NamedDataStrategy;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Person;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import java.io.File;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class DataStrategyStore
implements IDataStrategyStore {
    static final String SUBJECT_FORMAT = "ATTENTION: experiment '%s'";
    static final String SUBJECT_SAMPLE_FORMAT = "ATTENTION: sample '%s'";
    private static final Logger notificationLog = LogFactory.getLogger((LogCategory)LogCategory.NOTIFY, DataStrategyStore.class);
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, DataStrategyStore.class);
    private final IEncapsulatedOpenBISService limsService;
    private final IMailClient mailClient;
    private final Map<DataStoreStrategyKey, IDataStoreStrategy> dataStoreStrategies;
    private final IOpenbisWrapper openbisServiceWrapper;

    public DataStrategyStore(IEncapsulatedOpenBISService limsService, IMailClient mailClient) {
        this.mailClient = mailClient;
        this.dataStoreStrategies = DataStrategyStore.createDataStoreStrategies();
        this.limsService = limsService;
        this.openbisServiceWrapper = new BasicOpenbisWrapper();
    }

    public DataStrategyStore(DataStrategyStore other) {
        this.mailClient = other.mailClient;
        this.dataStoreStrategies = other.dataStoreStrategies;
        this.limsService = other.limsService;
        this.openbisServiceWrapper = new CachedOpenbisWrapper();
    }

    private static final void putDataStoreStrategy(Map<DataStoreStrategyKey, IDataStoreStrategy> map, IDataStoreStrategy dataStoreStrategy) {
        map.put(dataStoreStrategy.getKey(), dataStoreStrategy);
    }

    private static final Map<DataStoreStrategyKey, IDataStoreStrategy> createDataStoreStrategies() {
        EnumMap<DataStoreStrategyKey, IDataStoreStrategy> map = new EnumMap<DataStoreStrategyKey, IDataStoreStrategy>(DataStoreStrategyKey.class);
        DataStrategyStore.putDataStoreStrategy(map, new IdentifiedDataStrategy());
        DataStrategyStore.putDataStoreStrategy(map, new NamedDataStrategy(DataStoreStrategyKey.UNIDENTIFIED));
        DataStrategyStore.putDataStoreStrategy(map, new NamedDataStrategy(DataStoreStrategyKey.INVALID));
        return map;
    }

    static final String createInvalidSampleCodeMessage(DataSetInformation dataSetInfo) {
        return "ETL server: Sample '" + dataSetInfo.getSampleIdentifier() + "' is not valid for experiment '" + dataSetInfo.getExperimentIdentifier() + "' (it has maybe been invalidated?).";
    }

    private static String createNotificationMessage(DataSetInformation dataSetInfo, File incomingDataSetPathForLogging) {
        SampleIdentifier sampleIdentifier = dataSetInfo.getSampleIdentifier();
        return String.format("Dataset '%s', sample identifier '%s': unknown to openBIS", incomingDataSetPathForLogging, sampleIdentifier);
    }

    @Override
    public IDataStoreStrategy getDataStoreStrategy(DataStoreStrategyKey key) {
        return this.dataStoreStrategies.get((Object)key);
    }

    @Override
    public IDataStoreStrategy getDataStoreStrategy(DataSetInformation dataSetInfo, File incomingDataSetPath) {
        if (dataSetInfo == null) {
            return this.dataStoreStrategies.get((Object)DataStoreStrategyKey.UNIDENTIFIED);
        }
        this.assertIncomingDataSetPath(incomingDataSetPath, dataSetInfo);
        this.injectContainerDataSet(dataSetInfo);
        String emailOrNull = dataSetInfo.tryGetUploadingUserEmail();
        ExperimentIdentifier experimentIdentifier = dataSetInfo.getExperimentIdentifier();
        SampleIdentifier sampleIdentifier = dataSetInfo.getSampleIdentifier();
        if (sampleIdentifier == null) {
            Experiment experiment = this.tryGetExperiment(dataSetInfo);
            if (experiment == null) {
                this.error(emailOrNull, "Unknown experiment identifier '" + experimentIdentifier + "'.");
                return this.dataStoreStrategies.get((Object)DataStoreStrategyKey.UNIDENTIFIED);
            }
            dataSetInfo.setExperiment(experiment);
        } else {
            IEntityProperty[] properties;
            Sample sample = this.tryGetSample(dataSetInfo);
            if (sample == null) {
                this.error(emailOrNull, DataStrategyStore.createNotificationMessage(dataSetInfo, incomingDataSetPath));
                return this.dataStoreStrategies.get((Object)DataStoreStrategyKey.UNIDENTIFIED);
            }
            dataSetInfo.setSample(sample);
            Experiment experiment = sample.getExperiment();
            if (experiment == null) {
                if (sample.getSpace() == null) {
                    this.error(emailOrNull, String.format("Data set for sample '%s' can not be registered because the sample is a shared sample not assigned to a particular space.", sampleIdentifier));
                    return this.dataStoreStrategies.get((Object)DataStoreStrategyKey.UNIDENTIFIED);
                }
            } else {
                experimentIdentifier = new ExperimentIdentifier(experiment);
                dataSetInfo.setExperimentIdentifier(experimentIdentifier);
            }
            if ((properties = this.openbisServiceWrapper.tryGetPropertiesOfSample(sampleIdentifier)) == null) {
                Person registrator;
                Person person = registrator = experiment == null ? sample.getRegistrator() : experiment.getRegistrator();
                assert (registrator != null) : "Registrator must be known";
                String message = DataStrategyStore.createInvalidSampleCodeMessage(dataSetInfo);
                String recipientMail = registrator.getEmail();
                if (StringUtils.isNotBlank((CharSequence)recipientMail)) {
                    this.sendEmail(message, experimentIdentifier, sampleIdentifier, recipientMail);
                } else {
                    this.error(emailOrNull, "The registrator '" + registrator + "' has a blank email, sending the following email failed:\n" + message);
                }
                operationLog.error((Object)this.createLogMessageForMissingSampleProperties(incomingDataSetPath, experimentIdentifier, sampleIdentifier));
                return this.dataStoreStrategies.get((Object)DataStoreStrategyKey.INVALID);
            }
            dataSetInfo.setSampleProperties(properties);
        }
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)this.createLogMessageForIdentified(experimentIdentifier, sampleIdentifier));
        }
        return this.dataStoreStrategies.get((Object)DataStoreStrategyKey.IDENTIFIED);
    }

    private String createLogMessageForIdentified(ExperimentIdentifier experimentIdentifier, SampleIdentifier sampleIdentifier) {
        String prefix = "Identified that database knows ";
        if (sampleIdentifier == null) {
            return prefix + "experiment '" + experimentIdentifier + "'.";
        }
        if (experimentIdentifier == null) {
            return prefix + "sample '" + sampleIdentifier + "'.";
        }
        return prefix + "experiment '" + experimentIdentifier + "' and sample '" + sampleIdentifier + "'.";
    }

    private String createLogMessageForMissingSampleProperties(File incomingDataSetPath, ExperimentIdentifier experimentIdentifier, SampleIdentifier sampleIdentifier) {
        String claimedOwner = experimentIdentifier == null ? String.format("sample '%s'", sampleIdentifier) : String.format("experiment '%s' and sample '%s'", experimentIdentifier, sampleIdentifier);
        return String.format("Incoming data set '%s' claims to belong to %s, but according to the openBIS server there is no such sample (maybe it has been deleted?). We thus consider it invalid.", incomingDataSetPath, claimedOwner);
    }

    public Sample tryGetSample(DataSetInformation dataSetInfo) {
        Sample sample = dataSetInfo.tryToGetSample();
        if (sample == null) {
            sample = this.openbisServiceWrapper.tryGetSample(dataSetInfo.getSampleIdentifier());
        }
        return sample;
    }

    public Experiment tryGetExperiment(DataSetInformation dataSetInfo) {
        Experiment experiment = dataSetInfo.tryToGetExperiment();
        if (experiment == null) {
            experiment = this.openbisServiceWrapper.tryGetExperiment(dataSetInfo.getExperimentIdentifier());
        }
        return experiment;
    }

    public void injectContainerDataSet(DataSetInformation dataSetInfo) {
        AbstractExternalData container;
        String containerDatasetPermId = dataSetInfo.tryGetContainerDatasetPermId();
        if (containerDatasetPermId != null && (container = this.openbisServiceWrapper.tryGetDataSet(containerDatasetPermId)) != null) {
            dataSetInfo.setContainerDataSet(container);
        }
    }

    public void assertIncomingDataSetPath(File incomingDataSetPath, DataSetInformation dataSetInfo) {
        if (dataSetInfo.isNoFileDataSet()) {
            assert (incomingDataSetPath == null) : "Incoming data set path for a no-file data set must be null";
        } else assert (incomingDataSetPath != null) : "Incoming data set path for a normal data set can not be null.";
    }

    private void error(String emailOrNull, String message) {
        if (emailOrNull == null) {
            notificationLog.error((Object)message);
        } else {
            this.mailClient.sendMessage("Error during registration of a data set", message, null, null, new String[]{emailOrNull});
            operationLog.error((Object)message);
        }
    }

    private void sendEmail(String message, ExperimentIdentifier experimentIdentifier, SampleIdentifier sampleIdentifier, String recipientMail) {
        String subject = experimentIdentifier == null ? String.format(SUBJECT_SAMPLE_FORMAT, sampleIdentifier) : String.format(SUBJECT_FORMAT, experimentIdentifier);
        try {
            this.mailClient.sendMessage(subject, message, null, null, new String[]{recipientMail});
        }
        catch (EnvironmentFailureException ex) {
            operationLog.error((Object)ex.getMessage());
        }
    }

    @Override
    public IDataStrategyStore getCachedDataStrategyStore() {
        return new DataStrategyStore(this);
    }

    private class CachedOpenbisWrapper
    extends BasicOpenbisWrapper {
        final HashMap<SampleIdentifier, Sample> sampleCache;
        final HashMap<String, AbstractExternalData> dataSetCache;
        final HashMap<ExperimentIdentifier, Experiment> experimentCache;
        final HashMap<SampleIdentifier, IEntityProperty[]> samplePropertiesCache;

        private CachedOpenbisWrapper() {
            this.sampleCache = new HashMap();
            this.dataSetCache = new HashMap();
            this.experimentCache = new HashMap();
            this.samplePropertiesCache = new HashMap();
        }

        @Override
        public Sample tryGetSample(SampleIdentifier sampleIdentifier) {
            if (!this.sampleCache.containsKey(sampleIdentifier)) {
                this.sampleCache.put(sampleIdentifier, super.tryGetSample(sampleIdentifier));
            }
            return this.sampleCache.get(sampleIdentifier);
        }

        @Override
        public AbstractExternalData tryGetDataSet(String containerDatasetPermId) {
            if (!this.dataSetCache.containsKey(containerDatasetPermId)) {
                this.dataSetCache.put(containerDatasetPermId, super.tryGetDataSet(containerDatasetPermId));
            }
            return this.dataSetCache.get(containerDatasetPermId);
        }

        @Override
        public Experiment tryGetExperiment(ExperimentIdentifier experimentIdentifier) {
            if (!this.experimentCache.containsKey(experimentIdentifier)) {
                this.experimentCache.put(experimentIdentifier, super.tryGetExperiment(experimentIdentifier));
            }
            return this.experimentCache.get(experimentIdentifier);
        }

        @Override
        public IEntityProperty[] tryGetPropertiesOfSample(SampleIdentifier sampleIdentifier) {
            if (!this.samplePropertiesCache.containsKey(sampleIdentifier)) {
                this.samplePropertiesCache.put(sampleIdentifier, super.tryGetPropertiesOfSample(sampleIdentifier));
            }
            return this.samplePropertiesCache.get(sampleIdentifier);
        }
    }

    private class BasicOpenbisWrapper
    implements IOpenbisWrapper {
        private BasicOpenbisWrapper() {
        }

        @Override
        public Sample tryGetSample(SampleIdentifier sampleIdentifier) {
            try {
                return DataStrategyStore.this.limsService.tryGetSampleWithExperiment(sampleIdentifier);
            }
            catch (UserFailureException ex) {
                return null;
            }
        }

        @Override
        public AbstractExternalData tryGetDataSet(String containerDatasetPermId) {
            return DataStrategyStore.this.limsService.tryGetDataSet(containerDatasetPermId);
        }

        @Override
        public Experiment tryGetExperiment(ExperimentIdentifier experimentIdentifier) {
            return DataStrategyStore.this.limsService.tryGetExperiment(experimentIdentifier);
        }

        @Override
        public IEntityProperty[] tryGetPropertiesOfSample(SampleIdentifier sampleIdentifier) {
            return DataStrategyStore.this.limsService.tryGetPropertiesOfSample(sampleIdentifier);
        }
    }

    private static interface IOpenbisWrapper {
        public Sample tryGetSample(SampleIdentifier var1);

        public AbstractExternalData tryGetDataSet(String var1);

        public Experiment tryGetExperiment(ExperimentIdentifier var1);

        public IEntityProperty[] tryGetPropertiesOfSample(SampleIdentifier var1);
    }
}

