/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.properties.PropertyParametersUtil;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.common.reflection.ClassUtils;
import ch.systemsx.cisd.etlserver.AbstractStorageProcessor;
import ch.systemsx.cisd.etlserver.IStorageProcessorTransactional;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

public class DispatcherStorageProcessor
extends AbstractStorageProcessor {
    protected static final String DISPATCHER_PROCESSORS_LIST_PROPERTY = "processors";
    static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, DispatcherStorageProcessor.class);
    private final List<IDispatchableStorageProcessor> delegates;

    public DispatcherStorageProcessor(Properties properties) {
        this(DispatcherStorageProcessor.createDispatcherStorageProcessors(properties), properties);
    }

    @Private
    protected DispatcherStorageProcessor(List<IDispatchableStorageProcessor> delegates, Properties properties) {
        super(properties);
        this.delegates = delegates;
    }

    private IStorageProcessorTransactional chooseStorageProcessor(DataSetInformation dataSetInformation, File incomingDataSet) {
        for (IDispatchableStorageProcessor storageProcessor : this.delegates) {
            if (!storageProcessor.accepts(dataSetInformation, incomingDataSet)) continue;
            return storageProcessor;
        }
        throw new ConfigurationFailureException("No storage processor appropriate for the dataset has been found: " + dataSetInformation);
    }

    @Private
    static List<IDispatchableStorageProcessor> createDispatcherStorageProcessors(Properties properties) {
        PropertyParametersUtil.SectionProperties[] allSectionsProperties;
        ArrayList<IDispatchableStorageProcessor> delegates = new ArrayList<IDispatchableStorageProcessor>();
        for (PropertyParametersUtil.SectionProperties section : allSectionsProperties = PropertyParametersUtil.extractSectionProperties((Properties)properties, (String)DISPATCHER_PROCESSORS_LIST_PROPERTY, (boolean)true)) {
            Properties sectionProperties = section.getProperties();
            String delegateClass = PropertyUtils.getMandatoryProperty((Properties)properties, (String)section.getKey());
            IDispatchableStorageProcessor storageProcessor = (IDispatchableStorageProcessor)ClassUtils.create(IDispatchableStorageProcessor.class, (String)delegateClass, (Object[])new Object[]{sectionProperties});
            delegates.add(storageProcessor);
        }
        return delegates;
    }

    @Override
    public IStorageProcessorTransactional.IStorageProcessorTransaction createTransaction(IStorageProcessorTransactional.StorageProcessorTransactionParameters transactionParameters) {
        IStorageProcessorTransactional storageProcessor = this.chooseStorageProcessor(transactionParameters.getDataSetInformation(), transactionParameters.getIncomingDataSetDirectory());
        return storageProcessor.createTransaction(transactionParameters);
    }

    public static interface IDispatchableStorageProcessor
    extends IStorageProcessorTransactional {
        public boolean accepts(DataSetInformation var1, File var2);
    }
}

