/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.systemsx.cisd.common.utilities.ITimeProvider;
import ch.systemsx.cisd.common.utilities.SystemTimeProvider;
import java.io.File;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.apache.commons.lang3.time.DateFormatUtils;

public class DssUniqueFilenameGenerator {
    private final String sectionSeparator = "_";
    private final String threadName;
    private final String name;
    private final String extensionOrNull;
    private final ITimeProvider timeProvider;

    public DssUniqueFilenameGenerator(String threadName, String name, String extensionOrNull) {
        this((ITimeProvider)SystemTimeProvider.SYSTEM_TIME_PROVIDER, threadName, name, extensionOrNull);
    }

    public DssUniqueFilenameGenerator(ITimeProvider timeProvider, String threadName, String name, String extensionOrNull) {
        this.timeProvider = timeProvider;
        this.threadName = threadName.replace(File.separator, "_slash_");
        this.name = name;
        this.extensionOrNull = extensionOrNull;
    }

    public String generateFilename() {
        StringBuilder filename = new StringBuilder();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(this.timeProvider.getTimeInMilliseconds());
        String dateSection = DateFormatUtils.ISO_DATE_FORMAT.format((Calendar)calendar);
        filename.append(dateSection);
        filename.append("_");
        String timeSection = DateFormatUtils.format((Calendar)calendar, (String)"HH-mm-ss-SSS");
        filename.append(timeSection);
        filename.append("_");
        filename.append(this.threadName);
        filename.append("_");
        filename.append(this.name);
        if (null != this.extensionOrNull) {
            filename.append(this.extensionOrNull);
        }
        return filename.toString();
    }
}

