/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.ethz.sis.openbis.generic.server.dss.plugins.PreStagingCleanUpMaintenanceTask;
import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.base.exceptions.InterruptedExceptionUnchecked;
import ch.systemsx.cisd.common.concurrent.TimerUtilities;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.HighLevelException;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.filesystem.DirectoryScanningTimerTask;
import ch.systemsx.cisd.common.filesystem.FaultyPathDirectoryScanningHandler;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.filesystem.HostAwareFile;
import ch.systemsx.cisd.common.filesystem.IDirectoryScanningHandler;
import ch.systemsx.cisd.common.filesystem.ILastModificationChecker;
import ch.systemsx.cisd.common.filesystem.IPathHandler;
import ch.systemsx.cisd.common.filesystem.IStopSignaler;
import ch.systemsx.cisd.common.filesystem.IStoreItemFilter;
import ch.systemsx.cisd.common.filesystem.LastModificationChecker;
import ch.systemsx.cisd.common.filesystem.QueueingPathRemoverService;
import ch.systemsx.cisd.common.filesystem.QuietPeriodFileFilter;
import ch.systemsx.cisd.common.filesystem.StoreItem;
import ch.systemsx.cisd.common.filesystem.highwatermark.HighwaterMarkDirectoryScanningHandler;
import ch.systemsx.cisd.common.filesystem.highwatermark.HighwaterMarkWatcher;
import ch.systemsx.cisd.common.filesystem.highwatermark.HostAwareFileWithHighwaterMark;
import ch.systemsx.cisd.common.logging.ISimpleLogger;
import ch.systemsx.cisd.common.logging.Log4jSimpleLogger;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.common.mail.MailClient;
import ch.systemsx.cisd.common.maintenance.IMaintenanceTask;
import ch.systemsx.cisd.common.maintenance.MaintenancePlugin;
import ch.systemsx.cisd.common.maintenance.MaintenanceTaskParameters;
import ch.systemsx.cisd.common.maintenance.MaintenanceTaskUtils;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.common.reflection.ClassUtils;
import ch.systemsx.cisd.common.time.TimingParameters;
import ch.systemsx.cisd.common.utilities.IExitHandler;
import ch.systemsx.cisd.common.utilities.ISelfTestable;
import ch.systemsx.cisd.common.utilities.SystemExit;
import ch.systemsx.cisd.etlserver.DynamicTransactionQueryFactory;
import ch.systemsx.cisd.etlserver.ITopLevelDataSetRegistrator;
import ch.systemsx.cisd.etlserver.Parameters;
import ch.systemsx.cisd.etlserver.ThreadParameters;
import ch.systemsx.cisd.etlserver.TopLevelDataSetRegistratorGlobalState;
import ch.systemsx.cisd.etlserver.TransferredDataSetHandler;
import ch.systemsx.cisd.etlserver.plugins.DeleteDataSetsAlreadyDeletedInApplicationServerMaintenanceTask;
import ch.systemsx.cisd.etlserver.postregistration.PostRegistrationMaintenanceTask;
import ch.systemsx.cisd.etlserver.registrator.recovery.DataSetStorageRecoveryManager;
import ch.systemsx.cisd.etlserver.validation.DataSetValidator;
import ch.systemsx.cisd.etlserver.validation.IDataSetValidator;
import ch.systemsx.cisd.openbis.dss.BuildAndEnvironmentInfo;
import ch.systemsx.cisd.openbis.dss.generic.shared.DataSourceQueryService;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.IncomingShareIdProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.QueueingDataSetStatusUpdaterService;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.IDataSourceQueryService;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetCodesWithStatus;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.DssPropertyParametersUtil;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.SegmentedStoreUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseInstance;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public final class ETLDaemon {
    public static final File shredderQueueFile = new File(".shredder");
    public static final File updaterQueueFile = new File(".updater");
    public static final File dropboxActivityDir = new File(".activity");
    public static final int INJECTED_POST_REGISTRATION_TASK_INTERVAL = 10;
    static final String NOTIFY_SUCCESSFUL_REGISTRATION = "notify-successful-registration";
    public static final String RECOVERY_HIGHWATER_MARK_PROPERTY_KEY = "recovery-highwater-mark";
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, ETLDaemon.class);
    private static final Logger notificationLog = LogFactory.getLogger((LogCategory)LogCategory.NOTIFY, ETLDaemon.class);
    @Private
    static IExitHandler exitHandler = SystemExit.SYSTEM_EXIT;
    private static ThreadParameters[] threads;

    public static ThreadParameters[] getThreadParameters() {
        return threads;
    }

    private static void printInitialLogMessage(Parameters parameters) {
        operationLog.info((Object)"Data Store Server is starting up.");
        for (String line : BuildAndEnvironmentInfo.INSTANCE.getEnvironmentInfo()) {
            operationLog.info((Object)line);
        }
        parameters.log();
    }

    public static void listShredder() {
        List shredderItems = QueueingPathRemoverService.listShredderItems((File)shredderQueueFile);
        if (shredderItems.isEmpty()) {
            System.out.println("Shredder is empty.");
        } else {
            System.out.println("Found " + shredderItems.size() + " items in shredder:");
            for (File f : shredderItems) {
                System.out.println(f.getAbsolutePath());
            }
        }
    }

    public static void listUpdaterQueue() {
        List<DataSetCodesWithStatus> items = QueueingDataSetStatusUpdaterService.listItems(updaterQueueFile);
        if (items.isEmpty()) {
            System.out.println("Updater queue is empty.");
        } else {
            System.out.println("Found " + items.size() + " items in updater:");
            for (DataSetCodesWithStatus item : items) {
                System.out.println(item);
            }
        }
    }

    private static void selfTest(File incomingDirectory, IEncapsulatedOpenBISService service, ISelfTestable ... selfTestables) {
        String msgStart = "Data Store Server self test failed:";
        Object currentSelfTestableOrNull = null;
        try {
            ETLDaemon.checkFullyAccesible(incomingDirectory);
            int serviceVersion = service.getVersion();
            if (35 != serviceVersion) {
                throw new ConfigurationFailureException("This client has the wrong service version for the server (client: 35, server: " + serviceVersion + ").");
            }
            for (ISelfTestable selfTestableOrNull : selfTestables) {
                if (selfTestableOrNull == null) continue;
                currentSelfTestableOrNull = selfTestableOrNull;
                selfTestableOrNull.check();
            }
        }
        catch (HighLevelException e) {
            if (currentSelfTestableOrNull != null && currentSelfTestableOrNull.isRemote()) {
                notificationLog.error((Object)("Self test on self-testable " + currentSelfTestableOrNull.getClass().getSimpleName() + " failed. This it relies on a remote resource which might become available at at later time, we keep the server running anyway."), (Throwable)e);
            } else {
                System.err.printf("Data Store Server self test failed: [%s: %s]\n", ((Object)((Object)e)).getClass().getSimpleName(), e.getMessage());
                exitHandler.exit(1);
            }
        }
        catch (RuntimeException e) {
            System.err.println("Data Store Server self test failed:");
            e.printStackTrace();
            exitHandler.exit(1);
        }
        if (TimerUtilities.isOperational()) {
            if (operationLog.isDebugEnabled()) {
                operationLog.debug((Object)"Timer task interruption is operational.");
            }
        } else {
            operationLog.warn((Object)"Timer task interruption is not operational. No clean up can be performed on extraordinary shutdown.");
        }
    }

    private static void checkFullyAccesible(File directory) throws ConfigurationFailureException {
        String errorMessage;
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)("Checking source directory '" + directory.getAbsolutePath() + "'."));
        }
        if ((errorMessage = FileUtilities.checkDirectoryFullyAccessible((File)directory, (String)"source")) != null) {
            throw new ConfigurationFailureException(errorMessage);
        }
    }

    private static void startupServer(Parameters parameters) {
        threads = parameters.getThreads();
        IEncapsulatedOpenBISService openBISService = ServiceProvider.getOpenBISService();
        Properties properties = parameters.getProperties();
        boolean notifySuccessfulRegistration = ETLDaemon.getNotifySuccessfulRegistration(properties);
        DataSetValidator dataSetValidator = new DataSetValidator(properties);
        Properties mailProperties = Parameters.createMailProperties(properties);
        MailClient mailClient = new MailClient(mailProperties);
        for (ThreadParameters threadParameters : threads) {
            File incomingDataDirectory = threadParameters.getIncomingDataDirectory();
            ITopLevelDataSetRegistrator topLevelRegistrator = ETLDaemon.createProcessingThread(parameters, threadParameters, openBISService, (IMailClient)mailClient, dataSetValidator, notifySuccessfulRegistration);
            operationLog.info((Object)("[" + threadParameters.getThreadName() + "]: Data sets drop into '" + incomingDataDirectory + "' will be stored in share " + topLevelRegistrator.getGlobalState().getShareId() + "."));
        }
        File storeRootDir = DssPropertyParametersUtil.getStoreRootDir(parameters.getProperties());
        ETLDaemon.initializeIncomingShares(threads, storeRootDir);
        mailClient.sendTestEmail();
    }

    private static void initializeIncomingShares(ThreadParameters[] threads, File storeRootDir) {
        ArrayList<String> incomingShares = new ArrayList<String>();
        for (ThreadParameters threadParameters : threads) {
            File incomingDataDirectory = threadParameters.getIncomingDataDirectory();
            Integer incomingShareIdOrNull = threadParameters.getIncomingShareId();
            String shareId = SegmentedStoreUtils.findIncomingShare(incomingDataDirectory, storeRootDir, incomingShareIdOrNull, (ISimpleLogger)new Log4jSimpleLogger(operationLog));
            incomingShares.add(shareId);
        }
        IncomingShareIdProvider.add(incomingShares);
    }

    @Private
    static final void migrateStoreRootDir(File storeRootDir, DatabaseInstance databaseInstance) {
        File[] instanceDirs = storeRootDir.listFiles((FilenameFilter)new NameFileFilter("Instance_" + databaseInstance.getCode()));
        int size = instanceDirs.length;
        assert (size == 0 || size == 1) : "Wrong size of instance directories.";
        String absolutePath = storeRootDir.getAbsolutePath();
        if (size == 0) {
            if (operationLog.isDebugEnabled()) {
                operationLog.debug((Object)String.format("No instance directory has been renamed in store root directory '%s'.", absolutePath));
            }
        } else {
            File instanceDir = instanceDirs[0];
            File newName = new File(storeRootDir, "Instance_" + databaseInstance.getUuid());
            instanceDir.renameTo(newName);
            if (operationLog.isInfoEnabled()) {
                operationLog.info((Object)String.format("Following instance directory '%s' has been renamed to '%s' in store root directory '%s'.", instanceDir.getName(), newName.getName(), absolutePath));
            }
        }
    }

    private static final long getRecoveryHighwaterMark(Properties properties) {
        return PropertyUtils.getLong((Properties)properties, (String)RECOVERY_HIGHWATER_MARK_PROPERTY_KEY, (long)-1L);
    }

    private static final boolean getNotifySuccessfulRegistration(Properties properties) {
        return PropertyUtils.getBoolean((Properties)properties, (String)NOTIFY_SUCCESSFUL_REGISTRATION, (boolean)false);
    }

    private static final ITopLevelDataSetRegistrator createProcessingThread(Parameters parameters, ThreadParameters threadParameters, IEncapsulatedOpenBISService authorizedLimsService, IMailClient mailClient, IDataSetValidator dataSetValidator, boolean notifySuccessfulRegistration) {
        long highwaterMark = DssPropertyParametersUtil.getHighwaterMark(threadParameters, parameters.getProperties());
        HighwaterMarkWatcher highwaterMarkWatcher = new HighwaterMarkWatcher(highwaterMark);
        File incomingDataDirectory = threadParameters.getIncomingDataDirectory();
        File recoveryStateDirectory = DssPropertyParametersUtil.getDssRecoveryStateDir(parameters.getProperties());
        HostAwareFile hostAwareIncomingDataDirectory = new HostAwareFile(incomingDataDirectory);
        HostAwareFileWithHighwaterMark hostAwareRecoveryStateDirectory = new HostAwareFileWithHighwaterMark(recoveryStateDirectory.getPath(), ETLDaemon.getRecoveryHighwaterMark(parameters.getProperties()));
        ITopLevelDataSetRegistrator pathHandler = ETLDaemon.createTopLevelDataSetRegistrator(parameters.getProperties(), threadParameters, authorizedLimsService, mailClient, dataSetValidator, new DataSourceQueryService(), notifySuccessfulRegistration);
        TopLevelDataSetRegistratorGlobalState globalState = pathHandler.getGlobalState();
        HostAwareFile shareFolder = new HostAwareFile(new File(globalState.getStoreRootDir(), globalState.getShareId()));
        HighwaterMarkDirectoryScanningHandler directoryScanningHandler = ETLDaemon.createDirectoryScanningHandler((IStopSignaler)pathHandler, highwaterMarkWatcher, hostAwareIncomingDataDirectory, shareFolder, (HostAwareFile)hostAwareRecoveryStateDirectory, threadParameters.reprocessFaultyDatasets(), parameters.getCheckIntervalMillis(), pathHandler);
        FileFilter fileFilter = ETLDaemon.createFileFilter(incomingDataDirectory, threadParameters.useIsFinishedMarkerFile(), parameters);
        DirectoryScanningTimerTask dataMonitorTask = new DirectoryScanningTimerTask(incomingDataDirectory, fileFilter, (IPathHandler)pathHandler, (IDirectoryScanningHandler)directoryScanningHandler, threadParameters.getThreadName(), dropboxActivityDir);
        ETLDaemon.selfTest(incomingDataDirectory, authorizedLimsService, pathHandler);
        String timerThreadName = threadParameters.getThreadName() + " - Incoming Data Monitor";
        Timer workerTimer = new Timer(timerThreadName);
        workerTimer.schedule((TimerTask)dataMonitorTask, 0L, parameters.getCheckIntervalMillis());
        ETLDaemon.addShutdownHookForCleanup(workerTimer, pathHandler, parameters.getShutdownTimeOutMillis(), threadParameters.getThreadName());
        return pathHandler;
    }

    public static ITopLevelDataSetRegistrator createTopLevelDataSetRegistrator(Properties properties, ThreadParameters threadParameters, IEncapsulatedOpenBISService openBISService, IMailClient mailClient, IDataSetValidator dataSetValidator, IDataSourceQueryService dataSourceQueryService, boolean notifySuccessfulRegistration) {
        TopLevelDataSetRegistratorInititializationData initializationData = new TopLevelDataSetRegistratorInititializationData(properties, threadParameters, openBISService);
        TopLevelDataSetRegistratorGlobalState globalState = new TopLevelDataSetRegistratorGlobalState(initializationData.dssCode, initializationData.shareId, initializationData.storeRootDir, initializationData.dssInternalTempDir, initializationData.dssRegistrationLogDir, initializationData.dssRecoveryStateDir, openBISService, mailClient, dataSetValidator, dataSourceQueryService, new DynamicTransactionQueryFactory(), notifySuccessfulRegistration, threadParameters, new DataSetStorageRecoveryManager());
        try {
            ITopLevelDataSetRegistrator registrator = (ITopLevelDataSetRegistrator)ClassUtils.create(ITopLevelDataSetRegistrator.class, threadParameters.getTopLevelDataSetRegistratorClass(TransferredDataSetHandler.class), (Object[])new Object[]{globalState});
            return registrator;
        }
        catch (ConfigurationFailureException e) {
            throw new ConfigurationFailureException("Couldn't create a dropbox " + threadParameters.getThreadName(), (Throwable)e);
        }
    }

    public static ITopLevelDataSetRegistrator createTopLevelDataSetRegistrator(Properties properties, ThreadParameters threadParameters, IEncapsulatedOpenBISService openBISService, IMailClient mailClient, IDataSetValidator dataSetValidator, IDataSourceQueryService dataSourceQueryService, boolean notifySuccessfulRegistration, boolean useIsFinishedMarkerFile, boolean deleteUnidentified, String preRegistrationScriptOrNull, String postRegistrationScriptOrNull, String[] validationScriptsOrNull, Class<?> defaultTopLevelDataSetRegistratorClass) {
        TopLevelDataSetRegistratorInititializationData initializationData = new TopLevelDataSetRegistratorInititializationData(properties, threadParameters, openBISService);
        TopLevelDataSetRegistratorGlobalState globalState = new TopLevelDataSetRegistratorGlobalState(initializationData.dssCode, initializationData.shareId, initializationData.storeRootDir, initializationData.dssInternalTempDir, initializationData.dssRegistrationLogDir, initializationData.dssRecoveryStateDir, openBISService, mailClient, dataSetValidator, dataSourceQueryService, new DynamicTransactionQueryFactory(), notifySuccessfulRegistration, threadParameters, useIsFinishedMarkerFile, deleteUnidentified, preRegistrationScriptOrNull, postRegistrationScriptOrNull, validationScriptsOrNull, new DataSetStorageRecoveryManager());
        ITopLevelDataSetRegistrator registrator = (ITopLevelDataSetRegistrator)ClassUtils.create(ITopLevelDataSetRegistrator.class, threadParameters.getTopLevelDataSetRegistratorClass(defaultTopLevelDataSetRegistratorClass), (Object[])new Object[]{globalState});
        return registrator;
    }

    private static String getShareId(ThreadParameters threadParams, File storeRoot) {
        File incomingDirectory = threadParams.getIncomingDataDirectory();
        Integer incomingShareIdOrNull = threadParams.getIncomingShareId();
        return SegmentedStoreUtils.findIncomingShare(incomingDirectory, storeRoot, incomingShareIdOrNull, (ISimpleLogger)new Log4jSimpleLogger(operationLog));
    }

    private static FileFilter createFileFilter(File incomingDataDirectory, boolean useIsFinishedMarkerFile, Parameters parameters) {
        if (useIsFinishedMarkerFile) {
            return FileFilterUtils.prefixFileFilter((String)".MARKER_is_finished_");
        }
        return ETLDaemon.createQuietPeriodFilter(incomingDataDirectory, parameters);
    }

    private static FileFilter createQuietPeriodFilter(final File incomingDataDirectory, Parameters parameters) {
        int ignoredErrorCountBeforeNotification = 3;
        LastModificationChecker lastModificationChecker = new LastModificationChecker(incomingDataDirectory);
        QuietPeriodFileFilter quietPeriodFilter = new QuietPeriodFileFilter((ILastModificationChecker)lastModificationChecker, parameters.getQuietPeriodMillis(), ignoredErrorCountBeforeNotification);
        return new FileFilter((IStoreItemFilter)quietPeriodFilter){
            final /* synthetic */ IStoreItemFilter val$quietPeriodFilter;
            {
                this.val$quietPeriodFilter = iStoreItemFilter;
            }

            @Override
            public boolean accept(File pathname) {
                assert (pathname.getParentFile().getAbsolutePath().equals(incomingDataDirectory.getAbsolutePath())) : "The file should come to the filter only from the incoming directory";
                StoreItem storeItem = new StoreItem(pathname.getName());
                return this.val$quietPeriodFilter.accept(storeItem);
            }
        };
    }

    private static void addShutdownHookForCleanup(final Timer workerTimer, final ITopLevelDataSetRegistrator mover, final long timeoutMillis, final String threadName) {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    if (operationLog.isInfoEnabled()) {
                        operationLog.info((Object)("Requesting shutdown lock of thread '" + threadName + "'."));
                    }
                    long startTimeMillis = System.currentTimeMillis();
                    boolean lockOK = mover.getRegistrationLock().tryLock(timeoutMillis, TimeUnit.MILLISECONDS);
                    long timeoutLeftMillis = Math.max(timeoutMillis / 2L, timeoutMillis - (System.currentTimeMillis() - startTimeMillis));
                    if (!lockOK) {
                        operationLog.error((Object)("Failed to get lock for shutdown of thread '" + threadName + "'."));
                    }
                    try {
                        if (operationLog.isInfoEnabled()) {
                            operationLog.info((Object)String.format("Initiating shutdown sequence [maximal shutdown time: %ds].", 2L * timeoutLeftMillis / 1000L));
                        }
                        boolean shutdownOK = TimerUtilities.tryShutdownTimer((Timer)workerTimer, (long)timeoutLeftMillis);
                        operationLog.log((Priority)(shutdownOK ? Level.INFO : Level.ERROR), (Object)("Worker thread shutdown, status=" + (shutdownOK ? "OK" : "FAILED")));
                    }
                    finally {
                        if (lockOK) {
                            mover.getRegistrationLock().unlock();
                        }
                    }
                    operationLog.warn((Object)"Shutting down shredder(s)");
                    QueueingPathRemoverService.stopAndWait((long)timeoutMillis);
                }
                catch (InterruptedException ex) {
                    throw new InterruptedExceptionUnchecked(ex);
                }
                finally {
                    if (operationLog.isInfoEnabled()) {
                        operationLog.info((Object)"Shutting down now.");
                    }
                }
            }
        }, threadName + " - Shutdown Handler"));
    }

    private static final HighwaterMarkDirectoryScanningHandler createDirectoryScanningHandler(IStopSignaler stopSignaler, HighwaterMarkWatcher highwaterMarkWatcher, HostAwareFile incomingDataDirectory, HostAwareFile shareFolder, HostAwareFile recoveryStateDirectory, boolean reprocessFaultyDatasets, long checkIntervalMillis, FaultyPathDirectoryScanningHandler.IFaultyPathDirectoryScanningHandlerDelegate faultyPathHandlerDelegate) {
        IDirectoryScanningHandler faultyPathHandler = ETLDaemon.createFaultyPathHandler(stopSignaler, incomingDataDirectory.getLocalFile(), reprocessFaultyDatasets, checkIntervalMillis, faultyPathHandlerDelegate);
        return new HighwaterMarkDirectoryScanningHandler(faultyPathHandler, highwaterMarkWatcher, new HostAwareFile[]{shareFolder, recoveryStateDirectory});
    }

    private static IDirectoryScanningHandler createFaultyPathHandler(IStopSignaler stopSignaler, File incomingDataDirectory, boolean reprocessFaultyDatasets, long checkIntervalMillis, FaultyPathDirectoryScanningHandler.IFaultyPathDirectoryScanningHandlerDelegate faultyPathHandlerDelegate) {
        if (reprocessFaultyDatasets) {
            return ETLDaemon.createDummyFaultyPathHandler(checkIntervalMillis);
        }
        return new FaultyPathDirectoryScanningHandler(incomingDataDirectory, stopSignaler, faultyPathHandlerDelegate);
    }

    private static IDirectoryScanningHandler createDummyFaultyPathHandler(final long checkIntervalMillis) {
        return new IDirectoryScanningHandler(){
            private Map<String, Long> faultyItems = new HashMap<String, Long>();

            public void init(DirectoryScanningTimerTask.IScannedStore scannedStore) {
                long now = System.currentTimeMillis();
                Iterator<Map.Entry<String, Long>> it = this.faultyItems.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, Long> e = it.next();
                    if (now - e.getValue() <= 3L * checkIntervalMillis) continue;
                    it.remove();
                }
            }

            public void beforeHandle(DirectoryScanningTimerTask.IScannedStore scannedStore) {
            }

            public Status finishItemHandle(DirectoryScanningTimerTask.IScannedStore scannedStore, StoreItem storeItem) {
                if (scannedStore.existsOrError(storeItem)) {
                    if (!this.faultyItems.containsKey(storeItem.getName())) {
                        StringBuffer sb = new StringBuffer();
                        sb.append("The thread configuration setting reprocess-faulty-datasets = true.");
                        sb.append(" File " + storeItem + " not written to faulty paths. It will be reprocessed until successfull or removed.");
                        operationLog.info((Object)sb.toString());
                    }
                    this.faultyItems.put(storeItem.getName(), System.currentTimeMillis());
                }
                return Status.OK;
            }

            public IDirectoryScanningHandler.HandleInstruction mayHandle(DirectoryScanningTimerTask.IScannedStore scannedStore, StoreItem storeItem) {
                return IDirectoryScanningHandler.HandleInstruction.PROCESS;
            }
        };
    }

    public static final void main(String[] args) {
        Parameters parameters = null;
        try {
            parameters = new Parameters(args);
        }
        catch (ConfigurationFailureException ex) {
            operationLog.error((Object)("Cannot launch the server, bacause of the misconfiguraton: " + ex.getMessage()), (Throwable)ex);
            System.exit(1);
        }
        ETLDaemon.run(parameters);
    }

    private static void run(Parameters parameters) {
        TimingParameters.setDefault((TimingParameters)parameters.getTimingParameters());
        if (!QueueingPathRemoverService.isRunning()) {
            QueueingPathRemoverService.start((File)DssPropertyParametersUtil.getStoreRootDir(parameters.getProperties()), (File)shredderQueueFile);
        }
        if (!QueueingDataSetStatusUpdaterService.isRunning()) {
            QueueingDataSetStatusUpdaterService.start(updaterQueueFile);
        }
        ETLDaemon.printInitialLogMessage(parameters);
        ETLDaemon.startupServer(parameters);
        MaintenanceTaskParameters[] maintenancePlugins = parameters.getMaintenancePlugins();
        ETLDaemon.assertNotMoreThanOnePostRegistrationMaintenanceTask(maintenancePlugins);
        MaintenanceTaskUtils.startupMaintenancePlugins((MaintenanceTaskParameters[])maintenancePlugins);
        ETLDaemon.injectPostRegistrationMaintenanceTaskIfNecessary(maintenancePlugins);
        ETLDaemon.injectMaintenanceTask(maintenancePlugins, DeleteDataSetsAlreadyDeletedInApplicationServerMaintenanceTask.class, 300, "injected-delete-datasets-already-deleted-from-application-server-task");
        ETLDaemon.injectMaintenanceTask(maintenancePlugins, PreStagingCleanUpMaintenanceTask.class, 86400, "pre-staging-clean-up-task");
        operationLog.info((Object)"Data Store Server ready and waiting for data.");
    }

    private static void assertNotMoreThanOnePostRegistrationMaintenanceTask(MaintenanceTaskParameters[] maintenancePlugins) {
        HashSet<String> postRegistrationMaintenanceTasks = new HashSet<String>();
        for (MaintenanceTaskParameters maintenanceTaskParameters : maintenancePlugins) {
            try {
                Class<?> clazz = Class.forName(maintenanceTaskParameters.getClassName());
                if (!PostRegistrationMaintenanceTask.class.isAssignableFrom(clazz)) continue;
                postRegistrationMaintenanceTasks.add(maintenanceTaskParameters.getPluginName());
            }
            catch (ClassNotFoundException ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
            }
        }
        if (postRegistrationMaintenanceTasks.size() > 1) {
            throw new ConfigurationFailureException("There are more than one post registration maintenance tasks: " + postRegistrationMaintenanceTasks);
        }
    }

    private static void injectPostRegistrationMaintenanceTaskIfNecessary(MaintenanceTaskParameters[] maintenancePlugins) {
        if (ETLDaemon.hasMaintenanceTaskOfClass(maintenancePlugins, PostRegistrationMaintenanceTask.class)) {
            return;
        }
        PostRegistrationMaintenanceTask task = new PostRegistrationMaintenanceTask();
        task.setUpEmpty();
        ETLDaemon.injectMaintenanceTask(PostRegistrationMaintenanceTask.class, (IMaintenanceTask)task, 10, "injected-post-registration-task");
    }

    private static void injectMaintenanceTask(MaintenanceTaskParameters[] maintenancePlugins, Class<? extends IMaintenanceTask> taskClass, int interval, String pluginName) {
        if (ETLDaemon.hasMaintenanceTaskOfClass(maintenancePlugins, taskClass)) {
            return;
        }
        ETLDaemon.injectMaintenanceTask(taskClass, null, interval, pluginName);
    }

    private static void injectMaintenanceTask(Class<? extends IMaintenanceTask> taskClass, IMaintenanceTask task, int interval, String pluginName) {
        Properties props = new Properties();
        props.setProperty("class", taskClass.getName());
        props.setProperty("interval", Integer.toString(interval));
        MaintenanceTaskParameters parameters = new MaintenanceTaskParameters(props, pluginName);
        MaintenancePlugin plugin = task == null ? new MaintenancePlugin(parameters) : new MaintenancePlugin(task, parameters);
        MaintenanceTaskUtils.injectMaintenancePlugin((MaintenancePlugin)plugin);
    }

    private static boolean hasMaintenanceTaskOfClass(MaintenanceTaskParameters[] tasks, Class<?> taskClass) {
        for (MaintenanceTaskParameters task : tasks) {
            if (!taskClass.getName().equals(task.getClassName())) continue;
            return true;
        }
        return false;
    }

    public static void runForTesting(String[] args) {
        exitHandler = new IExitHandler(){

            public void exit(int exitCode) {
                throw new AssertionError((Object)("Unexpected exit: " + exitCode));
            }
        };
        Parameters parameters = new Parameters(args, exitHandler);
        ETLDaemon.run(parameters);
    }

    private static class TopLevelDataSetRegistratorInititializationData {
        private final File storeRootDir;
        private final File dssInternalTempDir;
        private final File dssRegistrationLogDir;
        private final File dssRecoveryStateDir;
        private final String dssCode;
        private final String shareId;

        public TopLevelDataSetRegistratorInititializationData(Properties properties, ThreadParameters threadParameters, IEncapsulatedOpenBISService openBISService) {
            this.storeRootDir = DssPropertyParametersUtil.getStoreRootDir(properties);
            ETLDaemon.migrateStoreRootDir(this.storeRootDir, openBISService.getHomeDatabaseInstance());
            this.dssInternalTempDir = DssPropertyParametersUtil.getDssInternalTempDir(properties);
            this.dssRegistrationLogDir = DssPropertyParametersUtil.getDssRegistrationLogDir(properties);
            this.dssRecoveryStateDir = DssPropertyParametersUtil.getDssRecoveryStateDir(properties);
            this.dssCode = DssPropertyParametersUtil.getDataStoreCode(properties);
            this.shareId = ETLDaemon.getShareId(threadParameters, this.storeRootDir);
        }
    }
}

