/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.properties.PropertyParametersUtil;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.etlserver.IFileFormatTypeExtractor;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.FileFormatType;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class FileTypeExtractor
implements IFileFormatTypeExtractor {
    public static final String FILE_TYPES_NAME = "file-types";
    private static final String TYPE_MAPPING_SEPARATOR = ":";
    private static final String LIST_MAPPING_SEPARATOR = " ";
    @Private
    static final String DEFAULT_TYPE_PROPERTY_KEY = "default-file-type";
    @Private
    static final String DEFAULT_FILE_FORMAT_TYPE = "UNKNOWN";
    @Private
    static final String DIRECTORY_TYPE_PROPERTY_KEY = "directory-file-type";
    @Private
    static final String DIRECTORY_FILE_FORMAT_TYPE = "UNKNOWN";
    private final Map<String, String> fileTypeMapping;
    private final String defaultType;
    private final String directoryType;

    public FileTypeExtractor(Properties properties) {
        this.fileTypeMapping = FileTypeExtractor.createTypeByFileExtensionMap(properties, FILE_TYPES_NAME);
        this.defaultType = FileTypeExtractor.normalizeExtension(PropertyUtils.getProperty((Properties)properties, (String)DEFAULT_TYPE_PROPERTY_KEY, (String)"UNKNOWN"));
        this.directoryType = FileTypeExtractor.normalizeExtension(PropertyUtils.getProperty((Properties)properties, (String)DIRECTORY_TYPE_PROPERTY_KEY, (String)"UNKNOWN"));
    }

    public static Map<String, String> createTypeByFileExtensionMap(Properties properties, String itemsListPropertyName) {
        String typesMapping = PropertyUtils.getProperty((Properties)properties, (String)itemsListPropertyName);
        HashMap<String, String> result = new HashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)typesMapping)) {
            return result;
        }
        String[] mappings = PropertyParametersUtil.parseItemisedProperty((String)typesMapping, (String)FILE_TYPES_NAME);
        for (int i = 0; i < mappings.length; ++i) {
            String[] fileExtensions;
            String mapping = mappings[i];
            String[] tokens = mapping.split(TYPE_MAPPING_SEPARATOR);
            if (tokens.length != 2 || StringUtils.isBlank((CharSequence)tokens[0]) || StringUtils.isBlank((CharSequence)tokens[1])) {
                throw ConfigurationFailureException.fromTemplate((String)"Wrong value of property '%s = %s'. The item '%s' has incorrect format.\nThe value should be a comma separated list of mappings from type to extensions, e.g:\ntype1: file-extension1 file-extension2, type2: file-extension3", (Object[])new Object[]{FILE_TYPES_NAME, typesMapping, mapping});
            }
            String fileType = tokens[0].toUpperCase();
            for (String extension : fileExtensions = tokens[1].trim().split(LIST_MAPPING_SEPARATOR)) {
                result.put(FileTypeExtractor.normalizeExtension(extension), fileType);
            }
        }
        return result;
    }

    @Override
    public final FileFormatType getFileFormatType(File incomingDataSetPath) {
        String fileType;
        if (incomingDataSetPath.isDirectory()) {
            fileType = this.directoryType;
        } else {
            String fileExtension = FileTypeExtractor.getExtension(incomingDataSetPath);
            fileType = this.getFileTypeCode(fileExtension);
        }
        return new FileFormatType(fileType);
    }

    private String getFileTypeCode(String fileExtension) {
        String fileType = this.getMappedType(fileExtension);
        if (fileType == null) {
            return this.defaultType == null ? fileExtension : this.defaultType;
        }
        return fileType;
    }

    protected String getMappedType(String fileExtension) {
        return this.fileTypeMapping.get(fileExtension);
    }

    protected static String getExtension(File incomingDataSetPath) {
        String extension = FilenameUtils.getExtension((String)incomingDataSetPath.getName());
        return FileTypeExtractor.normalizeExtension(extension);
    }

    private static String normalizeExtension(String extension) {
        return extension.toUpperCase();
    }
}

