/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.etlserver.IStoreRootDirectoryHolder;
import ch.systemsx.cisd.etlserver.ITypeExtractor;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.generic.shared.dto.StorageFormat;
import java.io.File;
import java.io.Serializable;

public interface IStorageProcessorTransactional
extends IStoreRootDirectoryHolder {
    public static final String STORAGE_PROCESSOR_KEY = "storage-processor";

    public IStorageProcessorTransaction createTransaction(StorageProcessorTransactionParameters var1);

    public StorageFormat getStorageFormat();

    public UnstoreDataAction getDefaultUnstoreDataAction(Throwable var1);

    public static class StorageProcessorTransactionParameters {
        private final DataSetInformation dataSetInformation;
        private final File incomingDataSetDirectory;
        private final File rootDir;

        public StorageProcessorTransactionParameters(DataSetInformation dataSetInformation, File incomingDataSetDirectory, File rootDir) {
            this.dataSetInformation = dataSetInformation;
            this.incomingDataSetDirectory = incomingDataSetDirectory;
            this.rootDir = rootDir;
        }

        public DataSetInformation getDataSetInformation() {
            return this.dataSetInformation;
        }

        public File getIncomingDataSetDirectory() {
            return this.incomingDataSetDirectory;
        }

        public File getRootDir() {
            return this.rootDir;
        }
    }

    public static interface IStorageProcessorTransaction
    extends Serializable {
        public void storeData(ITypeExtractor var1, IMailClient var2, File var3);

        public void commit();

        public UnstoreDataAction rollback(Throwable var1);

        public File getStoredDataDirectory();

        public void setStoredDataDirectory(File var1);

        public File tryGetProprietaryData();
    }

    public static enum UnstoreDataAction {
        MOVE_TO_ERROR,
        LEAVE_UNTOUCHED,
        DELETE;

    }
}

