/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.etlserver.DataStoreStrategyKey;
import ch.systemsx.cisd.etlserver.IDataStoreStrategy;
import ch.systemsx.cisd.etlserver.IdentifiedDataStrategy;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import java.io.File;
import java.util.regex.Pattern;

final class NamedDataStrategy
implements IDataStoreStrategy {
    private static final Pattern multipleFilesPatterns = Pattern.compile("_\\[([0-9]+)\\]");
    private final DataStoreStrategyKey key;

    static final File createTargetPath(File targetPath) {
        assert (targetPath != null) : "Given target path can not be null.";
        String defaultFileName = targetPath.getName() + "_[1]";
        return FileUtilities.createNextNumberedFile((File)targetPath, (Pattern)multipleFilesPatterns, (String)defaultFileName);
    }

    NamedDataStrategy(DataStoreStrategyKey key) {
        this.key = key;
    }

    static final String getDirectoryName(DataStoreStrategyKey key) {
        return key.name().toLowerCase();
    }

    private final String getDirectoryName() {
        return NamedDataStrategy.getDirectoryName(this.key);
    }

    private static final void assertBaseDirectory(File baseDirectory) {
        assert (baseDirectory != null) : "Missing base directory.";
    }

    @Override
    public final DataStoreStrategyKey getKey() {
        return this.key;
    }

    @Override
    public final File getBaseDirectory(File baseDirectory, DataSetInformation dataSetInfo, DataSetType dataSetType) {
        NamedDataStrategy.assertBaseDirectory(baseDirectory);
        assert (dataSetType != null) : "Missing data set type.";
        File share = new File(baseDirectory, dataSetInfo.getShareId());
        return new File(new File(share, this.getDirectoryName()), IdentifiedDataStrategy.createDataSetTypeDirectory(dataSetType));
    }

    @Override
    public final File getTargetPath(File baseDirectory, File incomingDataSetPath) {
        NamedDataStrategy.assertBaseDirectory(baseDirectory);
        assert (incomingDataSetPath != null) : "Missing incoming data set path";
        return NamedDataStrategy.createTargetPath(new File(baseDirectory, incomingDataSetPath.getName()));
    }
}

