/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.systemsx.cisd.args4j.CmdLineException;
import ch.systemsx.cisd.args4j.CmdLineParser;
import ch.systemsx.cisd.args4j.ExampleMode;
import ch.systemsx.cisd.args4j.Option;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.HighLevelException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.maintenance.MaintenanceTaskParameters;
import ch.systemsx.cisd.common.maintenance.MaintenanceTaskUtils;
import ch.systemsx.cisd.common.properties.ExtendedProperties;
import ch.systemsx.cisd.common.properties.PropertyParametersUtil;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.common.time.TimingParameters;
import ch.systemsx.cisd.common.utilities.IExitHandler;
import ch.systemsx.cisd.common.utilities.SystemExit;
import ch.systemsx.cisd.common.utilities.VoidExitHandler;
import ch.systemsx.cisd.etlserver.ThreadParameters;
import ch.systemsx.cisd.openbis.dss.BuildAndEnvironmentInfo;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.DssPropertyParametersUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Properties;
import org.apache.log4j.Logger;

public class Parameters {
    private static final String CHECK_INTERVAL_NAME = "check-interval";
    private static final String QUIET_PERIOD_NAME = "quiet-period";
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, Parameters.class);
    private static final Logger notificationLog = LogFactory.getLogger((LogCategory)LogCategory.NOTIFY, Parameters.class);
    @Option(name="s", longName="server-url", metaVar="URL", usage="URL of the server")
    private String serverURL;
    @Option(name="c", longName="check-interval", usage="The interval to wait between two checks (in seconds) [default: 120]")
    private long checkIntervalSeconds;
    @Option(name="q", longName="quiet-period", usage="The period of no write access that needs to pass before an incoming data item is considered complete and ready to be processed (in seconds) [default: 300]. Valid only when auto-detection method is used to determine if an incoming data are ready to be processed.")
    private long quietPeriodMillis;
    @Option(name="t", longName="shutdown-timeout", usage="The time-out for clean up work in the shutdown sequence (in seconds) [default: 30]")
    private long shutdownTimeOutSeconds;
    @Option(name="u", longName="username", usage="User login name")
    private String username;
    @Option(name="p", longName="password", usage="User login password")
    private String password;
    private final CmdLineParser parser = new CmdLineParser((Object)this);
    private final TimingParameters timingParameters;
    private final Properties serviceProperties;
    private final ThreadParameters[] threads;
    private MaintenanceTaskParameters[] maintenancePlugins;

    @Option(longName="help", skipForExample=true, usage="Prints out a description of the options.")
    void printHelp(boolean exit) {
        this.parser.printHelp("etlserver", "<required options> [option [...]]", "", ExampleMode.ALL);
        if (exit) {
            System.exit(0);
        }
    }

    @Option(longName="version", skipForExample=true, usage="Prints out the version information.")
    void printVersion(boolean exit) {
        System.err.println("etlserver version " + BuildAndEnvironmentInfo.INSTANCE.getFullVersion());
        if (exit) {
            System.exit(0);
        }
    }

    @Option(longName="test-notify", skipForExample=true, usage="Tests the notify log (i.e. that an email is sent out).")
    void sendTestNotification(boolean exit) {
        notificationLog.error((Object)"This is a test notification given due to specifying the --test-notify option.");
        if (exit) {
            System.exit(0);
        }
    }

    public static Parameters createParametersForApiUse() {
        return new Parameters(new String[0], (IExitHandler)VoidExitHandler.INSTANCE, false);
    }

    Parameters(String[] args) {
        this(args, SystemExit.SYSTEM_EXIT);
    }

    Parameters(String[] args, IExitHandler systemExitHandler) {
        this(args, systemExitHandler, true);
    }

    Parameters(String[] args, IExitHandler systemExitHandler, boolean checkParameters) {
        try {
            this.serviceProperties = DssPropertyParametersUtil.loadServiceProperties();
            PropertyUtils.trimProperties((Properties)this.serviceProperties);
            this.threads = Parameters.createThreadParameters(this.serviceProperties);
            this.timingParameters = TimingParameters.create((Properties)this.serviceProperties);
            this.maintenancePlugins = MaintenanceTaskUtils.createMaintenancePlugins((Properties)this.serviceProperties);
            this.initCommandLineParametersFromProperties();
            this.parser.parseArgument(args);
            if (checkParameters) {
                this.ensureParametersCorrect();
            }
        }
        catch (Exception ex) {
            this.outputException(ex);
            systemExitHandler.exit(1);
            throw new AssertionError((Object)ex.getMessage());
        }
    }

    public MaintenanceTaskParameters[] getMaintenancePlugins() {
        return this.maintenancePlugins;
    }

    private void ensureParametersCorrect() {
        for (ThreadParameters thread : this.threads) {
            thread.check();
        }
        if (this.serverURL == null) {
            throw new ConfigurationFailureException("No 'server-url' defined.");
        }
    }

    private void initCommandLineParametersFromProperties() {
        this.serverURL = this.serviceProperties.getProperty("server-url");
        this.username = this.serviceProperties.getProperty("username");
        this.password = this.serviceProperties.getProperty("password");
        this.checkIntervalSeconds = Long.parseLong(this.serviceProperties.getProperty(CHECK_INTERVAL_NAME, "120"));
        this.quietPeriodMillis = Long.parseLong(this.serviceProperties.getProperty(QUIET_PERIOD_NAME, "300"));
        this.shutdownTimeOutSeconds = Long.parseLong(this.serviceProperties.getProperty("shutdown-timeout", "30"));
    }

    private static ThreadParameters[] createThreadParameters(Properties serviceProperties) {
        PropertyParametersUtil.SectionProperties[] sectionsProperties = PropertyParametersUtil.extractSectionProperties((Properties)serviceProperties, (String)"inputs", (boolean)true);
        if (sectionsProperties.length == 0) {
            return new ThreadParameters[0];
        }
        return Parameters.asThreadParameters(sectionsProperties);
    }

    private static ThreadParameters[] asThreadParameters(PropertyParametersUtil.SectionProperties[] sectionProperties) {
        ArrayList<ThreadParameters> threadParameters = new ArrayList<ThreadParameters>();
        for (PropertyParametersUtil.SectionProperties section : sectionProperties) {
            String incomingDirs = section.getProperties().getProperty("incoming-dirs");
            if (incomingDirs == null) {
                operationLog.info((Object)("Create parameters for thread '" + section.getKey() + "'."));
                threadParameters.add(new ThreadParameters(section.getProperties(), section.getKey()));
                continue;
            }
            ArrayList<String> dirs = new ArrayList<String>(new LinkedHashSet<String>(Arrays.asList(incomingDirs.split(","))));
            for (int i = 0; i < dirs.size(); ++i) {
                Properties p = (Properties)section.getProperties().clone();
                String incomingDir = ((String)dirs.get(i)).trim();
                p.setProperty("incoming-dir", incomingDir);
                String key = section.getKey() + "[" + (i + 1) + "]";
                operationLog.info((Object)("Create parameters for thread '" + key + "' (incoming-dir: " + incomingDir + ")."));
                threadParameters.add(new ThreadParameters(p, key));
            }
        }
        return threadParameters.toArray(new ThreadParameters[0]);
    }

    public static final Properties createMailProperties(Properties serviceProperties) {
        ExtendedProperties properties = ExtendedProperties.getSubset((Properties)serviceProperties, (String)"mail", (boolean)false);
        if (properties.getProperty("mail.smtp.host") == null) {
            properties.setProperty("mail.smtp.host", "localhost");
        }
        if (properties.getProperty("mail.from") == null) {
            properties.setProperty("mail.from", "etlserver@localhost");
        }
        return properties;
    }

    private void outputException(Exception ex) {
        if (ex instanceof HighLevelException || ex instanceof CmdLineException) {
            System.err.println(ex.getMessage());
        } else {
            System.err.println("An exception occurred.");
            ex.printStackTrace();
        }
        if (ex instanceof CmdLineException) {
            this.printHelp(false);
        }
    }

    public long getCheckIntervalMillis() {
        return this.checkIntervalSeconds * 1000L;
    }

    public long getQuietPeriodMillis() {
        return this.quietPeriodMillis * 1000L;
    }

    public long getShutdownTimeOutMillis() {
        return this.shutdownTimeOutSeconds * 1000L;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.username;
    }

    public final Properties getProperties() {
        return this.serviceProperties;
    }

    public TimingParameters getTimingParameters() {
        return this.timingParameters;
    }

    public void log() {
        if (operationLog.isInfoEnabled()) {
            for (ThreadParameters threadParameters : this.threads) {
                threadParameters.log();
            }
            operationLog.info((Object)String.format("Check intervall: %d s.", this.getCheckIntervalMillis() / 1000L));
            operationLog.info((Object)String.format("Quiet period (valid if auto-detection method is used to determine incoming data completeness): %d s.", this.getQuietPeriodMillis() / 1000L));
        }
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public ThreadParameters[] getThreads() {
        return this.threads;
    }
}

