/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.systemsx.cisd.etlserver.PlateDimension;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.util.EntityHelper;

@Deprecated
public class PlateDimensionParser {
    public static final String PLATE_GEOMETRY_PROPERTY_NAME = "$PLATE_GEOMETRY";

    public static PlateDimension getPlateDimension(IEntityProperty[] properties) {
        PlateDimension plateDimension = PlateDimensionParser.tryToGetPlateDimension(properties);
        if (plateDimension == null) {
            throw new IllegalArgumentException("Cannot find property $PLATE_GEOMETRY");
        }
        return plateDimension;
    }

    public static PlateDimension tryToGetPlateDimension(IEntityProperty[] properties) {
        assert (properties != null) : "Unspecified properties";
        IEntityProperty plateGeometryProperty = EntityHelper.tryFindProperty((IEntityProperty[])properties, (String)PLATE_GEOMETRY_PROPERTY_NAME);
        if (plateGeometryProperty == null) {
            return null;
        }
        String plateGeometryString = plateGeometryProperty.tryGetAsString();
        PlateDimension dimension = PlateDimensionParser.tryParsePlateDimension(plateGeometryString);
        if (dimension == null) {
            throw new IllegalArgumentException("Cannot parse plate geometry " + plateGeometryString);
        }
        return dimension;
    }

    private static PlateDimension tryParsePlateDimension(String plateGeometryString) {
        String[] tokens = plateGeometryString.split("_");
        String sizeToken = tokens[tokens.length - 1];
        String[] dims = sizeToken.split("X");
        if (dims.length != 2) {
            return null;
        }
        Integer rows = PlateDimensionParser.tryParseInteger(dims[0]);
        Integer cols = PlateDimensionParser.tryParseInteger(dims[1]);
        if (rows == null || cols == null) {
            return null;
        }
        return new PlateDimension(rows, cols);
    }

    private static Integer tryParseInteger(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

