/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.properties.ExtendedProperties;
import ch.systemsx.cisd.common.reflection.ClassUtils;
import ch.systemsx.cisd.etlserver.ETLServerPlugin;
import ch.systemsx.cisd.etlserver.IDataSetHandler;
import ch.systemsx.cisd.etlserver.IDataSetInfoExtractor;
import ch.systemsx.cisd.etlserver.IStorageProcessorTransactional;
import ch.systemsx.cisd.etlserver.ITypeExtractor;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import java.util.ArrayList;
import java.util.Properties;

public class PropertiesBasedETLServerPlugin
extends ETLServerPlugin {
    private static final Properties EMPTY_PROPERTIES = new Properties();
    private final Properties properties;

    public static final <T> T create(Class<T> superClazz, Properties properties, String keyPrefix, boolean withSubset, Object ... arguments) {
        String className = properties.getProperty(keyPrefix);
        if (className == null) {
            throw new ConfigurationFailureException("Missing property '" + keyPrefix + "'.");
        }
        try {
            Object[] args = PropertiesBasedETLServerPlugin.gatherArguments(properties, keyPrefix, withSubset, arguments);
            return (T)ClassUtils.create(superClazz, (String)className, (Object[])args);
        }
        catch (IllegalArgumentException ex) {
            throw new ConfigurationFailureException(ex.getMessage());
        }
    }

    private static final Object[] gatherArguments(Properties properties, String keyPrefix, boolean withSubset, Object ... arguments) {
        Properties props = withSubset ? PropertiesBasedETLServerPlugin.createSubsetProperties(properties, keyPrefix) : properties;
        ArrayList<Object> allArgs = new ArrayList<Object>();
        allArgs.add(props);
        for (Object arg : arguments) {
            allArgs.add(arg);
        }
        return allArgs.toArray(new Object[0]);
    }

    public PropertiesBasedETLServerPlugin(Properties properties) {
        super(PropertiesBasedETLServerPlugin.createDataSetInfoExtractor(properties), PropertiesBasedETLServerPlugin.createProcedureAndDataTypeExtractor(properties), PropertiesBasedETLServerPlugin.createStorageProcessor(properties));
        this.properties = properties;
    }

    private static final Properties createSubsetProperties(Properties properties, String prefix) {
        if (prefix == null) {
            return properties;
        }
        return ExtendedProperties.getSubset((Properties)(properties == null ? EMPTY_PROPERTIES : properties), (String)(prefix + '.'), (boolean)true);
    }

    private static final IStorageProcessorTransactional createStorageProcessor(Properties properties) {
        return PropertiesBasedETLServerPlugin.create(IStorageProcessorTransactional.class, properties, "storage-processor", true, new Object[0]);
    }

    private static final ITypeExtractor createProcedureAndDataTypeExtractor(Properties properties) {
        return PropertiesBasedETLServerPlugin.create(ITypeExtractor.class, properties, "type-extractor", true, new Object[0]);
    }

    private static final IDataSetInfoExtractor createDataSetInfoExtractor(Properties properties) {
        return PropertiesBasedETLServerPlugin.create(IDataSetInfoExtractor.class, properties, "data-set-info-extractor", true, new Object[0]);
    }

    @Override
    public IDataSetHandler getDataSetHandler(IDataSetHandler primaryDataSetHandler, IEncapsulatedOpenBISService openbisService) {
        String className = this.properties.getProperty("dataset-handler");
        if (className == null) {
            return primaryDataSetHandler;
        }
        return PropertiesBasedETLServerPlugin.create(IDataSetHandler.class, this.properties, "dataset-handler", false, primaryDataSetHandler, openbisService);
    }
}

