/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.systemsx.cisd.base.exceptions.InterruptedExceptionUnchecked;
import ch.systemsx.cisd.common.filesystem.PathPrefixPrepender;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.etlserver.IFile;
import ch.systemsx.cisd.etlserver.IFileFactory;
import ch.systemsx.cisd.etlserver.IProcessor;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProcessingInstructionDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.StorageFormat;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.log4j.Logger;

final class StandardProcessor
implements IProcessor {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, StandardProcessor.class);
    private static final Logger notificationLog = LogFactory.getLogger((LogCategory)LogCategory.NOTIFY, StandardProcessor.class);
    private final IFileFactory fileFactory;
    private final PathPrefixPrepender pathPrefixPrepender;
    private final String parametersFileName;
    private final MessageFormat finishedFileFormat;
    private final StorageFormat inputDataFormat;
    private final String dataSetCodePrefixGlueCharacter;

    public StandardProcessor(IFileFactory fileFactory, StorageFormat inputDataFormat, PathPrefixPrepender pathPrefixPrepender, String parametersFileName, String finishedFileNameTemplate, String dataSetCodePrefixGlueCharacter) {
        assert (fileFactory != null) : "Unspecified IFileFactory.";
        assert (inputDataFormat != null) : "Unspecified StorageFormat.";
        assert (pathPrefixPrepender != null) : "Unspecified PathPrefixPrepender.";
        assert (parametersFileName != null) : "Unspecified parameters file name.";
        assert (finishedFileNameTemplate != null) : "Unspecified finished file name template.";
        assert (dataSetCodePrefixGlueCharacter != null) : "Unspecified data set code prefix glue character.";
        this.fileFactory = fileFactory;
        this.inputDataFormat = inputDataFormat;
        this.pathPrefixPrepender = pathPrefixPrepender;
        this.parametersFileName = parametersFileName;
        this.finishedFileFormat = new MessageFormat(finishedFileNameTemplate);
        this.dataSetCodePrefixGlueCharacter = dataSetCodePrefixGlueCharacter;
    }

    private void createDataSetForProcessing(File dataSet, IFile dataSetForProcessing) {
        StopWatch watch = new StopWatch();
        watch.start();
        dataSetForProcessing.copyFrom(dataSet);
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)("Data set '" + dataSet.getName() + "' copied into '" + dataSetForProcessing.getAbsolutePath() + "', took " + watch + "."));
        }
    }

    private void createProcessingParameters(ProcessingInstructionDTO instruction, IFile processingDirectory, List<IFile> itemsToRemoveInCaseOfError) {
        byte[] instructionDataOrNull = instruction.getParameters();
        if (instructionDataOrNull != null) {
            IFile parametersFile = this.fileFactory.create(processingDirectory, this.parametersFileName);
            itemsToRemoveInCaseOfError.add(parametersFile);
            parametersFile.write(instructionDataOrNull);
            if (operationLog.isInfoEnabled()) {
                operationLog.info((Object)("Processing parameters written into '" + parametersFile.getAbsolutePath() + "'."));
            }
        }
    }

    private void createFinishedFile(IFile processingDirectory, String dataSetName) {
        String finishedFileName = this.finishedFileFormat.format(new String[]{dataSetName});
        IFile finishedFile = this.fileFactory.create(processingDirectory, finishedFileName);
        finishedFile.write(new byte[0]);
    }

    private final String getDataSetName(DataSetInformation dataSetInformation, File dataSet) {
        String dataSetName = dataSet.getName();
        String parentDataSetCode = dataSetInformation.getDataSetCode();
        if (StringUtils.isNotEmpty((CharSequence)parentDataSetCode)) {
            return parentDataSetCode + this.dataSetCodePrefixGlueCharacter + dataSetName;
        }
        return dataSetName;
    }

    @Override
    public final StorageFormat getRequiredInputDataFormat() {
        return this.inputDataFormat;
    }

    @Override
    public final void initiateProcessing(ProcessingInstructionDTO instruction, DataSetInformation dataSetInformation, File dataSet) {
        assert (instruction != null) : "Unspecified instruction.";
        assert (dataSet != null) : "Unspecified data set.";
        assert (dataSetInformation != null) : "Unspecified data set information.";
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)"Start initialization of processing.");
        }
        String processingPath = this.pathPrefixPrepender.addPrefixTo(instruction.getPath());
        IFile processingDirectory = this.fileFactory.create(processingPath);
        processingDirectory.check();
        String dataSetName = this.getDataSetName(dataSetInformation, dataSet);
        IFile dataSetForProcessing = this.fileFactory.create(processingDirectory, dataSetName);
        ArrayList<IFile> itemsToRemoveInCaseOfError = new ArrayList<IFile>(2);
        itemsToRemoveInCaseOfError.add(dataSetForProcessing);
        try {
            InterruptedExceptionUnchecked.check();
            this.createDataSetForProcessing(dataSet, dataSetForProcessing);
            InterruptedExceptionUnchecked.check();
            this.createProcessingParameters(instruction, processingDirectory, itemsToRemoveInCaseOfError);
            InterruptedExceptionUnchecked.check();
            this.createFinishedFile(processingDirectory, dataSetName);
            if (operationLog.isInfoEnabled()) {
                operationLog.info((Object)"Processing initiated.");
            }
        }
        catch (Exception ex) {
            for (IFile item : itemsToRemoveInCaseOfError) {
                item.delete();
            }
            if (ex instanceof InterruptedExceptionUnchecked) {
                operationLog.warn((Object)String.format("Requested to stop initiation of processing, rolled back: [data set: '%s'].", dataSetForProcessing.getAbsolutePath()));
            }
            notificationLog.error((Object)String.format("Error when initiating processing, rolled back: [data set: '%s'].", dataSetForProcessing.getAbsolutePath()), (Throwable)ex);
        }
    }
}

