/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.etlserver.ETLServerPluginFactory;
import ch.systemsx.cisd.etlserver.IETLServerPlugin;
import ch.systemsx.cisd.etlserver.TransferredDataSetHandler;
import ch.systemsx.cisd.etlserver.registrator.DataSetRegistrationPreStagingBehavior;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.SegmentedStoreUtils;
import java.io.File;
import java.util.Arrays;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public final class ThreadParameters {
    @Private
    static final String PRE_REGISTRATION_SCRIPT_KEY = "pre-registration-script";
    @Private
    static final String POST_REGISTRATION_SCRIPT_KEY = "post-registration-script";
    @Private
    public static final String VALIDATION_SCRIPT_KEY = "validation-script-path";
    @Private
    static final String GROUP_CODE_KEY = "group-code";
    @Private
    public static final String INCOMING_DATA_COMPLETENESS_CONDITION = "incoming-data-completeness-condition";
    @Private
    public static final String INCOMING_DATA_COMPLETENESS_CONDITION_MARKER_FILE = "marker-file";
    @Private
    static final String INCOMING_DATA_COMPLETENESS_CONDITION_AUTODETECTION = "auto-detection";
    @Private
    public static final String TOP_LEVEL_DATA_SET_HANDLER = "top-level-data-set-handler";
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, ThreadParameters.class);
    @Private
    public static final String INCOMING_DIR = "incoming-dir";
    private static final String INCOMING_DIR_CREATE = "incoming-dir-create";
    @Private
    public static final String DELETE_UNIDENTIFIED_KEY = "delete-unidentified";
    public static final String REPROCESS_FAULTY_DATASETS_NAME = "reprocess-faulty-datasets";
    @Private
    public static final String ON_ERROR_DECISION_KEY = "on-error-decision";
    public static final String DATASET_REGISTRATION_PRE_STAGING_BEHAVIOR = "dataset-registration-prestaging-behavior";
    @Private
    public static final String INCOMING_SHARE_ID = "incoming-share-id";
    private static final String INCOMING_SHARE_MINIMUM_FREE_SPACE_IN_GB = "incoming-share-minimum-free-space-in-gb";
    public static final String DATASET_REGISTRATION_MAX_RETRY_COUNT = "metadata-registration-max-retry-count";
    public static final String DATASET_REGISTRATION_RETRY_PAUSE_IN_SEC = "metadata-registration-retry-pause-in-sec";
    public static final String PROCESS_MAX_RETRY_COUNT = "process-max-retry-count";
    public static final String PROCESS_RETRY_PAUSE_IN_SEC = "process-retry-pause-in-sec";
    public static final String RECOVERY_MAX_RETRY_COUNT = "recovery-max-retry-count";
    public static final String RECOVERY_MIN_RETRY_PERIOD = "recovery-min-retry-period";
    public static final String RECOVERY_DEVELOPMENT_MODE = "development-mode";
    private static final String H5_FOLDERS = "h5-folders";
    private static final String H5AR_FOLDERS = "h5ar-folders";
    private final File incomingDataDirectory;
    private final boolean createIncomingDirectories;
    private final Properties threadProperties;
    private final Class<?> topLevelDataSetRegistratorClassOrNull;
    private final Class<?> onErrorDecisionClassOrNull;
    private final String threadName;
    private final String groupCode;
    private final String preRegistrationScript;
    private final String postRegistrationScript;
    private final String[] validationScripts;
    private final boolean useIsFinishedMarkerFile;
    private final boolean deleteUnidentified;
    private final boolean reprocessFaultyDatasets;
    private final int dataSetRegistrationMaxRetryCount;
    private final int dataSetRegistrationRetryPauseInSec;
    private final int processMaxRetryCount;
    private final int processRetryPauseInSec;
    private final int maximumRecoveryCount;
    private final int minimumRecoveryPeriod;
    private final DataSetRegistrationPreStagingBehavior dataSetRegistrationPreStagingBehavior;
    private final Integer incomingShareId;
    private final Long incomingShareMinimumFreeSpace;
    private final boolean h5Folders;
    private final boolean h5arFolders;

    public ThreadParameters(Properties threadProperties, String threadName) {
        Class<?> onErrorClass;
        Class<?> registratorClass;
        this.incomingDataDirectory = ThreadParameters.extractIncomingDataDir(threadProperties, threadName);
        this.h5Folders = PropertyUtils.getBoolean((Properties)threadProperties, (String)H5_FOLDERS, (boolean)false);
        this.h5arFolders = PropertyUtils.getBoolean((Properties)threadProperties, (String)H5AR_FOLDERS, (boolean)true);
        this.createIncomingDirectories = PropertyUtils.getBoolean((Properties)threadProperties, (String)INCOMING_DIR_CREATE, (boolean)true);
        this.threadProperties = threadProperties;
        String registratorClassName = PropertyUtils.getProperty((Properties)threadProperties, (String)TOP_LEVEL_DATA_SET_HANDLER);
        try {
            registratorClass = null == registratorClassName ? null : Class.forName(registratorClassName);
        }
        catch (ClassNotFoundException ex) {
            throw ConfigurationFailureException.fromTemplate((String)"Wrong '%s' property: %s", (Object[])new Object[]{TOP_LEVEL_DATA_SET_HANDLER, ex.getMessage()});
        }
        this.topLevelDataSetRegistratorClassOrNull = registratorClass;
        this.groupCode = ThreadParameters.tryGetGroupCode(threadProperties);
        this.preRegistrationScript = ThreadParameters.tryGetPreRegistrationScript(threadProperties);
        this.postRegistrationScript = ThreadParameters.tryGetPostRegistartionScript(threadProperties);
        this.validationScripts = ThreadParameters.tryGetValidationScripts(threadProperties);
        String completenessCondition = PropertyUtils.getProperty((Properties)threadProperties, (String)INCOMING_DATA_COMPLETENESS_CONDITION, (String)INCOMING_DATA_COMPLETENESS_CONDITION_MARKER_FILE);
        this.useIsFinishedMarkerFile = ThreadParameters.parseCompletenessCondition(completenessCondition);
        this.deleteUnidentified = "true".equals(threadProperties.getProperty(DELETE_UNIDENTIFIED_KEY, "false"));
        this.reprocessFaultyDatasets = Boolean.parseBoolean(threadProperties.getProperty(REPROCESS_FAULTY_DATASETS_NAME, "false"));
        this.dataSetRegistrationPreStagingBehavior = this.getOriginalnputDataSetBehaviour(threadProperties);
        this.incomingShareId = ThreadParameters.tryGetIncomingShareId(threadProperties);
        this.incomingShareMinimumFreeSpace = ThreadParameters.tryGetIncomingShareMinimumFreeSpace(threadProperties);
        boolean developmentMode = PropertyUtils.getBoolean((Properties)threadProperties, (String)RECOVERY_DEVELOPMENT_MODE, (boolean)false);
        if (developmentMode) {
            this.dataSetRegistrationMaxRetryCount = 0;
            this.dataSetRegistrationRetryPauseInSec = 0;
            this.processMaxRetryCount = 0;
            this.processRetryPauseInSec = 0;
            this.maximumRecoveryCount = 0;
            this.minimumRecoveryPeriod = 0;
        } else {
            this.dataSetRegistrationMaxRetryCount = Integer.parseInt(threadProperties.getProperty(DATASET_REGISTRATION_MAX_RETRY_COUNT, "6"));
            this.dataSetRegistrationRetryPauseInSec = Integer.parseInt(threadProperties.getProperty(DATASET_REGISTRATION_RETRY_PAUSE_IN_SEC, "300"));
            this.processMaxRetryCount = Integer.parseInt(threadProperties.getProperty(PROCESS_MAX_RETRY_COUNT, "6"));
            this.processRetryPauseInSec = Integer.parseInt(threadProperties.getProperty(PROCESS_RETRY_PAUSE_IN_SEC, "300"));
            this.maximumRecoveryCount = PropertyUtils.getInt((Properties)threadProperties, (String)RECOVERY_MAX_RETRY_COUNT, (int)50);
            this.minimumRecoveryPeriod = PropertyUtils.getInt((Properties)threadProperties, (String)RECOVERY_MIN_RETRY_PERIOD, (int)60);
        }
        this.threadName = threadName;
        String onErrorClassName = PropertyUtils.getProperty((Properties)threadProperties, (String)"on-error-decision.class");
        try {
            onErrorClass = null == onErrorClassName ? null : Class.forName(onErrorClassName);
        }
        catch (ClassNotFoundException ex) {
            throw ConfigurationFailureException.fromTemplate((String)"Wrong '%s' property: %s", (Object[])new Object[]{"on-error-decision.class", ex.getMessage()});
        }
        this.onErrorDecisionClassOrNull = onErrorClass;
    }

    private DataSetRegistrationPreStagingBehavior getOriginalnputDataSetBehaviour(Properties threadProperties1) {
        String property = threadProperties1.getProperty(DATASET_REGISTRATION_PRE_STAGING_BEHAVIOR, "default");
        DataSetRegistrationPreStagingBehavior retVal = DataSetRegistrationPreStagingBehavior.fromString(property);
        if (null == retVal) {
            throw new ConfigurationFailureException("dataset-registration-prestaging-behavior setting for a dropbox is invalid. Incorrect value " + property);
        }
        return retVal;
    }

    public Integer getIncomingShareId() {
        return this.incomingShareId;
    }

    public Long getIncomingShareMinimumFreeSpace() {
        return this.incomingShareMinimumFreeSpace;
    }

    private static boolean parseCompletenessCondition(String completenessCondition) {
        if (completenessCondition.equalsIgnoreCase(INCOMING_DATA_COMPLETENESS_CONDITION_MARKER_FILE)) {
            return true;
        }
        if (completenessCondition.equalsIgnoreCase(INCOMING_DATA_COMPLETENESS_CONDITION_AUTODETECTION)) {
            return false;
        }
        throw new ConfigurationFailureException(String.format("Invalid value '%s' for the option '%s'. Allowed values are: '%s', '%s'.", completenessCondition, INCOMING_DATA_COMPLETENESS_CONDITION, INCOMING_DATA_COMPLETENESS_CONDITION_MARKER_FILE, INCOMING_DATA_COMPLETENESS_CONDITION_AUTODETECTION));
    }

    final void check() {
        if (this.createIncomingDirectories && !this.incomingDataDirectory.exists()) {
            this.incomingDataDirectory.mkdirs();
            operationLog.info((Object)("Created incoming directory '" + this.incomingDataDirectory + "'."));
        }
        if (!this.incomingDataDirectory.isDirectory()) {
            throw new ConfigurationFailureException("Incoming directory '" + this.incomingDataDirectory + "' is not a directory.");
        }
    }

    @Private
    static File extractIncomingDataDir(Properties threadProperties, String threadName2) {
        String incomingDir = threadProperties.getProperty(INCOMING_DIR);
        if (StringUtils.isNotBlank((CharSequence)incomingDir)) {
            return FileUtilities.normalizeFile((File)new File(incomingDir));
        }
        throw new ConfigurationFailureException("No 'incoming-dir' defined for input [" + threadName2 + "].");
    }

    @Private
    static final String tryGetGroupCode(Properties properties) {
        return ThreadParameters.nullIfEmpty(PropertyUtils.getProperty((Properties)properties, (String)GROUP_CODE_KEY));
    }

    @Private
    static final String tryGetPreRegistrationScript(Properties properties) {
        return ThreadParameters.nullIfEmpty(PropertyUtils.getProperty((Properties)properties, (String)PRE_REGISTRATION_SCRIPT_KEY));
    }

    @Private
    static final String tryGetPostRegistartionScript(Properties properties) {
        return ThreadParameters.nullIfEmpty(PropertyUtils.getProperty((Properties)properties, (String)POST_REGISTRATION_SCRIPT_KEY));
    }

    @Private
    static final String[] tryGetValidationScripts(Properties properties) {
        String pathsString = ThreadParameters.nullIfEmpty(PropertyUtils.getProperty((Properties)properties, (String)VALIDATION_SCRIPT_KEY));
        if (pathsString == null) {
            return null;
        }
        String[] paths = pathsString.split(",");
        for (int i = 0; i < paths.length; ++i) {
            String path = paths[i].trim();
            if (StringUtils.isBlank((CharSequence)path)) {
                throw new ConfigurationFailureException(i + "-th path to validation script (property '" + VALIDATION_SCRIPT_KEY + "') is blank.");
            }
            paths[i] = path;
        }
        return paths;
    }

    @Private
    static final Integer tryGetIncomingShareId(Properties properties) {
        String shareId = PropertyUtils.getProperty((Properties)properties, (String)INCOMING_SHARE_ID);
        if (StringUtils.isBlank((CharSequence)shareId)) {
            return null;
        }
        if (!SegmentedStoreUtils.SHARE_ID_PATTERN.matcher(shareId).matches()) {
            throw new ConfigurationFailureException("Invalid incoming share Id:" + shareId);
        }
        return Integer.parseInt(shareId);
    }

    private static Long tryGetIncomingShareMinimumFreeSpace(Properties properties) {
        double min = PropertyUtils.getDouble((Properties)properties, (String)INCOMING_SHARE_MINIMUM_FREE_SPACE_IN_GB, (double)-1.0);
        return min < 0.0 ? null : Long.valueOf((long)(min * 1.073741824E9));
    }

    private static String nullIfEmpty(String value) {
        return (String)StringUtils.defaultIfEmpty((CharSequence)value, null);
    }

    final String tryGetGroupCode() {
        return this.groupCode;
    }

    public final String tryGetPreRegistrationScript() {
        return this.preRegistrationScript;
    }

    public final String tryGetPostRegistrationScript() {
        return this.postRegistrationScript;
    }

    public String[] tryGetValidationScripts() {
        return this.validationScripts;
    }

    public boolean useIsFinishedMarkerFile() {
        return this.useIsFinishedMarkerFile;
    }

    public final File getIncomingDataDirectory() {
        return this.incomingDataDirectory;
    }

    public Class<?> getTopLevelDataSetRegistratorClass(Class<?> defaultClass) {
        return this.topLevelDataSetRegistratorClassOrNull == null ? defaultClass : this.topLevelDataSetRegistratorClassOrNull;
    }

    public Class<?> getOnErrorActionDecisionClass(Class<?> defaultClass) {
        return this.onErrorDecisionClassOrNull == null ? defaultClass : this.onErrorDecisionClassOrNull;
    }

    public Properties getThreadProperties() {
        return this.threadProperties;
    }

    final void log() {
        if (operationLog.isInfoEnabled()) {
            this.logLine("Top-level registrator: '%s'", null == this.topLevelDataSetRegistratorClassOrNull ? TransferredDataSetHandler.class.getName() : this.topLevelDataSetRegistratorClassOrNull.getName());
            if (null == this.topLevelDataSetRegistratorClassOrNull) {
                IETLServerPlugin plugin = ETLServerPluginFactory.getPluginForThread(this);
                this.logLine("Code extractor: '%s'", plugin.getDataSetInfoExtractor().getClass().getName());
                this.logLine("Type extractor: '%s'", plugin.getTypeExtractor().getClass().getName());
            }
            this.logLine("Incoming data directory: '%s'.", this.getIncomingDataDirectory().getAbsolutePath());
            if (this.groupCode != null) {
                this.logLine("Space code: '%s'.", this.groupCode);
            }
            String completenessCond = this.useIsFinishedMarkerFile ? "marker file exists" : "no write access for some period";
            this.logLine("Condition of incoming data completeness: %s.", completenessCond);
            this.logLine("Delete unidentified: '%s'.", this.deleteUnidentified);
            if (this.postRegistrationScript != null) {
                this.logLine("Post registration script: '%s'.", this.postRegistrationScript);
            }
        }
    }

    private void logLine(String format, Object ... params) {
        Vector<Object> allParams = new Vector<Object>();
        allParams.add(this.threadName);
        allParams.addAll(Arrays.asList(params));
        operationLog.info((Object)String.format("[%s] " + format, allParams.toArray(new Object[0])));
    }

    public String getThreadName() {
        return this.threadName;
    }

    public boolean deleteUnidentified() {
        return this.deleteUnidentified;
    }

    public boolean reprocessFaultyDatasets() {
        return this.reprocessFaultyDatasets;
    }

    public DataSetRegistrationPreStagingBehavior getDataSetRegistrationPreStagingBehavior() {
        return this.dataSetRegistrationPreStagingBehavior;
    }

    public int getDataSetRegistrationMaxRetryCount() {
        return this.dataSetRegistrationMaxRetryCount;
    }

    public int getDataSetRegistrationPauseInSec() {
        return this.dataSetRegistrationRetryPauseInSec;
    }

    public int getProcessMaxRetryCount() {
        return this.processMaxRetryCount;
    }

    public int getProcessRetryPauseInSec() {
        return this.processRetryPauseInSec;
    }

    public int getMaximumRecoveryCount() {
        return this.maximumRecoveryCount;
    }

    public int getMinimumRecoveryPeriod() {
        return this.minimumRecoveryPeriod;
    }

    public boolean hasH5AsFolders() {
        return this.h5Folders;
    }

    public boolean hasH5ArAsFolders() {
        return this.h5arFolders;
    }
}

