/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.common.resource.IReleasable;
import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.etlserver.DssRegistrationLogDirectoryHelper;
import ch.systemsx.cisd.etlserver.DynamicTransactionQueryFactory;
import ch.systemsx.cisd.etlserver.ThreadParameters;
import ch.systemsx.cisd.etlserver.registrator.recovery.IDataSetStorageRecoveryManager;
import ch.systemsx.cisd.etlserver.validation.IDataSetValidator;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.IDataSourceQueryService;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Person;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

public class TopLevelDataSetRegistratorGlobalState
implements IReleasable {
    public static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, TopLevelDataSetRegistratorGlobalState.class);
    private final String dssCode;
    private final String shareId;
    private final File storeRootDir;
    private final File dssInternalTempDir;
    private final File dssRegistrationLogDir;
    private final File preStagingDir;
    private final File stagingDir;
    private final File preCommitDir;
    private final File recoveryStateDir;
    private final IEncapsulatedOpenBISService openBisService;
    private final IMailClient mailClient;
    private final IDataSetValidator dataSetValidator;
    private final IDataSourceQueryService dataSourceQueryService;
    private final boolean notifySuccessfulRegistration;
    private final ThreadParameters threadParameters;
    private final boolean useIsFinishedMarkerFile;
    private final boolean deleteUnidentified;
    private final DynamicTransactionQueryFactory dynamicTransactionQueryFactory;
    private final String preRegistrationScriptOrNull;
    private final String postRegistrationScriptOrNull;
    private final String[] validationScriptsOrNull;
    private final IDataSetStorageRecoveryManager storageRecoveryManager;
    public static final String STAGING_DIR = "staging-dir";
    public static final String PRE_STAGING_DIR = "pre-staging-dir";
    public static final String DEFAULT_PRE_STAGING_DIR = "pre-staging";
    public static final String PRE_COMMIT_DIR = "pre-commit-dir";
    public static final String RECOVERY_MARKER_DIR = "recovery-marker-dir";

    public TopLevelDataSetRegistratorGlobalState(String dssCode, String shareId, File storeRootDir, File dssInternalTempDir, File dssRegistrationLogDir, File dssRecoveryStateDir, IEncapsulatedOpenBISService openBisService, IMailClient mailClient, IDataSetValidator dataSetValidator, IDataSourceQueryService dataSourceQueryService, DynamicTransactionQueryFactory dynamicTransactionQueryFactory, boolean notifySuccessfulRegistration, ThreadParameters threadParameters, IDataSetStorageRecoveryManager storageRecoveryManager) {
        this(dssCode, shareId, storeRootDir, dssInternalTempDir, dssRegistrationLogDir, dssRecoveryStateDir, openBisService, mailClient, dataSetValidator, dataSourceQueryService, dynamicTransactionQueryFactory, notifySuccessfulRegistration, threadParameters, threadParameters.useIsFinishedMarkerFile(), threadParameters.deleteUnidentified(), threadParameters.tryGetPreRegistrationScript(), threadParameters.tryGetPostRegistrationScript(), threadParameters.tryGetValidationScripts(), storageRecoveryManager);
    }

    public TopLevelDataSetRegistratorGlobalState(String dssCode, String shareId, File storeRootDir, File dssInternalTempDir, File dssRegistrationLogDir, File dssRecoveryStateDir, IEncapsulatedOpenBISService openBisService, IMailClient mailClient, IDataSetValidator dataSetValidator, IDataSourceQueryService dataSourceQueryService, DynamicTransactionQueryFactory dynamicTransactionQueryFactory, boolean notifySuccessfulRegistration, ThreadParameters threadParameters, boolean useIsFinishedMarkerFile, boolean deleteUnidentified, String preRegistrationScriptOrNull, String postRegistrationScriptOrNull, String[] validationScriptsOrNull, IDataSetStorageRecoveryManager storageRecoveryManager) {
        this.dssCode = dssCode;
        this.shareId = shareId;
        this.storeRootDir = storeRootDir;
        this.dssInternalTempDir = dssInternalTempDir;
        this.dssRegistrationLogDir = dssRegistrationLogDir;
        this.preStagingDir = TopLevelDataSetRegistratorGlobalState.getPreStagingDir(storeRootDir, shareId, threadParameters.getThreadProperties());
        this.stagingDir = TopLevelDataSetRegistratorGlobalState.getStagingDir(storeRootDir, shareId, threadParameters.getThreadProperties());
        this.preCommitDir = TopLevelDataSetRegistratorGlobalState.getPreCommitDir(storeRootDir, shareId, threadParameters.getThreadProperties());
        this.openBisService = openBisService;
        this.mailClient = mailClient;
        this.dataSetValidator = dataSetValidator;
        this.dataSourceQueryService = dataSourceQueryService;
        this.dynamicTransactionQueryFactory = dynamicTransactionQueryFactory;
        this.notifySuccessfulRegistration = notifySuccessfulRegistration;
        this.threadParameters = threadParameters;
        this.useIsFinishedMarkerFile = useIsFinishedMarkerFile;
        this.deleteUnidentified = deleteUnidentified;
        this.preRegistrationScriptOrNull = preRegistrationScriptOrNull;
        this.postRegistrationScriptOrNull = postRegistrationScriptOrNull;
        this.validationScriptsOrNull = validationScriptsOrNull;
        this.recoveryStateDir = new File(dssRecoveryStateDir, threadParameters.getThreadName());
        File recoveryMarkerFilesDirectory = new File(TopLevelDataSetRegistratorGlobalState.getRecoveryMarkerDir(storeRootDir, shareId, threadParameters.getThreadProperties()), threadParameters.getThreadName());
        this.recoveryStateDir.mkdirs();
        recoveryMarkerFilesDirectory.mkdirs();
        this.storageRecoveryManager = storageRecoveryManager;
        this.storageRecoveryManager.setDropboxRecoveryStateDir(this.recoveryStateDir);
        this.storageRecoveryManager.setRecoveryMarkerFilesDir(recoveryMarkerFilesDirectory);
        this.storageRecoveryManager.setMaximumRertyCount(threadParameters.getMaximumRecoveryCount());
        this.storageRecoveryManager.setRetryPeriodInSeconds(threadParameters.getMinimumRecoveryPeriod());
        new DssRegistrationLogDirectoryHelper(dssRegistrationLogDir).initializeSubdirectories();
    }

    public String getDssCode() {
        return this.dssCode;
    }

    public String getShareId() {
        return this.shareId;
    }

    public File getStoreRootDir() {
        return this.storeRootDir;
    }

    public File getDssInternalTempDir() {
        return this.dssInternalTempDir;
    }

    public File getDssRegistrationLogDir() {
        return this.dssRegistrationLogDir;
    }

    public File getPreStagingDir() {
        return this.preStagingDir;
    }

    public File getStagingDir() {
        return this.stagingDir;
    }

    public File getPreCommitDir() {
        return this.preCommitDir;
    }

    public File getRecoveryStateDir() {
        return this.recoveryStateDir;
    }

    public IEncapsulatedOpenBISService getOpenBisService() {
        return this.openBisService;
    }

    public IMailClient getMailClient() {
        return this.mailClient;
    }

    public IDataSetValidator getDataSetValidator() {
        return this.dataSetValidator;
    }

    public IDataSourceQueryService getDataSourceQueryService() {
        return this.dataSourceQueryService;
    }

    public DynamicTransactionQueryFactory getDynamicTransactionQueryFactory() {
        return this.dynamicTransactionQueryFactory;
    }

    public boolean isNotifySuccessfulRegistration() {
        return this.notifySuccessfulRegistration;
    }

    public ThreadParameters getThreadParameters() {
        return this.threadParameters;
    }

    public boolean isUseIsFinishedMarkerFile() {
        return this.useIsFinishedMarkerFile;
    }

    public boolean isDeleteUnidentified() {
        return this.deleteUnidentified;
    }

    public String getPreRegistrationScript() {
        return this.preRegistrationScriptOrNull;
    }

    public String getPostRegistrationScript() {
        return this.postRegistrationScriptOrNull;
    }

    public String[] getValidationScriptsOrNull() {
        return this.validationScriptsOrNull;
    }

    public List<String> getAdministratorEmails() {
        ArrayList<String> emails = new ArrayList<String>();
        List<Person> administrators = this.openBisService.listAdministrators();
        for (Person admin : administrators) {
            String email = admin.getEmail();
            if (!StringUtils.isNotBlank((String)email)) continue;
            emails.add(email);
        }
        return emails;
    }

    public IDataSetStorageRecoveryManager getStorageRecoveryManager() {
        return this.storageRecoveryManager;
    }

    private static File getStagingDir(File storeRoot, String shareId, Properties threadProperties) {
        return TopLevelDataSetRegistratorGlobalState.getShareLocalDir(storeRoot, shareId, threadProperties, STAGING_DIR, "staging");
    }

    private static File getPreStagingDir(File storeRoot, String shareId, Properties threadProperties) {
        return TopLevelDataSetRegistratorGlobalState.getShareLocalDir(storeRoot, shareId, threadProperties, PRE_STAGING_DIR, DEFAULT_PRE_STAGING_DIR);
    }

    private static File getPreCommitDir(File storeRoot, String shareId, Properties threadProperties) {
        return TopLevelDataSetRegistratorGlobalState.getShareLocalDir(storeRoot, shareId, threadProperties, PRE_COMMIT_DIR, "pre-commit");
    }

    private static File getRecoveryMarkerDir(File storeRoot, String shareId, Properties threadProperties) {
        return TopLevelDataSetRegistratorGlobalState.getShareLocalDir(storeRoot, shareId, threadProperties, RECOVERY_MARKER_DIR, "recovery-marker");
    }

    private static File getShareLocalDir(File storeRoot, String shareId, Properties threadProperties, String overridePropertyName, String defaultDirName) {
        String shareLocalDirPath = PropertyUtils.getProperty((Properties)threadProperties, (String)overridePropertyName);
        if (null == shareLocalDirPath) {
            return TopLevelDataSetRegistratorGlobalState.getDefaultShareLocalDir(storeRoot, shareId, defaultDirName);
        }
        File shareLocalDir = new File(shareLocalDirPath);
        shareLocalDir.mkdirs();
        return shareLocalDir;
    }

    private static File getDefaultShareLocalDir(File storeRoot, String shareId, String dirName) {
        File shareRoot = false == StringUtils.isBlank((String)shareId) ? new File(storeRoot, shareId) : storeRoot;
        File stagingDir = shareRoot.isDirectory() ? new File(shareRoot, dirName) : new File(storeRoot, dirName);
        stagingDir.mkdir();
        if (stagingDir.isDirectory()) {
            return stagingDir;
        }
        return storeRoot;
    }

    public void release() {
        if (this.getDataSourceQueryService() instanceof IReleasable) {
            ((IReleasable)this.getDataSourceQueryService()).release();
        }
    }
}

