/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.api.v1;

import ch.systemsx.cisd.common.action.AbstractDelegatedActionWithResult;
import ch.systemsx.cisd.common.action.IDelegatedActionWithResult;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.HighLevelException;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.filesystem.FastRecursiveHardLinkMaker;
import ch.systemsx.cisd.common.filesystem.FileOperations;
import ch.systemsx.cisd.common.filesystem.IFileOperations;
import ch.systemsx.cisd.common.filesystem.IImmutableCopier;
import ch.systemsx.cisd.common.io.ConcatenatedFileOutputStreamWriter;
import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.etlserver.DataSetRegistrationAlgorithmRunner;
import ch.systemsx.cisd.etlserver.DataSetRegistrationHelper;
import ch.systemsx.cisd.etlserver.DefaultStorageProcessor;
import ch.systemsx.cisd.etlserver.IDataSetHandler;
import ch.systemsx.cisd.etlserver.IDataSetHandlerRpc;
import ch.systemsx.cisd.etlserver.IDataSetInfoExtractor;
import ch.systemsx.cisd.etlserver.IDataStrategyStore;
import ch.systemsx.cisd.etlserver.IETLServerPlugin;
import ch.systemsx.cisd.etlserver.IPostRegistrationAction;
import ch.systemsx.cisd.etlserver.IPreRegistrationAction;
import ch.systemsx.cisd.etlserver.IStorageProcessorTransactional;
import ch.systemsx.cisd.etlserver.ITypeExtractor;
import ch.systemsx.cisd.etlserver.api.v1.PutDataSetService;
import ch.systemsx.cisd.etlserver.api.v1.PutDataSetUtil;
import ch.systemsx.cisd.etlserver.validation.IDataSetValidator;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.FileInfoDssDTO;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.NewDataSetDTO;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.RSyncConfig;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseInstance;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.FileFormatType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.LocatorType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PhysicalDataSet;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewProperty;
import ch.systemsx.cisd.openbis.generic.shared.dto.SessionContextDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifierFactory;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

class PutDataSetExecutor
implements IDataSetHandlerRpc {
    private final PutDataSetService service;
    private final IETLServerPlugin plugin;
    private final String sessionToken;
    private final NewDataSetDTO newDataSet;
    private final InputStream inputStream;
    private final File temporaryIncomingDir;
    private final File dataSetDir;
    private final OverridingTypeExtractor overridingTypeExtractor;
    private final IDataSetHandler handler;
    private final IImmutableCopier copier;
    private DataSetInformation overrideOrNull;

    PutDataSetExecutor(PutDataSetService service, IETLServerPlugin plugin, String sessionToken, NewDataSetDTO newDataSet, InputStream inputStream) {
        this.service = service;
        this.plugin = plugin;
        this.sessionToken = sessionToken;
        this.newDataSet = newDataSet;
        this.inputStream = inputStream;
        this.copier = FastRecursiveHardLinkMaker.tryCreate(RSyncConfig.getInstance().getAdditionalCommandLineOptions());
        this.temporaryIncomingDir = service.createTemporaryIncomingDir(newDataSet.tryDataSetType());
        this.dataSetDir = new File(this.temporaryIncomingDir, newDataSet.getDataSetFolderName());
        if (this.dataSetDir.exists()) {
            this.deleteDataSetDir();
        }
        if (!this.dataSetDir.mkdir()) {
            throw new EnvironmentFailureException("Could not create directory for data set " + newDataSet.getDataSetFolderName());
        }
        this.overridingTypeExtractor = new OverridingTypeExtractor();
        this.handler = plugin.getDataSetHandler(this, service.getOpenBisService());
    }

    PutDataSetExecutor(PutDataSetService service, IETLServerPlugin plugin, String sessionToken, NewDataSetDTO newDataSet, File temporaryIncomingDir, File dataSet) {
        this.service = service;
        this.plugin = plugin;
        this.sessionToken = sessionToken;
        this.newDataSet = newDataSet;
        this.inputStream = null;
        this.copier = FastRecursiveHardLinkMaker.tryCreate(RSyncConfig.getInstance().getAdditionalCommandLineOptions());
        this.temporaryIncomingDir = temporaryIncomingDir;
        this.dataSetDir = dataSet;
        this.overridingTypeExtractor = new OverridingTypeExtractor();
        this.handler = plugin.getDataSetHandler(this, service.getOpenBisService());
    }

    public List<DataSetInformation> execute(boolean noOwnerAllowed) throws UserFailureException, IOException {
        PutDataSetUtil.checkAccess(this.sessionToken, this.getOpenBisService(), this.newDataSet, noOwnerAllowed);
        this.writeDataSetToTempDirectory();
        this.overrideOrNull = null;
        try {
            List<DataSetInformation> list = this.handler.handleDataSet(this.dataSetDir);
            return list;
        }
        finally {
            this.deleteDataSetDir();
        }
    }

    public List<DataSetInformation> executeWithoutWriting() throws UserFailureException {
        PutDataSetUtil.checkAccess(this.sessionToken, this.getOpenBisService(), this.newDataSet, false);
        this.overrideOrNull = null;
        try {
            List<DataSetInformation> list = this.handler.handleDataSet(this.dataSetDir);
            return list;
        }
        finally {
            this.deleteDataSetDir();
        }
    }

    @Override
    public List<DataSetInformation> handleDataSet(File dataSet) {
        return this.handleDataSet(dataSet, null);
    }

    @Override
    public List<DataSetInformation> handleDataSet(final File dataSet, final DataSetInformation newOverride) {
        DataSetInformation oldOverride = this.overrideOrNull;
        if (newOverride != null) {
            this.overrideOrNull = newOverride;
        }
        String dataSetTypeCodeOrNull = this.tryGetDataSetTypeCode(newOverride);
        String shareId = this.service.getShareId(dataSetTypeCodeOrNull);
        RegistrationHelper helper = new RegistrationHelper(this.service, shareId, this.plugin, dataSet);
        new DataSetRegistrationAlgorithmRunner(helper, new DataSetRegistrationAlgorithmRunner.IDataSetRegistrationAlgorithmRunnerDelegate(){

            @Override
            public void didNotIdentifyDataSet() {
                throw new UserFailureException("Could not find owner:\n\t" + newOverride + "\nfor data set:\n\t" + dataSet);
            }
        }).runAlgorithm();
        this.overrideOrNull = oldOverride;
        return Collections.singletonList(helper.getDataSetInformation());
    }

    public String tryGetDataSetTypeCode(DataSetInformation newOverride) {
        String dataSetTypeCodeOrNull = newOverride != null && newOverride.getDataSetType() != null ? newOverride.getDataSetType().getCode() : null;
        return dataSetTypeCodeOrNull;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DataSetInformation> linkAndHandleDataSet(File dataSetComponent, DataSetInformation newOverride) {
        File incomingDir = this.service.getIncomingDir(this.tryGetDataSetTypeCode(newOverride));
        Status status = this.copier.copyImmutably(dataSetComponent, incomingDir, null);
        if (status.isError()) {
            throw new EnvironmentFailureException("Couldn't create a hard-link copy of '" + dataSetComponent.getAbsolutePath() + "' in folder '" + incomingDir.getAbsolutePath() + "'. [" + status.isError() + "]");
        }
        File linkedFile = new File(incomingDir, dataSetComponent.getName());
        try {
            List<DataSetInformation> list = this.handleDataSet(linkedFile, newOverride);
            return list;
        }
        finally {
            if (linkedFile.isDirectory()) {
                this.deleteDir(linkedFile);
            } else if (linkedFile.exists()) {
                this.deleteFile(linkedFile);
            }
        }
    }

    @Override
    public SessionContextDTO getSessionContext() {
        return this.getOpenBisService().tryGetSession(this.sessionToken);
    }

    @Override
    public File getFileForDataSet(PhysicalDataSet dataSet, String shareId) {
        File share = new File(this.service.getStoreRootDirectory(), shareId);
        File dataSetFile = new File(share, dataSet.getLocation());
        return DefaultStorageProcessor.getOriginalDirectory(dataSetFile);
    }

    public String getDataStoreCode() {
        return this.service.getDataStoreCode();
    }

    @Override
    public NewDataSetDTO.DataSetOwner getDataSetOwner() {
        NewDataSetDTO.DataSetOwner owner = this.newDataSet.getDataSetOwner();
        return owner;
    }

    @Override
    public DataSetInformation getCallerDataSetInformation() {
        DataSetInformation dataSetInfo = new DataSetInformation();
        NewDataSetDTO.DataSetOwner owner = this.getDataSetOwner();
        switch (owner.getType()) {
            case EXPERIMENT: {
                dataSetInfo.setExperimentIdentifier(this.tryExperimentIdentifier());
                break;
            }
            case SAMPLE: {
                SampleIdentifier sampleId = this.trySampleIdentifier();
                dataSetInfo.setSampleIdentifier(sampleId);
                break;
            }
            case DATA_SET: {
                String dataSetCode = this.tryGetDataSetCode();
                AbstractExternalData parentDataSet = this.getOpenBisService().tryGetDataSet(dataSetCode);
                if (parentDataSet == null) break;
                if (parentDataSet.getExperiment() != null) {
                    dataSetInfo.setExperiment(parentDataSet.getExperiment());
                }
                if (parentDataSet.getSample() != null) {
                    dataSetInfo.setSample(parentDataSet.getSample());
                }
                ArrayList<String> parentDataSetCodes = new ArrayList<String>();
                parentDataSetCodes.add(parentDataSet.getCode());
                parentDataSetCodes.addAll(dataSetInfo.getParentDataSetCodes());
                dataSetInfo.setParentDataSetCodes(parentDataSetCodes);
                break;
            }
        }
        String typeCode = this.newDataSet.tryDataSetType();
        if (null != typeCode) {
            dataSetInfo.setDataSetType(new DataSetType(typeCode));
        }
        dataSetInfo.setDataSetKind(DataSetKind.PHYSICAL);
        Map<String, String> primitiveProps = this.newDataSet.getProperties();
        if (!primitiveProps.isEmpty()) {
            ArrayList<NewProperty> properties = new ArrayList<NewProperty>();
            for (String key : primitiveProps.keySet()) {
                properties.add(new NewProperty(key, primitiveProps.get(key)));
            }
            dataSetInfo.setDataSetProperties(properties);
        }
        ArrayList<String> parentDataSetCodes = new ArrayList<String>();
        parentDataSetCodes.addAll(dataSetInfo.getParentDataSetCodes());
        parentDataSetCodes.addAll(this.newDataSet.getParentDataSetCodes());
        dataSetInfo.setParentDataSetCodes(parentDataSetCodes);
        return dataSetInfo;
    }

    private void writeDataSetToTempDirectory() throws IOException {
        ConcatenatedFileOutputStreamWriter imagesWriter = new ConcatenatedFileOutputStreamWriter(this.inputStream);
        for (FileInfoDssDTO fileInfo : this.newDataSet.getFileInfos()) {
            if (fileInfo.isDirectory()) {
                File file = new File(this.dataSetDir, fileInfo.getPathInDataSet());
                file.mkdir();
                continue;
            }
            OutputStream output = this.getOutputStream(fileInfo);
            imagesWriter.writeNextBlock(output);
            output.flush();
            output.close();
        }
    }

    private OutputStream getOutputStream(FileInfoDssDTO fileInfo) {
        FileOutputStream fos;
        File file = new File(this.dataSetDir, fileInfo.getPathInDataSet());
        try {
            fos = new FileOutputStream(file);
        }
        catch (FileNotFoundException ex) {
            throw new EnvironmentFailureException("Could not save file " + file, (Throwable)ex);
        }
        return new BufferedOutputStream(fos);
    }

    private void deleteDataSetDir() {
        this.deleteDir(this.temporaryIncomingDir);
    }

    private void deleteDir(File dirToDelete) {
        try {
            FileUtils.deleteDirectory((File)dirToDelete);
        }
        catch (IOException ex) {
            this.getOperationLog().error((Object)("Could not delete data set directory " + dirToDelete), (Throwable)ex);
            ex.printStackTrace();
        }
    }

    private void deleteFile(File fileToDelete) {
        FileUtils.deleteQuietly((File)fileToDelete);
    }

    private ExperimentIdentifier tryExperimentIdentifier() {
        NewDataSetDTO.DataSetOwner owner = this.getDataSetOwner();
        switch (owner.getType()) {
            case EXPERIMENT: {
                return new ExperimentIdentifierFactory(owner.getIdentifier()).createIdentifier();
            }
        }
        return null;
    }

    private SampleIdentifier trySampleIdentifier() {
        NewDataSetDTO.DataSetOwner owner = this.getDataSetOwner();
        switch (owner.getType()) {
            case SAMPLE: {
                return new SampleIdentifierFactory(owner.getIdentifier()).createIdentifier();
            }
        }
        return null;
    }

    private String tryGetDataSetCode() {
        NewDataSetDTO.DataSetOwner owner = this.getDataSetOwner();
        switch (owner.getType()) {
            case DATA_SET: {
                return owner.getIdentifier();
            }
        }
        return null;
    }

    private IEncapsulatedOpenBISService getOpenBisService() {
        return this.service.getOpenBisService();
    }

    private Logger getOperationLog() {
        return this.service.getOperationLog();
    }

    public OverridingTypeExtractor getOverridingTypeExtractor() {
        return this.overridingTypeExtractor;
    }

    private class RegistrationHelper
    extends DataSetRegistrationHelper
    implements IDataSetInfoExtractor {
        public RegistrationHelper(PutDataSetService service, String shareId, IETLServerPlugin plugin, File incomingDataSetFile) {
            super(incomingDataSetFile, shareId, (IDelegatedActionWithResult<Boolean>)new CleanAfterwardsAction(), new PreRegistrationAction(), new PostRegistrationAction());
        }

        @Override
        protected IDataSetInfoExtractor getDataSetInfoExtractor() {
            return this;
        }

        @Override
        protected IDataSetValidator getDataSetValidator() {
            return PutDataSetExecutor.this.service.getDataSetValidator();
        }

        @Override
        protected String getDataStoreCode() {
            return PutDataSetExecutor.this.service.getDataStoreCode();
        }

        @Override
        protected IDataStrategyStore getDataStrategyStore() {
            return PutDataSetExecutor.this.service.getDataStrategyStore();
        }

        @Override
        protected IFileOperations getFileOperations() {
            return FileOperations.getMonitoredInstanceForCurrentThread();
        }

        @Override
        protected DatabaseInstance getHomeDatabaseInstance() {
            return PutDataSetExecutor.this.service.getHomeDatabaseInstance();
        }

        @Override
        protected IMailClient getMailClient() {
            return PutDataSetExecutor.this.service.getMailClient();
        }

        @Override
        protected Logger getNotificationLog() {
            return PutDataSetExecutor.this.service.getOperationLog();
        }

        @Override
        protected IEncapsulatedOpenBISService getOpenBisService() {
            return PutDataSetExecutor.this.service.getOpenBisService();
        }

        @Override
        protected Logger getOperationLog() {
            return PutDataSetExecutor.this.service.getOperationLog();
        }

        @Override
        protected Lock getRegistrationLock() {
            return PutDataSetExecutor.this.service.getRegistrationLock();
        }

        @Override
        protected IStorageProcessorTransactional getStorageProcessor() {
            return PutDataSetExecutor.this.plugin.getStorageProcessor();
        }

        @Override
        protected ITypeExtractor getTypeExtractor() {
            return PutDataSetExecutor.this.getOverridingTypeExtractor();
        }

        @Override
        protected void rollback(Throwable ex) {
            this.registrationAlgorithm.rollbackStorageProcessor(ex);
            if (ex instanceof HighLevelException) {
                throw (HighLevelException)ex;
            }
            throw new EnvironmentFailureException("Could not register data set " + PutDataSetExecutor.this.newDataSet, ex);
        }

        @Override
        protected boolean shouldDeleteUnidentified() {
            return true;
        }

        @Override
        protected boolean shouldNotifySuccessfulRegistration() {
            return false;
        }

        @Override
        protected DataSetInformation extractDataSetInformation(File incomingDataSetPath) {
            DataSetInformation dataSetInfo = super.extractDataSetInformation(incomingDataSetPath);
            if (null == dataSetInfo) {
                return null;
            }
            SessionContextDTO session = PutDataSetExecutor.this.service.getOpenBisService().tryGetSession(PutDataSetExecutor.this.sessionToken);
            dataSetInfo.setUploadingUserId(session.getUserName());
            return dataSetInfo;
        }

        @Override
        public DataSetInformation getDataSetInformation(File incomingDataSetPath, IEncapsulatedOpenBISService openbisService) throws UserFailureException, EnvironmentFailureException {
            String typeCode;
            if (null != PutDataSetExecutor.this.overrideOrNull) {
                return PutDataSetExecutor.this.overrideOrNull;
            }
            DataSetInformation dataSetInfo = PutDataSetExecutor.this.plugin.getDataSetInfoExtractor().getDataSetInformation(incomingDataSetPath, openbisService);
            NewDataSetDTO.DataSetOwner owner = PutDataSetExecutor.this.getDataSetOwner();
            if (owner != null) {
                switch (owner.getType()) {
                    case EXPERIMENT: {
                        dataSetInfo.setExperimentIdentifier(PutDataSetExecutor.this.tryExperimentIdentifier());
                        break;
                    }
                    case SAMPLE: {
                        SampleIdentifier sampleId = PutDataSetExecutor.this.trySampleIdentifier();
                        dataSetInfo.setSampleIdentifier(sampleId);
                        break;
                    }
                    case DATA_SET: {
                        String dataSetCode = PutDataSetExecutor.this.tryGetDataSetCode();
                        AbstractExternalData parentDataSet = openbisService.tryGetDataSet(dataSetCode);
                        if (parentDataSet == null) break;
                        if (parentDataSet.getExperiment() != null) {
                            dataSetInfo.setExperiment(parentDataSet.getExperiment());
                        }
                        if (parentDataSet.getSample() != null) {
                            dataSetInfo.setSample(parentDataSet.getSample());
                        }
                        ArrayList<String> parentDataSetCodes = new ArrayList<String>();
                        parentDataSetCodes.add(parentDataSet.getCode());
                        parentDataSetCodes.addAll(dataSetInfo.getParentDataSetCodes());
                        dataSetInfo.setParentDataSetCodes(parentDataSetCodes);
                        break;
                    }
                }
            }
            if (null != (typeCode = PutDataSetExecutor.this.newDataSet.tryDataSetType())) {
                dataSetInfo.setDataSetType(new DataSetType(typeCode));
            }
            dataSetInfo.setDataSetKind(DataSetKind.PHYSICAL);
            Map<String, String> primitiveProps = PutDataSetExecutor.this.newDataSet.getProperties();
            if (!primitiveProps.isEmpty()) {
                ArrayList<NewProperty> properties = new ArrayList<NewProperty>();
                for (String key : primitiveProps.keySet()) {
                    properties.add(new NewProperty(key, primitiveProps.get(key)));
                }
                dataSetInfo.setDataSetProperties(properties);
            }
            return dataSetInfo;
        }
    }

    private class OverridingTypeExtractor
    implements ITypeExtractor {
        private final ITypeExtractor pluginTypeExtractor;

        OverridingTypeExtractor() {
            this.pluginTypeExtractor = PutDataSetExecutor.this.plugin.getTypeExtractor();
        }

        @Override
        public DataSetType getDataSetType(File incomingDataSetPath) {
            DataSetType dataSetType;
            if (null != PutDataSetExecutor.this.overrideOrNull && null != (dataSetType = PutDataSetExecutor.this.overrideOrNull.getDataSetType())) {
                return dataSetType;
            }
            return this.pluginTypeExtractor.getDataSetType(incomingDataSetPath);
        }

        @Override
        public FileFormatType getFileFormatType(File incomingDataSetPath) {
            return this.pluginTypeExtractor.getFileFormatType(incomingDataSetPath);
        }

        @Override
        public LocatorType getLocatorType(File incomingDataSetPath) {
            return this.pluginTypeExtractor.getLocatorType(incomingDataSetPath);
        }

        @Override
        public String getProcessorType(File incomingDataSetPath) {
            return this.pluginTypeExtractor.getProcessorType(incomingDataSetPath);
        }

        @Override
        public boolean isMeasuredData(File incomingDataSetPath) {
            return this.pluginTypeExtractor.isMeasuredData(incomingDataSetPath);
        }
    }

    private static class CleanAfterwardsAction
    extends AbstractDelegatedActionWithResult<Boolean> {
        private CleanAfterwardsAction() {
            super((Object)true);
        }
    }

    private static class PreRegistrationAction
    implements IPreRegistrationAction {
        private PreRegistrationAction() {
        }

        @Override
        public boolean execute(String dataSetCode, String dataSetAbsolutePathInStore) {
            return true;
        }
    }

    private static class PostRegistrationAction
    implements IPostRegistrationAction {
        private PostRegistrationAction() {
        }

        @Override
        public boolean execute(String dataSetCode, String dataSetAbsolutePathInStore) {
            return true;
        }
    }
}

