/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.api.v1;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.filesystem.QueueingPathRemoverService;
import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.common.mail.MailClient;
import ch.systemsx.cisd.etlserver.DataStrategyStore;
import ch.systemsx.cisd.etlserver.ITopLevelDataSetRegistrator;
import ch.systemsx.cisd.etlserver.TopLevelDataSetRegistratorGlobalState;
import ch.systemsx.cisd.etlserver.api.v1.DataSetTypeToRegistratorMapper;
import ch.systemsx.cisd.etlserver.api.v1.PutDataSetExecutor;
import ch.systemsx.cisd.etlserver.api.v1.PutDataSetServerPluginHolder;
import ch.systemsx.cisd.etlserver.api.v1.PutDataSetServiceInitializer;
import ch.systemsx.cisd.etlserver.api.v1.PutDataSetTopLevelDataSetHandler;
import ch.systemsx.cisd.etlserver.validation.IDataSetValidator;
import ch.systemsx.cisd.openbis.common.io.ByteArrayBasedContentNode;
import ch.systemsx.cisd.openbis.common.io.ConcatenatedContentInputStream;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.IPutDataSetService;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.FileInfoDssDTO;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.NewDataSetDTO;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.validation.ValidationScriptReader;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.SegmentedStoreUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.CustomImportFile;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseInstance;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class PutDataSetService
implements IPutDataSetService {
    private static final String MULTIPLE_FILES_UPLOAD_DIR = "upload";
    private final IEncapsulatedOpenBISService openBisService;
    private final Logger operationLog;
    private final Lock registrationLock;
    private DataSetTypeToRegistratorMapper registratorMap;
    private DataStrategyStore dataStrategyStore;
    private File storeDirectory;
    private String dataStoreCode;
    private boolean isInitialized = false;
    private IMailClient mailClient;
    private IDataSetValidator dataSetValidator;
    private DatabaseInstance homeDatabaseInstance;

    public PutDataSetService(IEncapsulatedOpenBISService openBisService, Logger operationLog) {
        this.openBisService = openBisService;
        this.operationLog = operationLog;
        this.registrationLock = new ReentrantLock();
    }

    public PutDataSetService(IEncapsulatedOpenBISService openBisService, Logger operationLog, File store, DataSetTypeToRegistratorMapper map, IMailClient mail, String dsCode, IDataSetValidator validator) {
        this(openBisService, operationLog);
        this.registratorMap = map;
        this.storeDirectory = store;
        this.registratorMap.initializeStoreRootDirectory(this.storeDirectory);
        this.mailClient = mail;
        this.dataStrategyStore = new DataStrategyStore(openBisService, this.mailClient);
        this.dataStoreCode = dsCode;
        this.homeDatabaseInstance = openBisService.getHomeDatabaseInstance();
        this.dataSetValidator = validator;
        this.isInitialized = true;
    }

    public String putDataSet(String sessionToken, String dropboxName, CustomImportFile customImportFile) {
        if (!this.isInitialized) {
            this.doInitialization();
        }
        try {
            ITopLevelDataSetRegistrator registrator = this.registratorMap.getRegistratorForDropbox(dropboxName);
            List<DataSetInformation> infos = registrator instanceof PutDataSetServerPluginHolder ? new PutDataSetExecutor(this, ((PutDataSetServerPluginHolder)registrator).getPlugin(), sessionToken, this.createNewDataSetDTO(customImportFile), this.getAsInputStream(customImportFile)).execute(true) : new PutDataSetTopLevelDataSetHandler(this, registrator, sessionToken, this.createNewDataSetDTO(customImportFile), this.getAsInputStream(customImportFile)).execute(true);
            StringBuilder sb = new StringBuilder();
            for (DataSetInformation info : infos) {
                sb.append(info.getDataSetCode());
                sb.append(",");
            }
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
            return sb.toString();
        }
        catch (UserFailureException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IOException e) {
            throw new IOExceptionUnchecked(e);
        }
    }

    private InputStream getAsInputStream(CustomImportFile customImportFile) {
        return new ConcatenatedContentInputStream(false, new IHierarchicalContentNode[]{new ByteArrayBasedContentNode(customImportFile.getBytes(), customImportFile.getFileName())});
    }

    private NewDataSetDTO createNewDataSetDTO(CustomImportFile customImportFile) {
        return new NewDataSetDTO(null, null, Collections.singletonList(new FileInfoDssDTO(customImportFile.getFileName(), customImportFile.getFileName(), false, customImportFile.getBytes().length)));
    }

    public String putDataSet(String sessionToken, NewDataSetDTO newDataSet, InputStream inputStream) throws IOExceptionUnchecked, IllegalArgumentException {
        if (!this.isInitialized) {
            this.doInitialization();
        }
        try {
            String dataSetTypeOrNull = newDataSet.tryDataSetType();
            ITopLevelDataSetRegistrator registrator = this.registratorMap.getRegistratorForType(dataSetTypeOrNull);
            List<DataSetInformation> infos = registrator instanceof PutDataSetServerPluginHolder ? new PutDataSetExecutor(this, ((PutDataSetServerPluginHolder)registrator).getPlugin(), sessionToken, newDataSet, inputStream).execute(false) : new PutDataSetTopLevelDataSetHandler(this, registrator, sessionToken, newDataSet, inputStream).execute(false);
            StringBuilder sb = new StringBuilder();
            for (DataSetInformation info : infos) {
                sb.append(info.getDataSetCode());
                sb.append(",");
            }
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
            String string = sb.toString();
            return string;
        }
        catch (UserFailureException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IOException e) {
            throw new IOExceptionUnchecked(e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public List<DataSetInformation> putDataSet(String sessionToken, NewDataSetDTO newDataSet, String uploadId) throws IOExceptionUnchecked, IllegalArgumentException {
        if (!this.isInitialized) {
            this.doInitialization();
        }
        this.validateSessionToken(sessionToken);
        this.validateUploadId(uploadId);
        if (newDataSet == null) {
            throw new UserFailureException("New data set cannot be null");
        }
        ServiceProvider.getOpenBISService().checkSession(sessionToken);
        String dataSetType = newDataSet.tryDataSetType();
        ITopLevelDataSetRegistrator registrator = this.registratorMap.getRegistratorForType(dataSetType);
        File sessionUploadDir = new File(this.getTemporaryIncomingRoot(dataSetType), sessionToken);
        File uploadIdDir = new File(sessionUploadDir, uploadId);
        File multipleFilesUploadDir = new File(uploadIdDir, MULTIPLE_FILES_UPLOAD_DIR);
        File[] uploadedFiles = null;
        File dataSet = null;
        if (multipleFilesUploadDir.exists() && multipleFilesUploadDir.isDirectory()) {
            uploadedFiles = multipleFilesUploadDir.listFiles();
        }
        if (uploadedFiles == null || uploadedFiles.length == 0) {
            throw new UserFailureException("No uploaded files found for upload id '" + uploadId + "'");
        }
        dataSet = uploadedFiles.length == 1 ? uploadedFiles[0] : multipleFilesUploadDir;
        if (registrator instanceof PutDataSetServerPluginHolder) {
            return new PutDataSetExecutor(this, ((PutDataSetServerPluginHolder)registrator).getPlugin(), sessionToken, newDataSet, uploadIdDir, dataSet).executeWithoutWriting();
        }
        return new PutDataSetTopLevelDataSetHandler(this, registrator, sessionToken, newDataSet, uploadIdDir, dataSet).executeWithoutWriting();
    }

    public void putFileToStoreShare(String sessionToken, String folderPathOrNull, String filePath, String dataSetType, String uploadId, InputStream inputStream) {
        if (!this.isInitialized) {
            this.doInitialization();
        }
        File file = null;
        FileOutputStream outputStream = null;
        try {
            this.validateSessionToken(sessionToken);
            this.validateUploadId(uploadId);
            if (StringUtils.isBlank((CharSequence)filePath)) {
                throw new UserFailureException("File path cannot be null or empty");
            }
            if (!StringUtils.isBlank((CharSequence)folderPathOrNull) && folderPathOrNull.contains("../")) {
                throw new UserFailureException("Folder path must not contain '../'");
            }
            if (filePath.contains("../")) {
                throw new UserFailureException("File path must not contain '../'");
            }
            if (StringUtils.isBlank((CharSequence)dataSetType)) {
                throw new UserFailureException("Data set type cannot be null or empty");
            }
            if (inputStream == null) {
                throw new UserFailureException("Input stream cannot be null");
            }
            ServiceProvider.getOpenBISService().checkSession(sessionToken);
            File sessionUploadDir = new File(this.getTemporaryIncomingRoot(dataSetType), sessionToken);
            File uploadIdDir = new File(sessionUploadDir, uploadId);
            File multipleFilesUploadDir = new File(uploadIdDir, MULTIPLE_FILES_UPLOAD_DIR);
            File filePathDir = null;
            filePathDir = StringUtils.isBlank((CharSequence)folderPathOrNull) ? new File(multipleFilesUploadDir, FilenameUtils.getPath((String)filePath)) : new File(multipleFilesUploadDir, FilenameUtils.getPath((String)(folderPathOrNull + "/" + filePath)));
            if (!filePathDir.exists()) {
                filePathDir.mkdirs();
            }
            file = new File(filePathDir, FilenameUtils.getName((String)filePath));
            outputStream = new FileOutputStream(file);
            IOUtils.copyLarge((InputStream)inputStream, (OutputStream)outputStream);
            this.operationLog.info((Object)("File '" + filePath + "' with upload id: '" + uploadId + "' has been stored as '" + file.getCanonicalPath() + "'"));
        }
        catch (IOException ioe) {
            try {
                IOUtils.closeQuietly(outputStream);
                try {
                    file.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ioe);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)outputStream);
    }

    public String getValidationScript(String dataSetTypeOrNull) {
        ITopLevelDataSetRegistrator registrator;
        TopLevelDataSetRegistratorGlobalState globalState;
        String[] scriptPaths;
        if (!this.isInitialized) {
            this.doInitialization();
        }
        if ((scriptPaths = (globalState = (registrator = this.registratorMap.getRegistratorForType(dataSetTypeOrNull)).getGlobalState()).getValidationScriptsOrNull()) == null) {
            return null;
        }
        return ValidationScriptReader.tryReadValidationScript(scriptPaths);
    }

    private void doInitialization() {
        PutDataSetServiceInitializer initializer = new PutDataSetServiceInitializer();
        this.mailClient = new MailClient(initializer.getMailProperties());
        this.dataStrategyStore = new DataStrategyStore(this.openBisService, this.mailClient);
        this.dataStoreCode = initializer.getDataStoreCode();
        this.homeDatabaseInstance = this.openBisService.getHomeDatabaseInstance();
        this.dataSetValidator = initializer.getDataSetValidator();
        File[] shares = SegmentedStoreUtils.getShares(this.storeDirectory);
        if (shares.length == 0 && !new File(this.storeDirectory, "1").mkdirs()) {
            throw new ConfigurationFailureException("Can not create default share in store: " + this.storeDirectory);
        }
        this.registratorMap = initializer.getRegistratorMap(this.openBisService, this.mailClient);
        this.registratorMap.initializeStoreRootDirectory(this.storeDirectory);
        this.isInitialized = true;
    }

    IEncapsulatedOpenBISService getOpenBisService() {
        return this.openBisService;
    }

    IMailClient getMailClient() {
        return this.mailClient;
    }

    public String getShareId(String dataSetTypeOrNull) {
        return this.getThreadGlobalState(dataSetTypeOrNull).getShareId();
    }

    File getIncomingDir(String dataSetTypeOrNull) {
        return this.getThreadGlobalState(dataSetTypeOrNull).getThreadParameters().getIncomingDataDirectory();
    }

    private TopLevelDataSetRegistratorGlobalState getThreadGlobalState(String dataSetTypeOrNull) {
        return this.registratorMap.getRegistratorForType(dataSetTypeOrNull).getGlobalState();
    }

    private Collection<TopLevelDataSetRegistratorGlobalState> getThreadGlobalStates() {
        ArrayList<TopLevelDataSetRegistratorGlobalState> states = new ArrayList<TopLevelDataSetRegistratorGlobalState>();
        Collection<ITopLevelDataSetRegistrator> registrators = this.registratorMap.getRegistrators();
        for (ITopLevelDataSetRegistrator registrator : registrators) {
            if (registrator == null || registrator.getGlobalState() == null) continue;
            states.add(registrator.getGlobalState());
        }
        return states;
    }

    Logger getOperationLog() {
        return this.operationLog;
    }

    Lock getRegistrationLock() {
        return this.registrationLock;
    }

    DataStrategyStore getDataStrategyStore() {
        return this.dataStrategyStore;
    }

    String getDataStoreCode() {
        return this.dataStoreCode;
    }

    IDataSetValidator getDataSetValidator() {
        return this.dataSetValidator;
    }

    DatabaseInstance getHomeDatabaseInstance() {
        return this.homeDatabaseInstance;
    }

    public File getStoreRootDirectory() {
        return this.storeDirectory;
    }

    public void setStoreDirectory(File storeDirectory) {
        this.storeDirectory = storeDirectory;
    }

    public File createTemporaryIncomingDir(String dataSetTypeCodeOrNull) {
        String uniqueFolderName = this.openBisService.createPermId();
        File temporaryIncomingDir = new File(this.getTemporaryIncomingRoot(dataSetTypeCodeOrNull), uniqueFolderName);
        temporaryIncomingDir.mkdir();
        return temporaryIncomingDir;
    }

    public File getTemporaryIncomingRoot(String dataSetTypeCodeOrNull) {
        if (!this.isInitialized) {
            this.doInitialization();
        }
        TopLevelDataSetRegistratorGlobalState globalState = this.getThreadGlobalState(dataSetTypeCodeOrNull);
        return this.getTemporaryIncomingRoot(globalState);
    }

    private File getTemporaryIncomingRoot(TopLevelDataSetRegistratorGlobalState globalState) {
        File shareRoot;
        if (!this.isInitialized) {
            this.doInitialization();
        }
        File storeRoot = globalState.getStoreRootDir();
        if (!StringUtils.isBlank((CharSequence)globalState.getShareId()) && (shareRoot = new File(storeRoot, globalState.getShareId())).isDirectory()) {
            File incomingDir = new File(shareRoot, "rpc-incoming");
            incomingDir.mkdir();
            if (incomingDir.isDirectory()) {
                return incomingDir;
            }
        }
        return storeRoot;
    }

    public void cleanupSession(String sessionToken) {
        if (!this.isInitialized) {
            this.doInitialization();
        }
        this.validateSessionToken(sessionToken);
        Collection<TopLevelDataSetRegistratorGlobalState> states = this.getThreadGlobalStates();
        for (TopLevelDataSetRegistratorGlobalState state : states) {
            File sessionUploadDir = null;
            try {
                sessionUploadDir = new File(this.getTemporaryIncomingRoot(state), sessionToken);
                if (!sessionUploadDir.exists()) continue;
                this.operationLog.info((Object)("Cleaning up a user session upload folder '" + sessionUploadDir.getAbsolutePath() + "'"));
                QueueingPathRemoverService.removeRecursively((File)sessionUploadDir);
            }
            catch (Exception e) {
                this.operationLog.warn((Object)("Could not clean up a user session upload folder '" + sessionUploadDir.getAbsolutePath() + "' together with the user session"), (Throwable)e);
            }
        }
    }

    private void validateSessionToken(String sessionToken) {
        this.validate(sessionToken, "Session token");
    }

    private void validateUploadId(String uploadId) {
        this.validate(uploadId, "Upload id");
    }

    private void validate(String uploadId, String name) {
        if (StringUtils.isBlank((CharSequence)uploadId)) {
            throw new UserFailureException(name + " cannot be null or empty");
        }
        if (uploadId.contains("/")) {
            throw new UserFailureException(name + " must not contain '/'");
        }
    }
}

