/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.api.v1;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.NewDataSetDTO;

public class PutDataSetUtil {
    public static void checkAccess(String sessionToken, IEncapsulatedOpenBISService service, NewDataSetDTO newDataSet, boolean noOwnerAllowed) {
        if (newDataSet == null) {
            throw new UserFailureException("New data set cannot be null");
        }
        NewDataSetDTO.DataSetOwner owner = newDataSet.getDataSetOwner();
        if (owner == null) {
            if (noOwnerAllowed) {
                return;
            }
            throw new UserFailureException("Owner of a new data set cannot be null");
        }
        String ownerIdentifier = owner.getIdentifier();
        if (ownerIdentifier == null) {
            throw new UserFailureException("Owner identifier of a new data set cannot be null");
        }
        switch (owner.getType()) {
            case EXPERIMENT: {
                service.checkExperimentAccess(sessionToken, ownerIdentifier);
                break;
            }
            case SAMPLE: {
                service.checkSampleAccess(sessionToken, ownerIdentifier);
                break;
            }
            case DATA_SET: {
                service.checkDataSetAccess(sessionToken, ownerIdentifier);
            }
        }
    }
}

