/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.entityregistration;

import ch.systemsx.cisd.common.parser.BeanProperty;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewProperty;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifierFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class SampleDataSetPair {
    private static final String SAMPLE_IDENTIFIER = "S_identifier";
    private static final String SAMPLE_CONTAINER = "S_container";
    private static final String SAMPLE_PARENT = "S_parent";
    private static final String SAMPLE_EXPERIMENT = "S_experiment";
    private static final String DATA_SET_CODE = "D_code";
    private static final String DATA_SET_FILE_TYPE = "D_file_type";
    private static final String FOLDER = "FOLDER";
    private final NewSample newSample;
    private final DataSetInformation dataSetInformation;
    private String[] tokens;
    private String folderName;
    private String fileFormatTypeCode;
    private SampleDataSetPairProcessing processingState = SampleDataSetPairProcessing.PENDING;

    public SampleDataSetPair() {
        this.newSample = new NewSample();
        this.dataSetInformation = new DataSetInformation();
    }

    public String[] getTokens() {
        return this.tokens;
    }

    public void setTokens(String[] tokens) {
        this.tokens = tokens;
    }

    public NewSample getNewSample() {
        return this.newSample;
    }

    public DataSetInformation getDataSetInformation() {
        return this.dataSetInformation;
    }

    @BeanProperty(label="S_identifier", optional=true)
    public void setSampleIdentifier(String sampleIdentifier) {
        this.newSample.setIdentifier(sampleIdentifier);
    }

    @BeanProperty(label="S_container", optional=true)
    public void setSampleContainerIdentifier(String container) {
        this.newSample.setContainerIdentifier(container);
    }

    @BeanProperty(label="S_parent", optional=true)
    public void setSampleParent(String parent) {
        this.newSample.setParents(parent);
    }

    @BeanProperty(label="S_experiment", optional=true)
    public void setSampleExperimentIdentifier(String experimentIdentifier) {
        this.newSample.setExperimentIdentifier(experimentIdentifier);
        this.dataSetInformation.setExperimentIdentifier(new ExperimentIdentifierFactory(experimentIdentifier).createIdentifier());
    }

    @BeanProperty(label="D_code", optional=true)
    public void setDataSetCode(String code) {
        this.dataSetInformation.setDataSetCode(code);
    }

    public String getFileFormatTypeCode() {
        return this.fileFormatTypeCode;
    }

    @BeanProperty(label="D_file_type", optional=true)
    public void setFileFormatTypeCode(String fileFormatType) {
        this.fileFormatTypeCode = fileFormatType;
    }

    public String getFolderName() {
        return this.folderName;
    }

    @BeanProperty(label="FOLDER", optional=false)
    public void setFolderName(String folderName) {
        this.folderName = folderName;
    }

    public void setSampleProperties(IEntityProperty[] properties) {
        this.newSample.setProperties(properties);
    }

    public void setDataSetProperties(List<NewProperty> properties) {
        this.dataSetInformation.setDataSetProperties(properties);
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        builder.append("sampleIdentifier", (Object)this.newSample.getIdentifier());
        builder.append("sampleProperties", (Object[])this.newSample.getProperties());
        builder.append("dataSetInformation", (Object)this.getDataSetInformation());
        return builder.toString();
    }

    public SampleUpdatesDTO getSampleUpdates(Sample sample) {
        List attachments = Collections.emptyList();
        SampleUpdatesDTO sampleUpdates = new SampleUpdatesDTO(TechId.create((IIdHolder)sample), Arrays.asList(this.newSample.getProperties()), this.getExperimentIdentifier(), null, attachments, sample.getVersion(), this.getSampleIdentifier(), this.newSample.getContainerIdentifier(), this.newSample.getParentsOrNull());
        return sampleUpdates;
    }

    private SampleIdentifier getSampleIdentifier() {
        return new SampleIdentifierFactory(this.newSample.getIdentifier()).createIdentifier();
    }

    private ExperimentIdentifier getExperimentIdentifier() {
        return this.dataSetInformation.getExperimentIdentifier();
    }

    public SampleDataSetPairProcessing getProcessingApplied() {
        return this.processingState;
    }

    public void setProcessingApplied(SampleDataSetPairProcessing processingApplied) {
        this.processingState = processingApplied;
    }

    static enum SampleDataSetPairProcessing {
        PENDING,
        REGISTERED_SAMPLE_AND_DATA_SET,
        UPDATED_SAMPLE_REGISTERED_DATA_SET,
        SKIPPED,
        FAILED;

    }
}

