/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.entityregistration;

import ch.systemsx.cisd.common.parser.AbstractParserObjectFactory;
import ch.systemsx.cisd.common.parser.IParserObjectFactory;
import ch.systemsx.cisd.common.parser.IParserObjectFactoryFactory;
import ch.systemsx.cisd.common.parser.IPropertyMapper;
import ch.systemsx.cisd.common.parser.IPropertyModel;
import ch.systemsx.cisd.common.parser.ParserException;
import ch.systemsx.cisd.etlserver.entityregistration.SampleDataSetPair;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewProperty;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

class SampleDataSetPairParserObjectFactory
extends AbstractParserObjectFactory<SampleDataSetPair> {
    private static final String DATASET_PREFIX = "d_";
    private static final String SAMPLE_PREFIX = "s_";
    private final SampleType sampleType;
    private final DataSetType dataSetType;
    private final DataSetKind dataSetKind;

    public static IParserObjectFactoryFactory<SampleDataSetPair> createFactoryFactory(final SampleType sampleType, final DataSetType dataSetType, final DataSetKind dataSetKind) {
        IParserObjectFactoryFactory<SampleDataSetPair> factoryFactory = new IParserObjectFactoryFactory<SampleDataSetPair>(){

            public final IParserObjectFactory<SampleDataSetPair> createFactory(IPropertyMapper propertyMapper) throws ParserException {
                return new SampleDataSetPairParserObjectFactory(sampleType, dataSetType, dataSetKind, propertyMapper);
            }
        };
        return factoryFactory;
    }

    private SampleDataSetPairParserObjectFactory(SampleType sampleType, DataSetType dataSetType, DataSetKind dataSetKind, IPropertyMapper propertyMapper) {
        super(SampleDataSetPair.class, propertyMapper);
        this.sampleType = sampleType;
        this.dataSetType = dataSetType;
        this.dataSetKind = dataSetKind;
    }

    private final PropertyType createPropertyType(String propertyTypeCode) {
        PropertyType propertyType = new PropertyType();
        DataType dataType = new DataType();
        dataType.setCode(DataTypeCode.VARCHAR);
        propertyType.setCode(propertyTypeCode);
        propertyType.setDataType(dataType);
        return propertyType;
    }

    private final void setProperties(SampleDataSetPair newSampleDataSet, String[] lineTokens) {
        ArrayList<IEntityProperty> sampleProperties = new ArrayList<IEntityProperty>();
        ArrayList<NewProperty> dataSetProperties = new ArrayList<NewProperty>();
        for (String unmatchedProperty : this.getUnmatchedProperties()) {
            String propertyDefault;
            IPropertyModel propertyModel = this.tryGetPropertyModel(unmatchedProperty);
            String propertyValue = this.getPropertyValue(lineTokens, propertyModel, propertyDefault = this.tryGetPropertyDefault(unmatchedProperty));
            if (StringUtils.isEmpty((CharSequence)propertyValue)) continue;
            if (unmatchedProperty.startsWith(SAMPLE_PREFIX)) {
                this.addEntityPropertyToList(SAMPLE_PREFIX, sampleProperties, unmatchedProperty, propertyValue);
                continue;
            }
            if (!unmatchedProperty.startsWith(DATASET_PREFIX)) continue;
            this.addNewPropertyToList(DATASET_PREFIX, dataSetProperties, unmatchedProperty, propertyValue);
        }
        newSampleDataSet.setSampleProperties(sampleProperties.toArray(IEntityProperty.EMPTY_ARRAY));
        newSampleDataSet.setDataSetProperties(dataSetProperties);
    }

    private void addEntityPropertyToList(String prefix, List<IEntityProperty> list, String unmatchedProperty, String propertyValue) {
        EntityProperty property = new EntityProperty();
        property.setPropertyType(this.createPropertyType(unmatchedProperty.substring(prefix.length())));
        property.setValue(propertyValue);
        list.add((IEntityProperty)property);
    }

    private void addNewPropertyToList(String prefix, List<NewProperty> list, String unmatchedProperty, String propertyValue) {
        NewProperty property = new NewProperty();
        property.setPropertyCode(unmatchedProperty.substring(prefix.length()));
        property.setValue(propertyValue);
        list.add(property);
    }

    protected boolean ignoreUnmatchedProperties() {
        return true;
    }

    public SampleDataSetPair createObject(String[] lineTokens) throws ParserException {
        boolean allTokensAreEmpty = true;
        for (String token : lineTokens) {
            if (token.trim().length() <= 0) continue;
            allTokensAreEmpty = false;
            break;
        }
        if (allTokensAreEmpty) {
            return null;
        }
        SampleDataSetPair newSampleDataSet = (SampleDataSetPair)super.createObject(lineTokens);
        newSampleDataSet.setTokens(lineTokens);
        this.setProperties(newSampleDataSet, lineTokens);
        this.cleanUpNewSample(newSampleDataSet);
        this.cleanUpDataSetInformation(newSampleDataSet);
        return newSampleDataSet;
    }

    private void cleanUpNewSample(SampleDataSetPair newSampleDataSet) {
        NewSample newSample = newSampleDataSet.getNewSample();
        newSample.setSampleType(this.sampleType);
        newSample.setContainerIdentifier(StringUtils.trimToNull((String)newSample.getContainerIdentifier()));
        if (newSample.getParentsOrNull() != null) {
            ArrayList<String> parents = new ArrayList<String>();
            for (String parent : newSample.getParentsOrNull()) {
                String trimmedOrNull = StringUtils.trimToNull((String)parent);
                if (trimmedOrNull == null) continue;
                parents.add(trimmedOrNull);
            }
            if (parents.size() == 0) {
                newSample.setParentsOrNull(null);
            } else {
                newSample.setParentsOrNull(parents.toArray(new String[0]));
            }
        }
        newSample.setExperimentIdentifier(StringUtils.trimToNull((String)newSample.getExperimentIdentifier()));
    }

    private void cleanUpDataSetInformation(SampleDataSetPair newSampleDataSet) {
        DataSetInformation dataSetInformation = newSampleDataSet.getDataSetInformation();
        dataSetInformation.setDataSetType(this.dataSetType);
        dataSetInformation.setDataSetKind(this.dataSetKind);
    }
}

