/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.hdf5;

import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.etlserver.AbstractStorageProcessor;
import ch.systemsx.cisd.etlserver.AbstractStorageProcessorTransaction;
import ch.systemsx.cisd.etlserver.IStorageProcessorTransactional;
import ch.systemsx.cisd.etlserver.ITypeExtractor;
import ch.systemsx.cisd.openbis.common.hdf5.HDF5Container;
import ch.systemsx.cisd.openbis.common.hdf5.HierarchicalStructureDuplicatorFileToHDF5;
import java.io.File;
import java.util.Properties;

public class HDF5StorageProcessor
extends AbstractStorageProcessor {
    private static final String HDF5_CONTAINER_FILE_NAME = "container.h5ar";
    public static final String COMPRESS_DATA_PROPERTY = "compress-data";
    private final boolean isDataCompressed;

    public HDF5StorageProcessor(Properties properties) {
        super(properties);
        this.isDataCompressed = PropertyUtils.getBoolean((Properties)properties, (String)COMPRESS_DATA_PROPERTY, (boolean)false);
    }

    @Override
    public IStorageProcessorTransactional.IStorageProcessorTransaction createTransaction(IStorageProcessorTransactional.StorageProcessorTransactionParameters parameters) {
        return new HDF5StorageProcessorTransaction(parameters, this.isDataCompressed, this.getDefaultUnstoreDataAction(null));
    }

    public static File getHDF5ContainerFile(File storedDataDirectory) {
        return new File(storedDataDirectory, HDF5_CONTAINER_FILE_NAME);
    }

    public static HDF5Container getHdf5Container(File storedDataDirectory) {
        return new HDF5Container(HDF5StorageProcessor.getHDF5ContainerFile(storedDataDirectory));
    }

    public static class HDF5StorageProcessorTransaction
    extends AbstractStorageProcessorTransaction {
        private static final long serialVersionUID = 1L;
        private transient File fileBeingProcessed;
        private final boolean isDataCompressed;
        private final IStorageProcessorTransactional.UnstoreDataAction unstoreDataAction;

        public HDF5StorageProcessorTransaction(IStorageProcessorTransactional.StorageProcessorTransactionParameters parameters, boolean isDataCompressed, IStorageProcessorTransactional.UnstoreDataAction unstoreAction) {
            super(parameters);
            HDF5StorageProcessor.checkParameters(parameters.getIncomingDataSetDirectory(), parameters.getRootDir());
            this.storedDataDirectory = parameters.getRootDir();
            this.isDataCompressed = isDataCompressed;
            this.unstoreDataAction = unstoreAction;
        }

        @Override
        public File executeStoreData(ITypeExtractor typeExtractor, IMailClient mailClient) {
            HDF5Container container = HDF5StorageProcessor.getHdf5Container(this.storedDataDirectory);
            container.runWriterClient(this.isDataCompressed, (HDF5Container.IHDF5WriterClient)new HierarchicalStructureDuplicatorFileToHDF5.DuplicatorWriterClient(this.incomingDataSetDirectory));
            this.fileBeingProcessed = this.incomingDataSetDirectory;
            return this.storedDataDirectory;
        }

        @Override
        public IStorageProcessorTransactional.UnstoreDataAction executeRollback(Throwable exception) {
            File storedFile = HDF5StorageProcessor.getHDF5ContainerFile(this.storedDataDirectory);
            storedFile.delete();
            this.fileBeingProcessed = null;
            return this.unstoreDataAction;
        }

        @Override
        public void executeCommit() {
            FileUtilities.deleteRecursively((File)this.fileBeingProcessed);
            this.fileBeingProcessed = null;
        }

        @Override
        public File tryGetProprietaryData() {
            return null;
        }
    }
}

