/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.path;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.etlserver.path.DatabaseBasedDataSetPathsInfoFeeder;
import ch.systemsx.cisd.etlserver.path.IPathsInfoDAO;
import ch.systemsx.cisd.etlserver.plugins.AbstractMaintenanceTaskWithStateFile;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.Hdf5AwareHierarchicalContentFactory;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.IHierarchicalContentFactory;
import ch.systemsx.cisd.openbis.dss.generic.shared.IDataSetDirectoryProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IShareIdManager;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IDatasetLocation;
import java.io.File;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import org.apache.log4j.Logger;

abstract class AbstractPathInfoDatabaseFeedingTask
extends AbstractMaintenanceTaskWithStateFile {
    static final String COMPUTE_CHECKSUM_KEY = "compute-checksum";
    static final String CHECKSUM_TYPE_KEY = "checksum-type";
    protected IDataSetDirectoryProvider directoryProvider;
    protected IPathsInfoDAO dao;
    protected boolean computeChecksum;
    protected String checksumType;

    AbstractPathInfoDatabaseFeedingTask() {
    }

    static String getAndCheckChecksumType(Properties properties) {
        String checksumType = properties.getProperty(CHECKSUM_TYPE_KEY);
        if (checksumType != null) {
            checksumType = checksumType.trim();
            try {
                MessageDigest.getInstance(checksumType);
            }
            catch (NoSuchAlgorithmException ex) {
                throw new ConfigurationFailureException("Unsupported checksum type: " + checksumType);
            }
        }
        return checksumType;
    }

    protected Long feedPathInfoDatabase(IDatasetLocation dataSet, boolean h5Folders, boolean h5arFolders) {
        IShareIdManager shareIdManager = this.directoryProvider.getShareIdManager();
        String dataSetCode = dataSet.getDataSetCode();
        shareIdManager.lock(dataSetCode);
        Long size = null;
        try {
            File dataSetRoot = this.directoryProvider.getDataSetDirectory(dataSet);
            if (!dataSetRoot.exists()) {
                this.getOperationLog().error((Object)("Root directory of data set " + dataSetCode + " does not exists: " + dataSetRoot));
                shareIdManager.releaseLocks();
                Long l = size;
                return l;
            }
            DatabaseBasedDataSetPathsInfoFeeder feeder = new DatabaseBasedDataSetPathsInfoFeeder(this.dao, (IHierarchicalContentFactory)new Hdf5AwareHierarchicalContentFactory(h5Folders, h5arFolders), this.computeChecksum, this.checksumType);
            Long id = this.dao.tryGetDataSetId(dataSetCode);
            if (id == null) {
                size = feeder.addPaths(dataSetCode, dataSet.getDataSetLocation(), dataSetRoot);
                feeder.commit();
                this.getOperationLog().info((Object)("Paths inside data set " + dataSetCode + " successfully added to database. Data set size: " + size));
            }
        }
        catch (Exception ex) {
            this.getOperationLog().error((Object)("Couldn't feed database with path infos of data set " + dataSetCode), (Throwable)ex);
            this.dao.rollback();
            throw ex;
        }
        finally {
            shareIdManager.releaseLocks();
        }
        return size;
    }

    protected abstract Logger getOperationLog();
}

