/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.path;

import ch.ethz.sis.openbis.generic.asapi.v3.IApplicationServerApi;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.ArchivingStatus;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.DataSet;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.fetchoptions.DataSetFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.search.DataSetSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.search.PhysicalDataSearchCriteria;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.common.time.DateTimeUtils;
import ch.systemsx.cisd.common.utilities.ICredentials;
import ch.systemsx.cisd.common.utilities.ITimeProvider;
import ch.systemsx.cisd.common.utilities.SystemTimeProvider;
import ch.systemsx.cisd.etlserver.path.TimeInterval;
import ch.systemsx.cisd.etlserver.plugins.AbstractMaintenanceTaskWithStateFile;
import ch.systemsx.cisd.openbis.dss.generic.shared.IDataSetDirectoryProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IHierarchicalContentProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.DataSetAndPathInfoDBConsistencyChecker;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;

public class DataSetAndPathInfoDBConsistencyCheckTask
extends AbstractMaintenanceTaskWithStateFile {
    private static final Comparator<DataSet> DATA_SET_COMPARATOR = new Comparator<DataSet>(){

        @Override
        public int compare(DataSet ds1, DataSet ds2) {
            long t2;
            long t1 = ds1.getRegistrationDate().getTime();
            if (t1 == (t2 = ds2.getRegistrationDate().getTime())) {
                return ds1.getCode().compareTo(ds2.getCode());
            }
            return t1 < t2 ? -1 : (t1 > t2 ? 1 : 0);
        }
    };
    private static final String TIME_FORMAT = "HH:mm";
    static final String CHECKING_TIME_INTERVAL_KEY = "checking-time-interval";
    static final String CHUNK_SIZE_KEY = "chunk-size";
    static final String PAUSING_TIME_POINT_KEY = "pausing-time-point";
    static final String CONTINUING_TIME_POINT_KEY = "continuing-time-point";
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, DataSetAndPathInfoDBConsistencyCheckTask.class);
    private static final Logger notificationLog = LogFactory.getLogger((LogCategory)LogCategory.NOTIFY, DataSetAndPathInfoDBConsistencyCheckTask.class);
    private IApplicationServerApi service;
    private IHierarchicalContentProvider fileProvider;
    private IHierarchicalContentProvider pathInfoProvider;
    private long timeInterval;
    private ITimeProvider timeProvider;
    private IDataSetDirectoryProvider directoryProvider;
    private Date pausingTime;
    private Date continuingTime;
    private int chunkSize;

    public DataSetAndPathInfoDBConsistencyCheckTask() {
    }

    DataSetAndPathInfoDBConsistencyCheckTask(IHierarchicalContentProvider fileProvider, IHierarchicalContentProvider pathInfoProvider, IDataSetDirectoryProvider directoryProvider, IApplicationServerApi service, ITimeProvider timeProvider) {
        this.fileProvider = fileProvider;
        this.pathInfoProvider = pathInfoProvider;
        this.directoryProvider = directoryProvider;
        this.service = service;
        this.timeProvider = timeProvider;
    }

    public void setUp(String pluginName, Properties properties) {
        if (this.service == null) {
            this.service = ServiceProvider.getV3ApplicationService();
            this.timeProvider = SystemTimeProvider.SYSTEM_TIME_PROVIDER;
            this.directoryProvider = ServiceProvider.getDataStoreService().getDataSetDirectoryProvider();
        }
        this.chunkSize = PropertyUtils.getInt((Properties)properties, (String)CHUNK_SIZE_KEY, (int)1000);
        this.pausingTime = this.getTime(properties, PAUSING_TIME_POINT_KEY, null);
        this.continuingTime = this.getTime(properties, CONTINUING_TIME_POINT_KEY, null);
        this.defineStateFile(properties, this.directoryProvider.getStoreRoot());
        this.timeInterval = DateTimeUtils.getDurationInMillis((Properties)properties, (String)CHECKING_TIME_INTERVAL_KEY, (long)86400000L);
    }

    public void execute() {
        if (this.pausingTime != null) {
            this.executeInterruptingMode();
        } else {
            Date youngerThanDate = this.getOriginalStartingTime();
            List<DataSet> dataSets = this.getNextDataSets(youngerThanDate, null, this.readTimestampAndCodeFromStateFile());
            operationLog.info((Object)("Check " + dataSets.size() + " data sets registered since " + DATE_FORMAT.format(youngerThanDate)));
            DataSetAndPathInfoDBConsistencyChecker checker = new DataSetAndPathInfoDBConsistencyChecker(this.fileProvider, this.pathInfoProvider);
            for (DataSet dataSet : dataSets) {
                checker.checkDataSet(dataSet.getCode());
            }
            this.reportErrorOrInconsistencies(checker, youngerThanDate, null);
        }
    }

    private void reportErrorOrInconsistencies(DataSetAndPathInfoDBConsistencyChecker checker, Date youngerThanDate, Date olderThanDateOrNull) {
        if (!checker.noErrorAndInconsistencyFound()) {
            StringBuilder builder = new StringBuilder();
            if (olderThanDateOrNull == null) {
                builder.append("File system and path info DB consistency check report for all data sets since ");
                builder.append(DATE_FORMAT.format(youngerThanDate)).append("\n\n");
            } else {
                builder.append("File system and path info DB consistency check report for all data sets between ");
                builder.append(DATE_FORMAT.format(youngerThanDate)).append(" and ");
                builder.append(DATE_FORMAT.format(olderThanDateOrNull)).append("\n\n");
            }
            builder.append(checker.createReport());
            notificationLog.error((Object)builder.toString());
        }
    }

    private void executeInterruptingMode() {
        Date lastRegistrationDate;
        Date now = new Date(this.timeProvider.getTimeInMilliseconds());
        TimeInterval interval = new TimeInterval(this.continuingTime, this.pausingTime, now);
        if (!interval.isInTimeInterval(now)) {
            return;
        }
        DataSetAndPathInfoDBConsistencyChecker checker = new DataSetAndPathInfoDBConsistencyChecker(this.fileProvider, this.pathInfoProvider);
        Date originalStartingTime = this.getOriginalStartingTime();
        Date registrationDate = lastRegistrationDate = this.getLastRegistrationDate(originalStartingTime);
        DataSetIterable dataSetIterable = new DataSetIterable(registrationDate, originalStartingTime);
        for (DataSet dataSet : dataSetIterable) {
            checker.checkDataSet(dataSet.getCode());
            registrationDate = dataSet.getRegistrationDate();
            this.updateTimeStampFile(this.renderTimeStampAndCode(registrationDate, dataSet.getCode()));
            if (this.isInInterval(interval)) continue;
            break;
        }
        this.reportErrorOrInconsistencies(checker, lastRegistrationDate, registrationDate);
    }

    private boolean isInInterval(TimeInterval interval) {
        return interval.isInTimeInterval(new Date(this.timeProvider.getTimeInMilliseconds()));
    }

    private List<DataSet> getNextDataSets(Date registrationDate, Integer count, String timestampAndCodeOrNull) {
        String sessionToken = this.login();
        DataSetSearchCriteria searchCriteria = new DataSetSearchCriteria();
        searchCriteria.withRegistrationDate().thatIsLaterThanOrEqualTo(registrationDate);
        PhysicalDataSearchCriteria physicalDataSearchCriteria = searchCriteria.withPhysicalData();
        physicalDataSearchCriteria.withStorageConfirmation().thatEquals(true);
        physicalDataSearchCriteria.withStatus().thatEquals((Enum)ArchivingStatus.AVAILABLE);
        DataSetFetchOptions fetchOptions = new DataSetFetchOptions();
        fetchOptions.sortBy().registrationDate();
        if (count != null) {
            fetchOptions.count(count);
        }
        List dataSets = this.service.searchDataSets(sessionToken, searchCriteria, fetchOptions).getObjects();
        this.service.logout(sessionToken);
        Collections.sort(dataSets, DATA_SET_COMPARATOR);
        return dataSets.stream().filter(dataSet -> this.notAlreadySeenDataSet((DataSet)dataSet, timestampAndCodeOrNull)).collect(Collectors.toList());
    }

    private String readTimestampAndCodeFromStateFile() {
        if (this.stateFile == null || !this.stateFile.exists()) {
            return null;
        }
        return FileUtilities.loadToString((File)this.stateFile).trim();
    }

    private boolean notAlreadySeenDataSet(DataSet dataSet, String timestampAndCodeOrNull) {
        if (timestampAndCodeOrNull == null) {
            return true;
        }
        String timeStampAndCodeOfDataSet = this.renderTimeStampAndCode(dataSet.getRegistrationDate(), dataSet.getCode());
        return timeStampAndCodeOfDataSet.compareTo(timestampAndCodeOrNull) > 0;
    }

    private Date getOriginalStartingTime() {
        return new Date(this.timeProvider.getTimeInMilliseconds() - this.timeInterval);
    }

    String login() {
        ICredentials credentials = this.getEtlServerCredentials();
        String sessionToken = this.service.login(credentials.getUserId(), credentials.getPassword());
        return sessionToken;
    }

    private Date getTime(Properties properties, String key, Date defaultOrNull) {
        String timeString = properties.getProperty(key);
        if (timeString == null) {
            return defaultOrNull;
        }
        SimpleDateFormat format = new SimpleDateFormat(TIME_FORMAT);
        try {
            return format.parse(timeString);
        }
        catch (ParseException ex) {
            throw new UserFailureException("Invalid format of property '" + key + "': " + timeString);
        }
    }

    private class DataSetIterable
    implements Iterable<DataSet> {
        private Date lastRegistrationDate;
        private Date originalStartingTime;

        DataSetIterable(Date lastRegistrationDate, Date originalStartingTime) {
            this.lastRegistrationDate = lastRegistrationDate;
            this.originalStartingTime = originalStartingTime;
        }

        @Override
        public Iterator<DataSet> iterator() {
            return new Iterator<DataSet>(){
                private List<DataSet> currentChunk;
                private int index;

                @Override
                public boolean hasNext() {
                    if (this.currentChunk == null || this.index == this.currentChunk.size()) {
                        String timestampAndCode = DataSetAndPathInfoDBConsistencyCheckTask.this.readTimestampAndCodeFromStateFile();
                        this.currentChunk = DataSetAndPathInfoDBConsistencyCheckTask.this.getNextDataSets(DataSetIterable.this.lastRegistrationDate, DataSetAndPathInfoDBConsistencyCheckTask.this.chunkSize, timestampAndCode);
                        if (this.currentChunk.isEmpty()) {
                            DataSetIterable.this.lastRegistrationDate = DataSetIterable.this.originalStartingTime;
                            this.currentChunk = DataSetAndPathInfoDBConsistencyCheckTask.this.getNextDataSets(DataSetIterable.this.lastRegistrationDate, DataSetAndPathInfoDBConsistencyCheckTask.this.chunkSize, null);
                        }
                        operationLog.info((Object)("Check " + this.currentChunk.size() + " data sets registered since " + DATE_FORMAT.format(DataSetIterable.this.lastRegistrationDate)));
                        this.index = 0;
                    }
                    return !this.currentChunk.isEmpty();
                }

                @Override
                public DataSet next() {
                    DataSet dataSet = this.currentChunk.get(this.index++);
                    DataSetIterable.this.lastRegistrationDate = dataSet.getRegistrationDate();
                    return dataSet;
                }
            };
        }
    }
}

