/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.path;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.action.IDelegatedAction;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.etlserver.IDataSetPathsInfoFeeder;
import ch.systemsx.cisd.etlserver.path.IPathsInfoDAO;
import ch.systemsx.cisd.etlserver.path.PathEntryDTO;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.IHierarchicalContentFactory;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.PathInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;

public class DatabaseBasedDataSetPathsInfoFeeder
implements IDataSetPathsInfoFeeder {
    private static final int BATCH_SIZE = 500;
    private final IPathsInfoDAO dao;
    private final IHierarchicalContentFactory hierarchicalContentFactory;
    private final List<PathEntryDTO> filePaths = new ArrayList<PathEntryDTO>(500);
    private final boolean computeChecksum;
    private final String checksumType;

    public DatabaseBasedDataSetPathsInfoFeeder(IPathsInfoDAO dao, IHierarchicalContentFactory hierarchicalContentFactory, boolean computeChecksum, String checksumType) {
        this.dao = dao;
        this.hierarchicalContentFactory = hierarchicalContentFactory;
        this.computeChecksum = computeChecksum;
        this.checksumType = checksumType;
    }

    @Override
    public long addPaths(String dataSetCode, String location, File dataSetRoot) {
        long dataSetId = this.dao.createDataSet(dataSetCode, location);
        IHierarchicalContent content = this.hierarchicalContentFactory.asHierarchicalContent(dataSetRoot, IDelegatedAction.DO_NOTHING);
        PathInfo root = PathInfo.createPathInfo(this.hierarchicalContentFactory.asHierarchicalContentNode(content, dataSetRoot), this.computeChecksum, this.checksumType);
        this.addPaths(dataSetId, null, "", root);
        return root.getSizeInBytes();
    }

    private void addPaths(long dataSetId, Long parentId, String pathPrefix, PathInfo pathInfo) {
        String relativePath;
        boolean directory = pathInfo.isDirectory();
        String fileName = pathInfo.getFileName();
        String string = relativePath = parentId == null ? "" : pathPrefix + fileName;
        if (directory) {
            File file = pathInfo.getFile();
            if (file != null && FileUtilities.isHDF5ContainerFile((File)file)) {
                try {
                    PathInfo.setChecksum(pathInfo, new FileInputStream(file), this.computeChecksum, this.checksumType);
                }
                catch (FileNotFoundException ex) {
                    throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
                }
            }
            long directoryId = this.dao.createDataSetFile(dataSetId, parentId, relativePath, fileName, pathInfo.getSizeInBytes(), directory, pathInfo.getChecksumCRC32(), pathInfo.getChecksum(), pathInfo.getLastModifiedDate());
            if (relativePath.length() > 0) {
                relativePath = relativePath + '/';
            }
            List<PathInfo> children = pathInfo.getChildren();
            for (PathInfo child : children) {
                this.addPaths(dataSetId, directoryId, relativePath, child);
            }
        } else {
            this.addFilePathToBatch(new PathEntryDTO(dataSetId, parentId, relativePath, fileName, pathInfo.getSizeInBytes(), pathInfo.getChecksumCRC32(), pathInfo.getChecksum(), false, pathInfo.getLastModifiedDate()));
        }
    }

    private void addFilePathToBatch(PathEntryDTO filePath) {
        this.filePaths.add(filePath);
        if (this.filePaths.size() == 500) {
            this.dao.createDataSetFiles(this.filePaths);
            this.filePaths.clear();
        }
    }

    @Override
    public void commit() {
        if (!this.filePaths.isEmpty()) {
            this.dao.createDataSetFiles(this.filePaths);
            this.filePaths.clear();
        }
        this.dao.commit();
    }
}

