/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.path;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.maintenance.IMaintenanceTask;
import ch.systemsx.cisd.common.utilities.ITimeProvider;
import ch.systemsx.cisd.common.utilities.SystemTimeProvider;
import ch.systemsx.cisd.etlserver.path.AbstractPathInfoDatabaseFeedingTask;
import ch.systemsx.cisd.etlserver.path.IPathsInfoDAO;
import ch.systemsx.cisd.etlserver.path.PathEntryDTO;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import ch.systemsx.cisd.openbis.dss.generic.shared.IHierarchicalContentProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.PathInfo;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.PathInfoDataSourceProvider;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import javax.sql.DataSource;
import net.lemnik.eodsql.QueryTool;
import org.apache.log4j.Logger;

public class PathInfoDatabaseChecksumCalculationTask
implements IMaintenanceTask {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, PathInfoDatabaseChecksumCalculationTask.class);
    private IPathsInfoDAO dao;
    private IHierarchicalContentProvider hierarchicalContentProvider;
    private ITimeProvider timeProvider;
    private String checksumType;

    public PathInfoDatabaseChecksumCalculationTask() {
    }

    PathInfoDatabaseChecksumCalculationTask(IPathsInfoDAO dao, IHierarchicalContentProvider hierarchicalContentProvider, ITimeProvider timeProvider, String checksumType) {
        this.dao = dao;
        this.hierarchicalContentProvider = hierarchicalContentProvider;
        this.timeProvider = timeProvider;
        this.checksumType = checksumType;
    }

    public void setUp(String pluginName, Properties properties) {
        this.dao = (IPathsInfoDAO)QueryTool.getQuery((DataSource)PathInfoDataSourceProvider.getDataSource(), IPathsInfoDAO.class);
        this.hierarchicalContentProvider = ServiceProvider.getHierarchicalContentProvider();
        this.timeProvider = SystemTimeProvider.SYSTEM_TIME_PROVIDER;
        this.checksumType = AbstractPathInfoDatabaseFeedingTask.getAndCheckChecksumType(properties);
    }

    public void execute() {
        Map<String, List<PathEntryDTO>> entriesOrderedByDataSets = this.getPathEntries();
        Set<Map.Entry<String, List<PathEntryDTO>>> entrySet = entriesOrderedByDataSets.entrySet();
        int dataSetCounter = 0;
        int fileCounter = 0;
        for (Map.Entry<String, List<PathEntryDTO>> entry : entrySet) {
            long t0 = this.timeProvider.getTimeInMilliseconds();
            String dataSetCode = entry.getKey();
            try {
                IHierarchicalContent content = this.hierarchicalContentProvider.asContentWithoutModifyingAccessTimestamp(dataSetCode);
                try {
                    List<PathEntryDTO> pathEntries = entry.getValue();
                    for (PathEntryDTO pathEntry : pathEntries) {
                        IHierarchicalContentNode node = content.getNode(pathEntry.getRelativePath());
                        InputStream inputStream = node.getInputStream();
                        PathInfo pathInfo = new PathInfo();
                        PathInfo.setChecksum(pathInfo, inputStream, true, this.checksumType);
                        this.dao.updateChecksum(pathEntry.getId(), pathInfo.getChecksumCRC32(), pathInfo.getChecksum());
                        ++fileCounter;
                    }
                    this.dao.commit();
                    operationLog.info((Object)((this.timeProvider.getTimeInMilliseconds() - t0 + 500L) / 1000L + " seconds needed to update checksums of " + pathEntries.size() + " files of data set " + dataSetCode + "."));
                    ++dataSetCounter;
                }
                catch (Exception ex) {
                    operationLog.error((Object)("Couldn't update checksum for some file in data set " + dataSetCode), (Throwable)ex);
                    this.dao.rollback();
                }
            }
            catch (IllegalArgumentException ex) {
                operationLog.debug((Object)ex.getMessage());
            }
        }
        operationLog.info((Object)("Checksums of " + fileCounter + " files in " + dataSetCounter + " data sets have been calculated."));
    }

    private Map<String, List<PathEntryDTO>> getPathEntries() {
        List<PathEntryDTO> entries = this.dao.listDataSetFilesWithUnkownChecksum();
        TreeMap<String, List<PathEntryDTO>> entriesOrderedByDataSets = new TreeMap<String, List<PathEntryDTO>>();
        for (PathEntryDTO pathEntryDTO : entries) {
            String dataSetCode = pathEntryDTO.getDataSetCode();
            ArrayList<PathEntryDTO> list = (ArrayList<PathEntryDTO>)entriesOrderedByDataSets.get(dataSetCode);
            if (list == null) {
                list = new ArrayList<PathEntryDTO>();
                entriesOrderedByDataSets.put(dataSetCode, list);
            }
            list.add(pathEntryDTO);
        }
        this.dao.commit();
        operationLog.info((Object)("Start calculating checksums of " + entries.size() + " files in " + entriesOrderedByDataSets.size() + " data sets."));
        return entriesOrderedByDataSets;
    }
}

