/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.path;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.common.time.DateTimeUtils;
import ch.systemsx.cisd.common.utilities.ITimeProvider;
import ch.systemsx.cisd.common.utilities.SystemTimeProvider;
import ch.systemsx.cisd.etlserver.path.AbstractPathInfoDatabaseFeedingTask;
import ch.systemsx.cisd.etlserver.path.IPathsInfoDAO;
import ch.systemsx.cisd.etlserver.postregistration.ICleanupTask;
import ch.systemsx.cisd.etlserver.postregistration.IPostRegistrationTask;
import ch.systemsx.cisd.etlserver.postregistration.IPostRegistrationTaskExecutor;
import ch.systemsx.cisd.etlserver.postregistration.NoCleanupTask;
import ch.systemsx.cisd.openbis.dss.generic.shared.IDataSetDirectoryProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.PathInfoDataSourceProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IDatasetLocation;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PhysicalDataSet;
import ch.systemsx.cisd.openbis.generic.shared.dto.SimpleDataSetInformationDTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.sql.DataSource;
import net.lemnik.eodsql.QueryTool;
import org.apache.log4j.Logger;

public class PathInfoDatabaseFeedingTask
extends AbstractPathInfoDatabaseFeedingTask
implements IPostRegistrationTask {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, PathInfoDatabaseFeedingTask.class);
    static final String CHUNK_SIZE_KEY = "data-set-chunk-size";
    static final int DEFAULT_CHUNK_SIZE = 1000;
    static final String MAX_NUMBER_OF_CHUNKS_KEY = "max-number-of-chunks";
    static final int DEFAULT_MAX_NUMBER_OF_DATA_SETS = -1;
    static final String TIME_LIMIT_KEY = "time-limit";
    private IEncapsulatedOpenBISService service;
    private ITimeProvider timeProvider;
    private int chunkSize;
    private int maxNumerOfChunks;
    private long timeLimit;
    private static final int waitingPeriodForStorageConfirmationInSeconds = 3600;

    private static IPathsInfoDAO createDAO() {
        return (IPathsInfoDAO)QueryTool.getQuery((DataSource)PathInfoDataSourceProvider.getDataSource(), IPathsInfoDAO.class);
    }

    private static IDataSetDirectoryProvider getDirectoryProvider() {
        return ServiceProvider.getDataStoreService().getDataSetDirectoryProvider();
    }

    public PathInfoDatabaseFeedingTask() {
    }

    public PathInfoDatabaseFeedingTask(Properties properties, IEncapsulatedOpenBISService service) {
        this(service, PathInfoDatabaseFeedingTask.getDirectoryProvider(), PathInfoDatabaseFeedingTask.createDAO(), (ITimeProvider)SystemTimeProvider.SYSTEM_TIME_PROVIDER, PathInfoDatabaseFeedingTask.getComputeChecksumFlag(properties), PathInfoDatabaseFeedingTask.getAndCheckChecksumType(properties), 0, 0, 0L);
    }

    @Private
    PathInfoDatabaseFeedingTask(IEncapsulatedOpenBISService service, IDataSetDirectoryProvider directoryProvider, IPathsInfoDAO dao, ITimeProvider timeProvider, boolean computeChecksum, String checksumType, int chunkSize, int maxNumberOfChunks, long timeLimit) {
        this.service = service;
        this.directoryProvider = directoryProvider;
        this.dao = dao;
        this.timeProvider = timeProvider;
        this.computeChecksum = computeChecksum;
        this.checksumType = checksumType;
        this.chunkSize = chunkSize;
        this.maxNumerOfChunks = maxNumberOfChunks;
        this.timeLimit = timeLimit;
    }

    @Override
    public boolean requiresDataStoreLock() {
        return false;
    }

    public void setUp(String pluginName, Properties properties) {
        this.service = ServiceProvider.getOpenBISService();
        this.directoryProvider = PathInfoDatabaseFeedingTask.getDirectoryProvider();
        this.timeProvider = SystemTimeProvider.SYSTEM_TIME_PROVIDER;
        this.dao = PathInfoDatabaseFeedingTask.createDAO();
        this.computeChecksum = PathInfoDatabaseFeedingTask.getComputeChecksumFlag(properties);
        this.checksumType = PathInfoDatabaseFeedingTask.getAndCheckChecksumType(properties);
        this.chunkSize = PropertyUtils.getInt((Properties)properties, (String)CHUNK_SIZE_KEY, (int)1000);
        this.maxNumerOfChunks = PropertyUtils.getInt((Properties)properties, (String)MAX_NUMBER_OF_CHUNKS_KEY, (int)-1);
        this.timeLimit = DateTimeUtils.getDurationInMillis((Properties)properties, (String)TIME_LIMIT_KEY, (long)0L);
        StringBuilder builder = new StringBuilder(pluginName);
        builder.append(" intialized with chunk size = ").append(this.chunkSize).append(".");
        if (this.timeLimit > 0L) {
            builder.append(" Time limit: ").append(DateTimeUtils.renderDuration((long)this.timeLimit));
        } else if (this.maxNumerOfChunks > 0) {
            builder.append(" Maximum number of chunks: ").append(this.maxNumerOfChunks);
        }
        operationLog.info((Object)builder.toString());
    }

    private static boolean getComputeChecksumFlag(Properties properties) {
        return PropertyUtils.getBoolean((Properties)properties, (String)"compute-checksum", (boolean)false);
    }

    public void execute() {
        List<SimpleDataSetInformationDTO> dataSets;
        IStopCondition stopCondition = this.createStopCondition();
        int chunkCount = 0;
        operationLog.info((Object)"Start feeding.");
        HashSet<String> processedDataSets = new HashSet<String>();
        do {
            dataSets = this.filteredDataSets(this.getNextChunk(), processedDataSets);
            operationLog.info((Object)("Feeding " + ++chunkCount + ". chunk. " + dataSets.size() + " data sets."));
            Date maxRegistrationTimestamp = null;
            for (SimpleDataSetInformationDTO dataSet : dataSets) {
                this.feedPathInfoDatabase((IDatasetLocation)dataSet, dataSet.isH5Folders(), dataSet.isH5ArFolders());
                processedDataSets.add(dataSet.getDataSetCode());
                Date registrationTimestamp = dataSet.getRegistrationTimestamp();
                if (maxRegistrationTimestamp == null || maxRegistrationTimestamp.getTime() < registrationTimestamp.getTime()) {
                    maxRegistrationTimestamp = registrationTimestamp;
                }
                stopCondition.handle(dataSet);
            }
            if (maxRegistrationTimestamp == null) continue;
            this.dao.deleteLastFeedingEvent();
            this.dao.createLastFeedingEvent(maxRegistrationTimestamp);
            this.dao.commit();
        } while (dataSets.size() >= this.chunkSize && !stopCondition.fulfilled());
        operationLog.info((Object)"Feeding finished.");
    }

    @Override
    public void clearCache() {
    }

    @Override
    protected Logger getOperationLog() {
        return operationLog;
    }

    private List<SimpleDataSetInformationDTO> filteredDataSets(List<SimpleDataSetInformationDTO> dataSets, Set<String> processedDataSets) {
        ArrayList<SimpleDataSetInformationDTO> result = new ArrayList<SimpleDataSetInformationDTO>();
        for (SimpleDataSetInformationDTO dataSet : dataSets) {
            if (processedDataSets.contains(dataSet.getDataSetCode())) continue;
            result.add(dataSet);
        }
        return result;
    }

    private List<SimpleDataSetInformationDTO> getNextChunk() {
        List<SimpleDataSetInformationDTO> dataSets;
        long start = System.currentTimeMillis();
        float waitingTime = 1000.0f;
        while (System.currentTimeMillis() - start < 3600000L) {
            dataSets = this.listDataSets();
            SimpleDataSetInformationDTO nonConfirmedData = this.findFirstNonConfirmedDataSet(dataSets);
            if (nonConfirmedData == null) {
                return dataSets;
            }
            long waitingTimeInMiliseconds = (long)waitingTime;
            operationLog.info((Object)("One of the data sets selected for path-info feeding doesn't yet have storage confirmed " + nonConfirmedData.getDataSetCode() + ". Will wait for " + waitingTimeInMiliseconds / 1000L + " seconds"));
            try {
                Thread.sleep(waitingTimeInMiliseconds);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            waitingTime = (float)((double)waitingTime * 1.5);
        }
        dataSets = this.listDataSets();
        ArrayList<SimpleDataSetInformationDTO> result = new ArrayList<SimpleDataSetInformationDTO>();
        for (SimpleDataSetInformationDTO dataSet : dataSets) {
            if (dataSet.isStorageConfirmed()) {
                result.add(dataSet);
                continue;
            }
            operationLog.error((Object)("Gave up on feeding path-info db for data set " + dataSet.getDataSetCode() + ""));
        }
        return result;
    }

    private SimpleDataSetInformationDTO findFirstNonConfirmedDataSet(List<SimpleDataSetInformationDTO> dataSets) {
        for (SimpleDataSetInformationDTO dataSet : dataSets) {
            if (dataSet.isStorageConfirmed()) continue;
            return dataSet;
        }
        return null;
    }

    private List<SimpleDataSetInformationDTO> listDataSets() {
        Date timestamp = this.dao.getRegistrationTimestampOfLastFeedingEvent();
        return this.listDataSets(timestamp, this.chunkSize);
    }

    private List<SimpleDataSetInformationDTO> listDataSets(Date timestamp, int actualChunkSize) {
        List<SimpleDataSetInformationDTO> result = timestamp == null ? this.service.listOldestPhysicalDataSets(actualChunkSize) : this.service.listOldestPhysicalDataSets(timestamp, actualChunkSize);
        if (result.size() < actualChunkSize || !this.allRegistrationTimeStampsTheSame(result)) {
            return result;
        }
        operationLog.warn((Object)("There are at least " + actualChunkSize + " data sets with same registration time stamp. Twice the chunk size will be tried."));
        return this.listDataSets(timestamp, 2 * actualChunkSize);
    }

    private boolean allRegistrationTimeStampsTheSame(List<SimpleDataSetInformationDTO> dataSets) {
        HashSet<Date> registrationTimeStamps = new HashSet<Date>();
        for (SimpleDataSetInformationDTO dataSet : dataSets) {
            registrationTimeStamps.add(dataSet.getRegistrationTimestamp());
        }
        return registrationTimeStamps.size() == 1;
    }

    @Override
    public IPostRegistrationTaskExecutor createExecutor(final String dataSetCode, boolean container) {
        return new IPostRegistrationTaskExecutor(){

            @Override
            public ICleanupTask createCleanupTask() {
                return new NoCleanupTask();
            }

            @Override
            public void execute() {
                AbstractExternalData dataSet = PathInfoDatabaseFeedingTask.this.service.tryGetDataSet(dataSetCode);
                if (dataSet == null) {
                    operationLog.error((Object)("Data set " + dataSetCode + " unknown to openBIS."));
                    return;
                }
                if (!dataSet.isContainer()) {
                    PhysicalDataSet dataSetLocation;
                    Long size;
                    boolean h5Folders = false;
                    boolean h5arFolders = false;
                    if (dataSet instanceof PhysicalDataSet) {
                        PhysicalDataSet d = (PhysicalDataSet)dataSet;
                        h5Folders = d.isH5Folders();
                        h5arFolders = d.isH5arFolders();
                    }
                    if ((size = PathInfoDatabaseFeedingTask.this.feedPathInfoDatabase((IDatasetLocation)(dataSetLocation = dataSet.tryGetAsDataSet()), h5Folders, h5arFolders)) != null) {
                        PathInfoDatabaseFeedingTask.this.service.updatePhysicalDataSetsSize(Collections.singletonMap(dataSet.getCode(), size));
                    }
                }
            }
        };
    }

    private IStopCondition createStopCondition() {
        if (this.timeLimit > 0L) {
            return this.createStopConditionForTimeLimit();
        }
        if (this.maxNumerOfChunks > 0) {
            return this.createStopConditionForMaxNumber();
        }
        return new IStopCondition(){

            @Override
            public void handle(SimpleDataSetInformationDTO dataSet) {
            }

            @Override
            public boolean fulfilled() {
                return false;
            }
        };
    }

    private IStopCondition createStopConditionForMaxNumber() {
        return new IStopCondition(){
            private int count;

            @Override
            public void handle(SimpleDataSetInformationDTO dataSet) {
            }

            @Override
            public boolean fulfilled() {
                return ++this.count >= PathInfoDatabaseFeedingTask.this.maxNumerOfChunks;
            }
        };
    }

    private IStopCondition createStopConditionForTimeLimit() {
        return new IStopCondition(){
            private long startTime;
            {
                this.startTime = PathInfoDatabaseFeedingTask.this.timeProvider.getTimeInMilliseconds();
            }

            @Override
            public void handle(SimpleDataSetInformationDTO dataSet) {
            }

            @Override
            public boolean fulfilled() {
                return PathInfoDatabaseFeedingTask.this.timeProvider.getTimeInMilliseconds() - this.startTime > PathInfoDatabaseFeedingTask.this.timeLimit;
            }
        };
    }

    private static interface IStopCondition {
        public void handle(SimpleDataSetInformationDTO var1);

        public boolean fulfilled();
    }
}

