/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.path;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.etlserver.path.AbstractPathInfoDatabaseFeedingTask;
import ch.systemsx.cisd.etlserver.path.IPathsInfoDAO;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.IHierarchicalContentFactory;
import ch.systemsx.cisd.openbis.dss.generic.shared.IDataSetDirectoryProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.PathInfoDataSourceProvider;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SearchCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetArchivingStatus;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IDatasetLocation;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PhysicalDataSet;
import java.io.File;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import net.lemnik.eodsql.QueryTool;
import org.apache.log4j.Logger;

public class PathInfoDatabaseRefreshingTask
extends AbstractPathInfoDatabaseFeedingTask {
    static final String DATA_SET_TYPE_KEY = "data-set-type";
    static final String TIME_STAMP_OF_YOUNGEST_DATA_SET_KEY = "time-stamp-of-youngest-data-set";
    static final String CHUNK_SIZE_KEY = "chunk-size";
    private static final int DEFAULT_CHUNK_SIZE = 100;
    private static final Comparator<AbstractExternalData> REVERSE_REGISTRATION_DATE_COMPARATOR = new Comparator<AbstractExternalData>(){

        @Override
        public int compare(AbstractExternalData ds1, AbstractExternalData ds2) {
            long t2;
            long t1 = ds1.getRegistrationDate().getTime();
            if (t1 == (t2 = ds2.getRegistrationDate().getTime())) {
                return -ds1.getCode().compareTo(ds2.getCode());
            }
            return t1 < t2 ? 1 : (t1 > t2 ? -1 : 0);
        }
    };
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, PathInfoDatabaseRefreshingTask.class);
    private IEncapsulatedOpenBISService service;
    private String timeStampAndCodeOfYoungestDataSet;
    private int chunkSize;
    private String dataSetType;

    public PathInfoDatabaseRefreshingTask() {
    }

    PathInfoDatabaseRefreshingTask(IEncapsulatedOpenBISService service, IPathsInfoDAO dao, IHierarchicalContentFactory hierarchicalContentFactory, IDataSetDirectoryProvider directoryProvider) {
        this.service = service;
        this.dao = dao;
        this.directoryProvider = directoryProvider;
    }

    public void setUp(String pluginName, Properties properties) {
        if (this.service == null) {
            this.service = ServiceProvider.getOpenBISService();
            this.dao = (IPathsInfoDAO)QueryTool.getQuery((DataSource)PathInfoDataSourceProvider.getDataSource(), IPathsInfoDAO.class);
            this.directoryProvider = ServiceProvider.getDataStoreService().getDataSetDirectoryProvider();
        }
        this.defineStateFile(properties, this.directoryProvider.getStoreRoot());
        this.timeStampAndCodeOfYoungestDataSet = this.tryGetTimeStampAndCodeOfYoungestDataSet(properties);
        if (!this.stateFile.exists() && this.timeStampAndCodeOfYoungestDataSet == null) {
            throw new ConfigurationFailureException("Either property 'time-stamp-of-youngest-data-set' is defined or '" + this.stateFile.getAbsolutePath() + "' exists.");
        }
        this.chunkSize = PropertyUtils.getInt((Properties)properties, (String)CHUNK_SIZE_KEY, (int)100);
        this.computeChecksum = PropertyUtils.getBoolean((Properties)properties, (String)"compute-checksum", (boolean)true);
        this.checksumType = PathInfoDatabaseRefreshingTask.getAndCheckChecksumType(properties);
        this.dataSetType = properties.getProperty(DATA_SET_TYPE_KEY);
    }

    private String tryGetTimeStampAndCodeOfYoungestDataSet(Properties properties) {
        String ts = properties.getProperty(TIME_STAMP_OF_YOUNGEST_DATA_SET_KEY);
        if (ts == null) {
            return null;
        }
        try {
            this.parseTimeStamp(ts);
            return ts;
        }
        catch (ParseException ex) {
            throw new ConfigurationFailureException("Invalid property 'time-stamp-of-youngest-data-set': " + ts, (Throwable)ex);
        }
    }

    public void execute() {
        List<PhysicalDataSet> dataSets = this.getPhysicalDataSets();
        if (dataSets.isEmpty()) {
            return;
        }
        operationLog.info((Object)("Refresh path info for " + dataSets.size() + " physical data sets."));
        long t0 = System.currentTimeMillis();
        for (PhysicalDataSet dataSet : dataSets) {
            String dataSetCode = dataSet.getCode();
            this.dao.deleteDataSet(dataSetCode);
            this.feedPathInfoDatabase((IDatasetLocation)dataSet, dataSet.isH5Folders(), dataSet.isH5arFolders());
            this.updateTimeStampFile(this.renderTimeStampAndCode(dataSet));
        }
        operationLog.info((Object)("Path info for " + dataSets.size() + " physical data sets refreshed in " + (System.currentTimeMillis() - t0) / 1000L + " secs."));
    }

    private List<PhysicalDataSet> getPhysicalDataSets() {
        String timeStampAndCode = this.getLastTimeStampAndCode();
        SearchCriteria searchCriteria = new SearchCriteria();
        searchCriteria.setOperator(SearchCriteria.SearchOperator.MATCH_ALL_CLAUSES);
        searchCriteria.addMatchClause(SearchCriteria.MatchClause.createTimeAttributeMatch((SearchCriteria.MatchClauseTimeAttribute)SearchCriteria.MatchClauseTimeAttribute.REGISTRATION_DATE, (SearchCriteria.CompareMode)SearchCriteria.CompareMode.LESS_THAN_OR_EQUAL, (String)this.extractTimeStamp(timeStampAndCode), (String)"0"));
        if (this.dataSetType != null) {
            searchCriteria.addMatchClause(SearchCriteria.MatchClause.createAttributeMatch((SearchCriteria.MatchClauseAttribute)SearchCriteria.MatchClauseAttribute.TYPE, (String)this.dataSetType));
        }
        List<AbstractExternalData> dataSets = this.service.searchForDataSets(searchCriteria);
        Collections.sort(dataSets, REVERSE_REGISTRATION_DATE_COMPARATOR);
        ArrayList<PhysicalDataSet> result = new ArrayList<PhysicalDataSet>();
        for (AbstractExternalData dataSet : dataSets) {
            PhysicalDataSet physicalDataSet = dataSet.tryGetAsDataSet();
            if (!this.checkDataSet(physicalDataSet, timeStampAndCode)) continue;
            result.add(physicalDataSet);
            if (result.size() < this.chunkSize) continue;
            return result;
        }
        return result;
    }

    private boolean checkDataSet(PhysicalDataSet physicalDataSet, String timeStampAndCode) {
        if (physicalDataSet == null) {
            return false;
        }
        if (!physicalDataSet.getStatus().equals((Object)DataSetArchivingStatus.AVAILABLE)) {
            return false;
        }
        return this.renderTimeStampAndCode(physicalDataSet).compareTo(timeStampAndCode) < 0;
    }

    @Override
    protected Logger getOperationLog() {
        return operationLog;
    }

    private String getLastTimeStampAndCode() {
        if (!this.stateFile.exists()) {
            return this.timeStampAndCodeOfYoungestDataSet;
        }
        return FileUtilities.loadToString((File)this.stateFile).trim();
    }

    private String renderTimeStampAndCode(PhysicalDataSet dataSet) {
        return this.renderTimeStampAndCode(dataSet.getRegistrationDate(), dataSet.getDataSetCode());
    }
}

