/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.path;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

class TimeInterval {
    private static final int DAY_IN_MILLIS = 86400000;
    private long endingTimeStamp;
    private long startingTimeStamp;

    public TimeInterval(Date startingTime, Date endingTime, Date now) {
        if (endingTime == null) {
            throw new IllegalArgumentException("Unspecified ending time");
        }
        this.endingTimeStamp = TimeInterval.getForToday(now, endingTime).getTime();
        this.startingTimeStamp = TimeInterval.getForToday(now, startingTime).getTime();
        if (this.startingTimeStamp > this.endingTimeStamp) {
            if (now.getTime() > this.endingTimeStamp) {
                this.endingTimeStamp += 86400000L;
            } else {
                this.startingTimeStamp -= 86400000L;
            }
        }
    }

    boolean isInTimeInterval(Date timeStamp) {
        return this.startingTimeStamp <= timeStamp.getTime() && timeStamp.getTime() <= this.endingTimeStamp;
    }

    private static Date getForToday(Date now, Date timeOrNull) {
        Calendar calendarFromTime = TimeInterval.getCalendar();
        calendarFromTime.setTime(timeOrNull == null ? now : timeOrNull);
        Calendar calendarWithDate = TimeInterval.getCalendar();
        calendarWithDate.setTime(now);
        calendarWithDate.set(11, calendarFromTime.get(11));
        calendarWithDate.set(12, calendarFromTime.get(12));
        calendarWithDate.set(13, calendarFromTime.get(13));
        calendarWithDate.set(14, calendarFromTime.get(14));
        return calendarWithDate.getTime();
    }

    private static Calendar getCalendar() {
        return GregorianCalendar.getInstance(TimeZone.getDefault(), Locale.US);
    }
}

