/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.plugins;

import ch.systemsx.cisd.common.logging.ISimpleLogger;
import ch.systemsx.cisd.common.logging.Log4jSimpleLogger;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.logging.LogInitializer;
import ch.systemsx.cisd.common.maintenance.IMaintenanceTask;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.common.utilities.ITimeProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DeletedDataSet;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

public abstract class AbstractDataSetDeletionPostProcessingMaintenanceTask
implements IMaintenanceTask {
    protected static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, AbstractDataSetDeletionPostProcessingMaintenanceTask.class);
    protected static final String DELAY_AFTER_DELETION = "delay-after-user-deletion";
    protected static final String CHUNK_SIZE = "chunk-size";
    protected IEncapsulatedOpenBISService openBISService;
    protected long delayAfterDeletion;
    protected int chunkSize;
    ITimeProvider timeProvider;

    protected abstract Long getLastSeenEventId();

    protected abstract void updateLastSeenEventId(Long var1);

    protected abstract void execute(List<DeletedDataSet> var1);

    public AbstractDataSetDeletionPostProcessingMaintenanceTask() {
        LogInitializer.init();
    }

    protected IEncapsulatedOpenBISService getOpenBISService() {
        if (this.openBISService == null) {
            this.openBISService = ServiceProvider.getOpenBISService();
        }
        return this.openBISService;
    }

    protected ISimpleLogger getOperationLogAsSimpleLogger() {
        return new Log4jSimpleLogger(operationLog);
    }

    public void setUp(String pluginName, Properties properties) {
        int delayInMinutes = PropertyUtils.getInt((Properties)properties, (String)DELAY_AFTER_DELETION, (int)0);
        this.delayAfterDeletion = (long)delayInMinutes * 60000L;
        this.chunkSize = PropertyUtils.getInt((Properties)properties, (String)CHUNK_SIZE, (int)Integer.MAX_VALUE);
    }

    public void execute() {
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)"Synchronizing data set data deletion");
        }
        try {
            Long lastSeenEventId = this.getLastSeenEventId();
            List<DeletedDataSet> deletedDataSets = this.getOpenBISService().listDeletedDataSets(lastSeenEventId, this.computeMaxDeletionDate());
            if (deletedDataSets.size() > 0) {
                long t0 = this.getCurrentTime();
                for (int i = 0; i < deletedDataSets.size(); i += this.chunkSize) {
                    List<DeletedDataSet> chunk = deletedDataSets.subList(i, Math.min(deletedDataSets.size(), i + this.chunkSize));
                    this.execute(chunk);
                }
                this.updateLastSeenEventId(deletedDataSets, lastSeenEventId);
                if (operationLog.isInfoEnabled()) {
                    operationLog.info((Object)("Data set deletion post-processing task took " + (this.getCurrentTime() - t0 + 500L) / 1000L + " seconds."));
                }
            }
        }
        catch (Throwable t) {
            operationLog.error((Object)"Failed to process data-set deletion info :", t);
        }
    }

    protected Date computeMaxDeletionDate() {
        long now = this.getCurrentTime();
        long maxDeletionTimestamp = now - this.delayAfterDeletion;
        return new Date(maxDeletionTimestamp);
    }

    private long getCurrentTime() {
        return this.timeProvider == null ? System.currentTimeMillis() : this.timeProvider.getTimeInMilliseconds();
    }

    private void updateLastSeenEventId(List<DeletedDataSet> deleted, Long lastSeenEventIdOrNull) {
        Long maxEventId = lastSeenEventIdOrNull;
        for (DeletedDataSet dds : deleted) {
            long eventId = dds.getEventId();
            if (maxEventId != null && eventId <= maxEventId) continue;
            maxEventId = eventId;
        }
        if (lastSeenEventIdOrNull == null || maxEventId > lastSeenEventIdOrNull) {
            this.updateLastSeenEventId(maxEventId);
        }
    }
}

