/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.plugins;

import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.etlserver.plugins.AbstractDataSetDeletionPostProcessingMaintenanceTask;
import java.io.File;

public abstract class AbstractDataSetDeletionPostProcessingMaintenanceTaskWhichHandlesLastSeenEvent
extends AbstractDataSetDeletionPostProcessingMaintenanceTask {
    protected File lastSeenEventIdFile;

    @Override
    protected Long getLastSeenEventId() {
        if (this.lastSeenEventIdFile.exists()) {
            String lastSeenEventId = FileUtilities.loadToString((File)this.lastSeenEventIdFile).trim();
            try {
                return Long.valueOf(lastSeenEventId);
            }
            catch (NumberFormatException e) {
                operationLog.error((Object)("Couldn't get the last seen data set from file: " + this.lastSeenEventIdFile.getAbsolutePath() + " because the contents of that file cannot be parsed to a long value.  As there is no last seen data set available all data sets deletions will be taken into consideration."));
                return null;
            }
        }
        return null;
    }

    @Override
    protected void updateLastSeenEventId(Long eventId) {
        File parent = this.lastSeenEventIdFile.getParentFile();
        parent.mkdirs();
        File newLastSeenEventIdFile = new File(parent, this.lastSeenEventIdFile.getName() + ".new");
        FileUtilities.writeToFile((File)newLastSeenEventIdFile, (String)String.valueOf(eventId));
        newLastSeenEventIdFile.renameTo(this.lastSeenEventIdFile);
    }
}

