/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.plugins;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.maintenance.IMaintenanceTask;
import ch.systemsx.cisd.common.utilities.ICredentials;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

public abstract class AbstractMaintenanceTaskWithStateFile
implements IMaintenanceTask {
    public static final String STATE_FILE_KEY = "state-file";
    public static final String TIME_STAMP_FORMAT = "yyyy-MM-dd HH:mm:ss";
    protected File stateFile;

    protected void defineStateFile(Properties properties, File storeRoot) {
        String path = properties.getProperty(STATE_FILE_KEY);
        if (path == null) {
            this.stateFile = new File(storeRoot, this.getClass().getSimpleName() + "-state.txt");
        } else {
            this.stateFile = new File(path);
            if (this.stateFile.isDirectory()) {
                throw new ConfigurationFailureException("File '" + this.stateFile.getAbsolutePath() + "' (specified by property '" + STATE_FILE_KEY + "') is a directory.");
            }
        }
    }

    protected String renderTimeStampAndCode(Date registrationDate, String code) {
        String renderedTimeStamp = this.renderTimeStamp(registrationDate);
        return code == null ? renderedTimeStamp : renderedTimeStamp + " [" + code + "]";
    }

    protected String renderTimeStamp(Date timeStamp) {
        return new SimpleDateFormat(TIME_STAMP_FORMAT).format(timeStamp);
    }

    protected Date parseTimeStamp(String timeStampString) throws ParseException {
        return new SimpleDateFormat(TIME_STAMP_FORMAT).parse(timeStampString);
    }

    protected void updateTimeStampFile(String timeStampAndCode) {
        File newFile = new File(this.stateFile.getParentFile(), this.stateFile.getName() + "_new");
        FileUtilities.writeToFile((File)newFile, (String)timeStampAndCode);
        newFile.renameTo(this.stateFile);
    }

    protected String extractTimeStamp(String timeStampAndCode) {
        return timeStampAndCode.split("\\[")[0].trim();
    }

    protected Date getLastRegistrationDate(Date originalStartingTime) {
        if (this.stateFile.exists()) {
            String timestampAndCode = FileUtilities.loadToString((File)this.stateFile).trim();
            String timestamp = this.extractTimeStamp(timestampAndCode);
            try {
                return this.parseTimeStamp(timestamp);
            }
            catch (ParseException ex) {
                throw new EnvironmentFailureException("Invalid time stamp in file. File: " + this.stateFile.getAbsolutePath() + ", timestamp: " + timestamp);
            }
        }
        return originalStartingTime;
    }

    protected String getLastCode() {
        String timestampAndCode;
        String[] parts;
        if (this.stateFile.exists() && (parts = (timestampAndCode = FileUtilities.loadToString((File)this.stateFile).trim()).split("\\[")).length > 1) {
            if (!timestampAndCode.endsWith("]")) {
                throw new EnvironmentFailureException("Invalid code in file. File: " + this.stateFile.getAbsolutePath() + ", content: " + timestampAndCode);
            }
            return parts[1].substring(0, parts[1].length() - 1);
        }
        return null;
    }

    protected ICredentials getEtlServerCredentials() {
        return (ICredentials)ServiceProvider.getApplicationContext().getBean("reauthenticateInterceptor");
    }
}

