/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.plugins;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.collection.CollectionUtils;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.maintenance.IMaintenanceTask;
import ch.systemsx.cisd.common.properties.PropertyParametersUtil;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.common.reflection.ClassUtils;
import ch.systemsx.cisd.etlserver.IArchiveCandidateDiscoverer;
import ch.systemsx.cisd.etlserver.IAutoArchiverPolicy;
import ch.systemsx.cisd.etlserver.plugins.AgeArchiveCandidateDiscoverer;
import ch.systemsx.cisd.etlserver.plugins.DummyAutoArchiverPolicy;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ArchiverDataSetCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Code;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

public class AutoArchiverTask
implements IMaintenanceTask {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, AutoArchiverTask.class);
    private static final String POLICY_SECTION_NAME = "policy";
    private static final String DISCOVERY_SECTION_NAME = "archive-candidate-discoverer";
    private static final String CLASS_PROPERTY_NAME = "class";
    private static final String DATA_SET_TYPE_PROPERTY_NAME = "data-set-type";
    private static final String OLDER_THAN_PROPERTY_NAME = "older-than";
    private static final String REMOVE_DATASETS_FROM_STORE = "remove-datasets-from-store";
    private static final int DEFAULT_OLDER_THAN = 30;
    private IEncapsulatedOpenBISService openBISService;
    private IAutoArchiverPolicy policy;
    private IArchiveCandidateDiscoverer archiveCandidateDiscoverer;
    private ArchiverDataSetCriteria criteria;
    private boolean removeFromDataStore;

    public void execute() {
        List<AbstractExternalData> candidates = this.archiveCandidateDiscoverer.findDatasetsForArchiving(this.openBISService, this.criteria);
        if (candidates.isEmpty()) {
            operationLog.info((Object)"nothing to archive");
            return;
        }
        operationLog.info((Object)("apply policy to " + candidates.size() + " candidates for archiving."));
        List<AbstractExternalData> dataSets = this.policy.filter(candidates);
        if (dataSets.isEmpty()) {
            operationLog.info((Object)"nothing to archive");
        } else {
            operationLog.info((Object)("archiving: " + CollectionUtils.abbreviate((Collection)Code.extractCodes(dataSets), (int)10)));
            this.openBISService.archiveDataSets(Code.extractCodes(dataSets), this.removeFromDataStore, new HashMap<String, String>());
        }
    }

    public void setUp(String pluginName, Properties properties) {
        this.openBISService = ServiceProvider.getOpenBISService();
        this.criteria = this.createCriteria(properties);
        PropertyParametersUtil.SectionProperties policySectionProperties = PropertyParametersUtil.extractSingleSectionProperties((Properties)properties, (String)POLICY_SECTION_NAME, (boolean)false);
        this.policy = this.createPolicyInstance(policySectionProperties);
        PropertyParametersUtil.SectionProperties discoverySectionProperties = PropertyParametersUtil.extractSingleSectionProperties((Properties)properties, (String)DISCOVERY_SECTION_NAME, (boolean)false);
        this.archiveCandidateDiscoverer = this.createArchiveDatasetDiscoverer(discoverySectionProperties);
        this.removeFromDataStore = PropertyUtils.getBoolean((Properties)properties, (String)REMOVE_DATASETS_FROM_STORE, (boolean)false);
        operationLog.info((Object)("Plugin " + pluginName + " initialized"));
    }

    private ArchiverDataSetCriteria createCriteria(Properties properties) {
        String dataSetTypeCodeOrNull = properties.getProperty(DATA_SET_TYPE_PROPERTY_NAME);
        int olderThan = PropertyUtils.getInt((Properties)properties, (String)OLDER_THAN_PROPERTY_NAME, (int)30);
        return new ArchiverDataSetCriteria(olderThan, dataSetTypeCodeOrNull, false);
    }

    private IArchiveCandidateDiscoverer createArchiveDatasetDiscoverer(PropertyParametersUtil.SectionProperties discoverySectionProperties) {
        String className = discoverySectionProperties.getProperties().getProperty(CLASS_PROPERTY_NAME);
        if (className == null) {
            return new AgeArchiveCandidateDiscoverer(discoverySectionProperties.getProperties());
        }
        return AutoArchiverTask.createInstance(discoverySectionProperties, className, IArchiveCandidateDiscoverer.class);
    }

    private IAutoArchiverPolicy createPolicyInstance(PropertyParametersUtil.SectionProperties policySectionProperties) {
        String className = policySectionProperties.getProperties().getProperty(CLASS_PROPERTY_NAME);
        if (className == null) {
            return DummyAutoArchiverPolicy.INSTANCE;
        }
        return AutoArchiverTask.createInstance(policySectionProperties, className, IAutoArchiverPolicy.class);
    }

    private static <T> T createInstance(PropertyParametersUtil.SectionProperties constructorArguments, String className, Class<T> interfaceToCreate) {
        try {
            return (T)ClassUtils.create(interfaceToCreate, (String)className, (Object[])new Object[]{constructorArguments.getProperties()});
        }
        catch (ConfigurationFailureException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConfigurationFailureException("Cannot find the class '" + className + "'", (Throwable)CheckedExceptionTunnel.unwrapIfNecessary((Exception)ex));
        }
    }
}

