/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.plugins;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.fasta.FastaUtilities;
import ch.systemsx.cisd.common.fasta.SequenceType;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.maintenance.IMaintenanceTask;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.common.string.Template;
import ch.systemsx.cisd.etlserver.plugins.FastaFileBuilderForDataSetFiles;
import ch.systemsx.cisd.etlserver.plugins.GenericFastaFileBuilder;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import ch.systemsx.cisd.openbis.dss.generic.shared.IConfigProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.IHierarchicalContentProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.BlastUtils;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SearchCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithProperties;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.CodeWithRegistrationAndModificationDate;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DeletedDataSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TrackingDataSetCriteria;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class BlastDatabaseCreationMaintenanceTask
implements IMaintenanceTask {
    static final String DATASET_TYPES_PROPERTY = "dataset-types";
    static final String BLAST_TEMP_FOLDER_PROPERTY = "blast-temp-folder";
    static final String LAST_SEEN_DATA_SET_FILE_PROPERTY = "last-seen-data-set-file";
    static final String FILE_TYPES_PROPERTY = "file-types";
    static final String ENTITY_SEQUENCE_PROPERTIES_PROPERTY = "entity-sequence-properties";
    private static final String DEFAULT_LAST_SEEN_DATA_SET_FILE = "last-seen-data-set-for-BLAST-database-creation";
    private static final String DEFAULT_FILE_TYPES = ".fasta .fa .fsa .fastq";
    private static final String ID_DELIM = "+";
    private static final String DB_NAME_DELIM = "+";
    private static final Template ID_TEMPLATE = new Template("${entityKind}+${permId}+${propertyType}+${timestamp}");
    private static final String TIMESTAMP_TEMPLATE = "yyyyMMddHHmmss";
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, BlastDatabaseCreationMaintenanceTask.class);
    private File lastSeenDataSetFile;
    private List<Pattern> dataSetTypePatterns;
    private List<String> fileTypes;
    private File blastDatabasesFolder;
    private File tmpFolder;
    private String makeblastdb;
    private String makembindex;
    private List<Loader> loaders;
    protected BlastUtils blaster;

    public void setUp(String pluginName, Properties properties) {
        this.blaster = this.getBlaster(properties);
        this.dataSetTypePatterns = PropertyUtils.getPatterns((Properties)properties, (String)DATASET_TYPES_PROPERTY);
        this.fileTypes = Arrays.asList(properties.getProperty(FILE_TYPES_PROPERTY, DEFAULT_FILE_TYPES).split(" +"));
        operationLog.info((Object)("File types: " + this.fileTypes));
        this.lastSeenDataSetFile = this.getFile(properties, LAST_SEEN_DATA_SET_FILE_PROPERTY, DEFAULT_LAST_SEEN_DATA_SET_FILE);
        this.loaders = this.createLoaders(properties);
        if (this.dataSetTypePatterns.isEmpty() && this.loaders.isEmpty()) {
            throw new ConfigurationFailureException("At least one of the two properties have to be defined: dataset-types, entity-sequence-properties");
        }
        this.setUpBlastDatabasesFolder(properties);
        this.setUpBlastTempFolder(properties);
        String blastToolDirectory = this.blaster.getBLASTToolDirectory(properties);
        this.makeblastdb = blastToolDirectory + "makeblastdb";
        if (!this.blaster.available()) {
            this.makeblastdb = null;
        }
        this.makembindex = blastToolDirectory + "makembindex";
    }

    protected BlastUtils getBlaster(Properties properties) {
        return new BlastUtils(properties, this.getConfigProvider().getStoreRoot());
    }

    private List<Loader> createLoaders(Properties properties) {
        String property = properties.getProperty(ENTITY_SEQUENCE_PROPERTIES_PROPERTY);
        if (property == null) {
            return Collections.emptyList();
        }
        ArrayList<Loader> result = new ArrayList<Loader>();
        String[] definitions = property.split("[, ] *");
        for (int i = 0; i < definitions.length; ++i) {
            String definition = definitions[i];
            try {
                result.add(new Loader(definition));
                continue;
            }
            catch (Exception ex) {
                throw new ConfigurationFailureException(i + 1 + " definition (" + definition + ") in property '" + ENTITY_SEQUENCE_PROPERTIES_PROPERTY + "' is invalid: " + ex.getMessage());
            }
        }
        return result;
    }

    private void setUpBlastDatabasesFolder(Properties properties) {
        this.blastDatabasesFolder = this.blaster.getBlastDatabaseFolder(properties, this.getConfigProvider().getStoreRoot());
        operationLog.info((Object)("BLAST databases folder: " + this.blastDatabasesFolder));
        if (this.blastDatabasesFolder.exists()) {
            if (this.blastDatabasesFolder.isFile()) {
                throw new ConfigurationFailureException("BLAST databases folder '" + this.blastDatabasesFolder + "' is an existing file.");
            }
        } else if (!this.blastDatabasesFolder.mkdirs()) {
            throw new ConfigurationFailureException("Couldn't create BLAST databases folder '" + this.blastDatabasesFolder + "'.");
        }
    }

    private void setUpBlastTempFolder(Properties properties) {
        boolean success;
        String tempFolderProperty = properties.getProperty(BLAST_TEMP_FOLDER_PROPERTY);
        this.tmpFolder = tempFolderProperty == null ? new File(this.blastDatabasesFolder, "tmp") : new File(tempFolderProperty);
        if (this.tmpFolder.exists() && !(success = FileUtilities.deleteRecursively((File)this.tmpFolder))) {
            operationLog.warn((Object)("Couldn't delete temp folder '" + this.tmpFolder + "'."));
        }
        if (!this.tmpFolder.mkdirs()) {
            throw new ConfigurationFailureException("Couldn't create temp folder '" + this.tmpFolder + "'.");
        }
        operationLog.info((Object)("Temp folder '" + this.tmpFolder + "' created."));
    }

    private File getFile(Properties properties, String pathProperty, String defaultPath) {
        return this.blaster.getFile(properties, pathProperty, defaultPath, this.getConfigProvider().getStoreRoot());
    }

    public void execute() {
        if (this.makeblastdb == null) {
            return;
        }
        IEncapsulatedOpenBISService service = this.getOpenBISService();
        Map<SequenceType, VirtualDatabase> virtualDatabases = this.loadVirtualDatabases(service);
        this.createBlastDatabasesForDataSets(service, virtualDatabases);
        this.createBlastDatabasesForEntities(service, virtualDatabases);
        Collection<VirtualDatabase> values = virtualDatabases.values();
        for (VirtualDatabase virtualDatabase : values) {
            virtualDatabase.save();
        }
    }

    private void createBlastDatabasesForEntities(IEncapsulatedOpenBISService service, Map<SequenceType, VirtualDatabase> virtualDatabases) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(TIMESTAMP_TEMPLATE);
        for (Loader loader : this.loaders) {
            Map<SequenceType, Sequences> map = loader.load(service);
            for (Map.Entry<SequenceType, Sequences> entry : map.entrySet()) {
                SequenceType sequenceType = entry.getKey();
                VirtualDatabase virtualDatabase = virtualDatabases.get(sequenceType);
                Sequences sequences = entry.getValue();
                String baseName = loader.getDefinition() + "+" + dateFormat.format(sequences.getLatestModificationDate());
                if (this.databaseExist(baseName, sequenceType)) {
                    virtualDatabase.keepDatabase(baseName);
                    continue;
                }
                GenericFastaFileBuilder builder = new GenericFastaFileBuilder(this.tmpFolder, baseName);
                for (Sequence sequence : sequences.getSequences()) {
                    Template template = ID_TEMPLATE.createFreshCopy();
                    template.bind("entityKind", loader.getEntityKind());
                    template.bind("permId", sequence.getPermId());
                    template.bind("propertyType", sequence.getPropertyType());
                    template.bind("timestamp", dateFormat.format(sequence.getModificationDate()));
                    String id = template.createText();
                    builder.startEntry(GenericFastaFileBuilder.EntryType.FASTA, id, sequenceType);
                    builder.appendToSequence(sequence.getSequence());
                }
                this.createBlastDatabases(builder, virtualDatabases);
            }
        }
    }

    private boolean databaseExist(String baseName, SequenceType sequenceType) {
        String[] fileNames = this.blastDatabasesFolder.list();
        if (fileNames != null) {
            for (String fileName : fileNames) {
                if (!fileName.startsWith(BlastUtils.createDatabaseName(baseName, sequenceType))) continue;
                return true;
            }
        }
        return false;
    }

    private void createBlastDatabasesForDataSets(IEncapsulatedOpenBISService service, Map<SequenceType, VirtualDatabase> virtualDatabases) {
        if (this.dataSetTypePatterns.isEmpty()) {
            return;
        }
        IHierarchicalContentProvider contentProvider = this.getContentProvider();
        List<AbstractExternalData> dataSets = this.getDataSets(service);
        if (!dataSets.isEmpty()) {
            operationLog.info((Object)("Scan " + dataSets.size() + " data sets for creating BLAST databases."));
        }
        for (AbstractExternalData dataSet : dataSets) {
            if (dataSet.tryGetAsDataSet() != null && dataSet.isAvailable() && this.dataSetTypeMatches(dataSet)) {
                try {
                    this.createBlastDatabase(dataSet, virtualDatabases, contentProvider);
                }
                catch (Exception ex) {
                    operationLog.error((Object)("Error caused by creating BLAST database for data set " + dataSet.getCode() + ": " + ex.getMessage()), (Throwable)ex);
                }
            }
            this.updateLastSeenEventId(dataSet.getId());
        }
    }

    private boolean dataSetTypeMatches(AbstractExternalData dataSet) {
        String dataSetType = dataSet.getDataSetType().getCode();
        for (Pattern pattern : this.dataSetTypePatterns) {
            if (!pattern.matcher(dataSetType).matches()) continue;
            return true;
        }
        return false;
    }

    private Map<SequenceType, VirtualDatabase> loadVirtualDatabases(IEncapsulatedOpenBISService service) {
        EnumMap<SequenceType, VirtualDatabase> virtualDatabases = new EnumMap<SequenceType, VirtualDatabase>(SequenceType.class);
        for (SequenceType sequenceType : SequenceType.values()) {
            VirtualDatabase virtualDatabase = new VirtualDatabase(this.blastDatabasesFolder, sequenceType);
            virtualDatabases.put(sequenceType, virtualDatabase);
        }
        for (DeletedDataSet deletedDataSet : service.listDeletedDataSets(null, null)) {
            for (VirtualDatabase virtualDatabase : virtualDatabases.values()) {
                virtualDatabase.deleteDatabase(deletedDataSet.getCode());
            }
        }
        return virtualDatabases;
    }

    private void createBlastDatabase(AbstractExternalData dataSet, Map<SequenceType, VirtualDatabase> virtualDatabases, IHierarchicalContentProvider contentProvider) {
        String dataSetCode = dataSet.getCode();
        FastaFileBuilderForDataSetFiles builder = new FastaFileBuilderForDataSetFiles(this.tmpFolder, dataSetCode);
        IHierarchicalContent content = contentProvider.asContent(dataSet);
        IHierarchicalContentNode rootNode = content.getRootNode();
        this.handle(rootNode, builder);
        this.createBlastDatabases(builder, virtualDatabases);
    }

    private void createBlastDatabases(GenericFastaFileBuilder builder, Map<SequenceType, VirtualDatabase> virtualDatabases) {
        SequenceType[] values;
        builder.finish();
        String baseName = builder.getBaseName();
        for (SequenceType sequenceType : values = SequenceType.values()) {
            File fastaFile = builder.getTemporaryFastaFileOrNull(sequenceType);
            if (fastaFile == null) continue;
            String fastaFilePath = fastaFile.getAbsolutePath();
            String databaseName = FilenameUtils.removeExtension((String)fastaFile.getName());
            String databaseFile = new File(this.blastDatabasesFolder, databaseName).getAbsolutePath();
            String dbtype = sequenceType.toString().toLowerCase();
            boolean success = this.blaster.process(this.makeblastdb, "-in", fastaFilePath, "-dbtype", dbtype, "-title", databaseName, "-out", databaseFile);
            if (!success) {
                operationLog.error((Object)("Creation of BLAST database '" + databaseName + "' failed. Temporary fasta file: " + fastaFile));
                break;
            }
            File databaseSeqFile = new File(databaseFile + ".nsq");
            if (databaseSeqFile.exists() && databaseSeqFile.length() > 1000000L) {
                this.blaster.process(this.makembindex, "-iformat", "blastdb", "-input", databaseFile, "-old_style_index", "false");
            }
            VirtualDatabase virtualDatabase = virtualDatabases.get(sequenceType);
            virtualDatabase.addDatabase(baseName);
        }
        builder.cleanUp();
    }

    private void handle(IHierarchicalContentNode node, FastaFileBuilderForDataSetFiles builder) {
        if (node.isDirectory()) {
            for (IHierarchicalContentNode childNode : node.getChildNodes()) {
                this.handle(childNode, builder);
            }
        } else {
            String nodeName = node.getName();
            for (String fileType : this.fileTypes) {
                if (!nodeName.endsWith(fileType)) continue;
                this.appendTo(builder, node);
                break;
            }
        }
    }

    private void appendTo(FastaFileBuilderForDataSetFiles builder, IHierarchicalContentNode node) {
        InputStream inputStream = node.getInputStream();
        BufferedReader bufferedReader = null;
        String relativePath = node.getRelativePath();
        builder.setFilePath(relativePath);
        try {
            String line;
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while ((line = bufferedReader.readLine()) != null) {
                builder.handle(line);
            }
        }
        catch (IOException e) {
            try {
                throw new EnvironmentFailureException("Error while reading data from '" + relativePath + "': " + e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bufferedReader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)bufferedReader);
    }

    private List<AbstractExternalData> getDataSets(IEncapsulatedOpenBISService service) {
        Long lastSeenEventId = this.getLastSeenEventId();
        if (lastSeenEventId == null) {
            lastSeenEventId = 0L;
        }
        TrackingDataSetCriteria criteria = new TrackingDataSetCriteria(lastSeenEventId.longValue());
        List<AbstractExternalData> dataSets = service.listNewerDataSets(criteria);
        Collections.sort(dataSets, new Comparator<AbstractExternalData>(){

            @Override
            public int compare(AbstractExternalData d0, AbstractExternalData d1) {
                long id1;
                long id0 = d0.getId();
                return id0 > (id1 = d1.getId().longValue()) ? 1 : (id0 < id1 ? -1 : 0);
            }
        });
        return dataSets;
    }

    private Long getLastSeenEventId() {
        Long result;
        block3: {
            result = null;
            if (this.lastSeenDataSetFile.exists()) {
                try {
                    result = Long.parseLong(FileUtilities.loadToString((File)this.lastSeenDataSetFile).trim());
                }
                catch (Exception ex) {
                    if (!operationLog.isDebugEnabled()) break block3;
                    operationLog.debug((Object)("Cannot load last seen event id from file :" + this.lastSeenDataSetFile), (Throwable)ex);
                }
            }
        }
        return result;
    }

    private void updateLastSeenEventId(Long eventId) {
        FileUtilities.writeToFile((File)this.lastSeenDataSetFile, (String)(String.valueOf(eventId) + "\n"));
    }

    IConfigProvider getConfigProvider() {
        return ServiceProvider.getConfigProvider();
    }

    IEncapsulatedOpenBISService getOpenBISService() {
        return ServiceProvider.getOpenBISService();
    }

    IHierarchicalContentProvider getContentProvider() {
        return ServiceProvider.getHierarchicalContentProvider();
    }

    private static String normalize(String sequence) {
        if (sequence == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < sequence.length(); ++i) {
            char c = sequence.charAt(i);
            if (Character.isWhitespace(c)) continue;
            builder.append(Character.toUpperCase(c));
        }
        return builder.toString();
    }

    private static class VirtualDatabase {
        private final File databaseFolder;
        private final String dbtype;
        private final String postfix;
        private final File databaseFile;
        private final Set<String> databasesToBeDeleted = new TreeSet<String>();
        private final Set<String> databasesToBeAdded = new TreeSet<String>();
        private final String virtualDatabaseFileType;

        VirtualDatabase(File databaseFolder, SequenceType sequenceType) {
            List lines;
            this.databaseFolder = databaseFolder;
            this.dbtype = sequenceType.toString().toLowerCase();
            this.postfix = BlastUtils.createDatabaseName("", sequenceType);
            this.virtualDatabaseFileType = sequenceType == SequenceType.NUCL ? ".nal" : ".pal";
            this.databaseFile = new File(databaseFolder, "all-" + this.dbtype + this.virtualDatabaseFileType);
            if (this.databaseFile.isFile() && (lines = FileUtilities.loadToStringList((File)this.databaseFile)).size() == 2) {
                StringTokenizer tokenizer = new StringTokenizer((String)lines.get(1));
                tokenizer.nextToken();
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    if (!token.endsWith(this.postfix)) continue;
                    String name = token.substring(0, token.length() - this.postfix.length());
                    if (this.isEntityPropertyDatabase(name)) {
                        this.databasesToBeDeleted.add(name);
                        continue;
                    }
                    this.databasesToBeAdded.add(name);
                }
            }
        }

        void keepDatabase(String baseName) {
            this.databasesToBeAdded.add(baseName);
            this.databasesToBeDeleted.remove(baseName);
        }

        void deleteDatabase(String baseName) {
            this.databasesToBeDeleted.add(baseName);
            this.databasesToBeAdded.remove(baseName);
        }

        void addDatabase(String name) {
            this.databasesToBeAdded.add(name);
        }

        private boolean isEntityPropertyDatabase(String name) {
            return name.contains("+");
        }

        void save() {
            File allDatabaseFile = new File(this.databaseFolder, "all-" + this.dbtype + this.virtualDatabaseFileType);
            File newAllDatabaseFile = new File(this.databaseFolder, "all-" + this.dbtype + this.virtualDatabaseFileType + ".new");
            if (this.databasesToBeAdded.isEmpty()) {
                if (allDatabaseFile.exists()) {
                    if (FileUtilities.delete((File)allDatabaseFile)) {
                        operationLog.info((Object)("Virtual BLAST database file " + allDatabaseFile + " deleted because it was empty."));
                    } else {
                        operationLog.warn((Object)("File deletion failed: " + allDatabaseFile));
                    }
                }
            } else {
                StringBuilder builder = new StringBuilder();
                builder.append("TITLE all-" + this.dbtype + "\nDBLIST");
                for (String database : this.databasesToBeAdded) {
                    builder.append(' ').append(database).append(this.postfix);
                }
                FileUtilities.writeToFile((File)newAllDatabaseFile, (String)builder.toString());
                newAllDatabaseFile.renameTo(allDatabaseFile);
            }
            this.deleteDatabasesToBeDeleted();
        }

        private void deleteDatabasesToBeDeleted() {
            for (String database : this.databasesToBeDeleted) {
                final String databaseName = database + this.postfix;
                File[] files = this.databaseFolder.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        return file.getName().startsWith(databaseName);
                    }
                });
                if (files == null || files.length <= 0) continue;
                boolean success = true;
                for (File file : files) {
                    if (FileUtilities.delete((File)file)) continue;
                    operationLog.warn((Object)("File deletion failed: " + file));
                    success = false;
                }
                if (!success) continue;
                operationLog.info((Object)("BLAST database " + databaseName + " successfully deleted."));
            }
        }
    }

    private static enum EntityLoader {
        DATA_SET{

            @Override
            List<? extends IEntityInformationHolderWithProperties> listEntities(IEncapsulatedOpenBISService service, SearchCriteria searchCriteria) {
                return service.searchForDataSets(searchCriteria);
            }
        }
        ,
        EXPERIMENT{

            @Override
            List<? extends IEntityInformationHolderWithProperties> listEntities(IEncapsulatedOpenBISService service, SearchCriteria searchCriteria) {
                return service.searchForExperiments(searchCriteria);
            }
        }
        ,
        SAMPLE{

            @Override
            List<? extends IEntityInformationHolderWithProperties> listEntities(IEncapsulatedOpenBISService service, SearchCriteria searchCriteria) {
                return service.searchForSamples(searchCriteria);
            }
        };


        abstract List<? extends IEntityInformationHolderWithProperties> listEntities(IEncapsulatedOpenBISService var1, SearchCriteria var2);
    }

    private static final class Sequence {
        private final String permId;
        private final Date modificationDate;
        private final String propertyType;
        private final String sequence;
        private final SequenceType sequenceType;

        Sequence(IEntityInformationHolderWithProperties entity, String propertyType, SequenceType sequenceType, String sequence) {
            this.propertyType = propertyType;
            this.sequenceType = sequenceType;
            this.sequence = sequence;
            this.permId = entity.getPermId();
            Date date = null;
            if (entity instanceof CodeWithRegistrationAndModificationDate) {
                date = ((CodeWithRegistrationAndModificationDate)entity).getModificationDate();
            }
            this.modificationDate = date == null ? new Date() : date;
        }

        String getPermId() {
            return this.permId;
        }

        Date getModificationDate() {
            return this.modificationDate;
        }

        String getPropertyType() {
            return this.propertyType;
        }

        String getSequence() {
            return this.sequence;
        }

        SequenceType getSequenceType() {
            return this.sequenceType;
        }
    }

    private static final class Sequences {
        private final List<Sequence> sequences = new ArrayList<Sequence>();
        private Date latestModificationDate = new Date(0L);

        private Sequences() {
        }

        void addSequence(Sequence sequence) {
            this.sequences.add(sequence);
            if (this.latestModificationDate.compareTo(sequence.getModificationDate()) < 0) {
                this.latestModificationDate = sequence.getModificationDate();
            }
        }

        List<Sequence> getSequences() {
            return this.sequences;
        }

        Date getLatestModificationDate() {
            return this.latestModificationDate;
        }
    }

    private static final class Loader {
        private final String definition;
        private final String entityKind;
        private final EntityLoader entityLoader;
        private final String entityType;
        private final String propertyType;

        Loader(String definition) {
            this.definition = definition;
            String[] items = StringUtils.splitByWholeSeparator((String)definition, (String)"+");
            if (items.length != 3) {
                throw new IllegalArgumentException("Definition not in form <entity kind>+<entity type>+<property type>");
            }
            this.entityKind = items[0];
            this.entityLoader = EntityLoader.valueOf(this.entityKind);
            this.entityType = items[1];
            this.propertyType = items[2];
        }

        String getDefinition() {
            return this.definition;
        }

        String getEntityKind() {
            return this.entityKind;
        }

        Map<SequenceType, Sequences> load(IEncapsulatedOpenBISService service) {
            EnumMap<SequenceType, Sequences> map = new EnumMap<SequenceType, Sequences>(SequenceType.class);
            SearchCriteria searchCriteria = new SearchCriteria();
            searchCriteria.addMatchClause(SearchCriteria.MatchClause.createAttributeMatch((SearchCriteria.MatchClauseAttribute)SearchCriteria.MatchClauseAttribute.TYPE, (String)this.entityType));
            block0: for (IEntityInformationHolderWithProperties iEntityInformationHolderWithProperties : this.entityLoader.listEntities(service, searchCriteria)) {
                List properties = iEntityInformationHolderWithProperties.getProperties();
                for (IEntityProperty property : properties) {
                    SequenceType sequenceType;
                    if (!property.getPropertyType().getCode().equals(this.propertyType)) continue;
                    String sequence = BlastDatabaseCreationMaintenanceTask.normalize(property.tryGetAsString());
                    if (sequence == null || (sequenceType = FastaUtilities.determineSequenceTypeOrNull((String)sequence)) == null) continue block0;
                    Sequence seq = new Sequence(iEntityInformationHolderWithProperties, this.propertyType, sequenceType, sequence);
                    Sequences sequences = (Sequences)map.get(seq.getSequenceType());
                    if (sequences == null) {
                        sequences = new Sequences();
                        map.put(seq.getSequenceType(), sequences);
                    }
                    sequences.addSequence(seq);
                    continue block0;
                }
            }
            return map;
        }
    }
}

