/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.plugins;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.mail.EMailAddress;
import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.common.maintenance.IMaintenanceTask;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.openbis.dss.generic.server.DataStoreServer;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.MultiDataSetArchiver;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.dataaccess.MultiDataSetArchiverDataSourceUtil;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.generic.shared.dto.SimpleDataSetInformationDTO;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.springframework.transaction.annotation.Transactional;

public class DataSetArchiverOrphanFinderTask
implements IMaintenanceTask {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, DataSetArchiverOrphanFinderTask.class);
    public static final String EMAIL_ADDRESSES_KEY = "email-addresses";
    private static final String SEPARATOR = ",";
    private List<EMailAddress> emailAddresses;
    private IMailClient mailClient;
    private boolean isMultiDatasetArchiver;

    public DataSetArchiverOrphanFinderTask() {
        this(ServiceProvider.getDataStoreService().createEMailClient(), ServiceProvider.getDataStoreService().getArchiverPlugin() instanceof MultiDataSetArchiver);
    }

    DataSetArchiverOrphanFinderTask(IMailClient mailClient, boolean isMultiDatasetArchiver) {
        this.mailClient = mailClient;
        this.isMultiDatasetArchiver = isMultiDatasetArchiver;
    }

    public void setUp(String pluginName, Properties properties) {
        operationLog.info((Object)("Task " + pluginName + " initialized."));
        this.emailAddresses = this.getEMailAddresses(properties);
    }

    @Transactional
    public void execute() {
        operationLog.info((Object)(DataSetArchiverOrphanFinderTask.class.getSimpleName() + " Started"));
        operationLog.info((Object)"1. Directories, obtain archiver directory.");
        String destination = null;
        destination = this.isMultiDatasetArchiver ? DataStoreServer.getConfigParameter("archiver.final-destination", null) : DataStoreServer.getConfigParameter("archiver.destination", null);
        if (destination == null) {
            operationLog.info((Object)"No destination directory found, this task can't execute.");
            return;
        }
        operationLog.info((Object)"2.1 Database, obtain a list of the multi dataset containers on the database.");
        List<String> multiDataSetContrainers = null;
        if (this.isMultiDatasetArchiver) {
            multiDataSetContrainers = MultiDataSetArchiverDataSourceUtil.getContainerList();
        }
        HashSet<String> multiDatasetsContainersOnDB = new HashSet<String>();
        if (multiDataSetContrainers != null) {
            for (String container : multiDataSetContrainers) {
                multiDatasetsContainersOnDB.add(container.toLowerCase());
            }
        }
        operationLog.info((Object)"2.2 Database, obtain a list of the archived datasets on the database.");
        IEncapsulatedOpenBISService service = ServiceProvider.getOpenBISService();
        List<SimpleDataSetInformationDTO> presentDTOs = service.listPhysicalDataSetsByArchivingStatus(null, Boolean.TRUE);
        HashSet<String> presentInArchiveOnDB = new HashSet<String>();
        if (presentDTOs != null) {
            for (SimpleDataSetInformationDTO presentDTO : presentDTOs) {
                presentInArchiveOnDB.add(presentDTO.getDataSetCode().toLowerCase());
            }
        }
        File[] filesOnDisk = new File(destination).listFiles();
        operationLog.info((Object)("3. Verify if the " + filesOnDisk.length + " files on destination are on multi dataset archiver containers or a normal archived dataset."));
        HashSet<String> presentInArchiveFS = new HashSet<String>();
        ArrayList<File> onFSandNotDB = new ArrayList<File>();
        for (File file : filesOnDisk) {
            String fileName = file.getName().toLowerCase();
            presentInArchiveFS.add(fileName);
            if (multiDatasetsContainersOnDB.contains(fileName)) {
                operationLog.debug((Object)("Found multi dataset archiver container: " + file.getName()));
                continue;
            }
            String string = file.getName().substring(0, file.getName().length() - 4);
            if ((fileName.endsWith(".tar") || fileName.endsWith(".zip")) && presentInArchiveOnDB.contains(string)) {
                operationLog.debug((Object)("Found archived dataset: " + file.getName()));
                continue;
            }
            onFSandNotDB.add(file);
            operationLog.debug((Object)("Not found on DB for FS: " + file.getName()));
        }
        operationLog.info((Object)("4. Verify if the " + multiDatasetsContainersOnDB.size() + " containers of the multi data set mapping database are on the file system."));
        ArrayList<String> multiOnDBandNotFS = new ArrayList<String>();
        for (String multiDatasetsContainerOnDB : multiDatasetsContainersOnDB) {
            if (presentInArchiveFS.contains(multiDatasetsContainerOnDB)) continue;
            operationLog.debug((Object)("Multi - Not found in FS for DB: " + multiDatasetsContainerOnDB));
            multiOnDBandNotFS.add(multiDatasetsContainerOnDB);
        }
        ArrayList<String> singleOnDBandNotFS = new ArrayList<String>();
        for (String presentOnDB : presentInArchiveOnDB) {
            String fileNameTar = presentOnDB + ".tar";
            String string = presentOnDB + ".zip";
            if (presentInArchiveFS.contains(fileNameTar) || presentInArchiveFS.contains(string) || this.isMultiDatasetArchiver && (!this.isMultiDatasetArchiver || MultiDataSetArchiverDataSourceUtil.isDataSetInContainer(presentOnDB.toUpperCase()).booleanValue())) continue;
            operationLog.debug((Object)("Single - Not found in FS for DB: " + presentOnDB));
            singleOnDBandNotFS.add(presentOnDB);
        }
        if (!(onFSandNotDB.isEmpty() && multiOnDBandNotFS.isEmpty() && singleOnDBandNotFS.isEmpty())) {
            operationLog.info((Object)"5. Send email with not found files.");
            String subject = "openBIS Data Set Archiv Orphan Finder report";
            String content = "";
            Collections.sort(onFSandNotDB);
            for (File file : onFSandNotDB) {
                content = content + "Found in the archive but not in the database: " + file.getName() + "\n";
            }
            Collections.sort(multiOnDBandNotFS);
            for (String string : multiOnDBandNotFS) {
                content = content + "Found in the database but not in the multi data set archive: " + string + "\n";
            }
            Collections.sort(singleOnDBandNotFS);
            for (String string : singleOnDBandNotFS) {
                content = content + "Found in the database but not in the archive: " + string + "\n";
            }
            for (EMailAddress eMailAddress : this.emailAddresses) {
                this.mailClient.sendEmailMessage(subject, content, null, null, new EMailAddress[]{eMailAddress});
                operationLog.info((Object)("Mail sent to " + eMailAddress.tryGetEmailAddress()));
            }
        }
        operationLog.info((Object)(DataSetArchiverOrphanFinderTask.class.getSimpleName() + " Finished"));
    }

    private List<EMailAddress> getEMailAddresses(Properties properties) {
        String[] tokens = PropertyUtils.getMandatoryProperty((Properties)properties, (String)EMAIL_ADDRESSES_KEY).split(SEPARATOR);
        ArrayList<EMailAddress> addresses = new ArrayList<EMailAddress>();
        for (String token : tokens) {
            addresses.add(new EMailAddress(token.trim()));
        }
        return addresses;
    }
}

