/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.plugins;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.filesystem.HostAwareFile;
import ch.systemsx.cisd.common.filesystem.IFreeSpaceProvider;
import ch.systemsx.cisd.common.filesystem.SimpleFreeSpaceProvider;
import ch.systemsx.cisd.common.logging.ISimpleLogger;
import ch.systemsx.cisd.common.logging.Log4jSimpleLogger;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.maintenance.IDataStoreLockingMaintenanceTask;
import ch.systemsx.cisd.common.properties.ExtendedProperties;
import ch.systemsx.cisd.common.properties.PropertyParametersUtil;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.common.reflection.ClassUtils;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetArchivingStatus;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PhysicalDataSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifierFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class ExperimentBasedArchivingTask
implements IDataStoreLockingMaintenanceTask {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, ExperimentBasedArchivingTask.class);
    private static final Logger notificationLog = LogFactory.getLogger((LogCategory)LogCategory.NOTIFY, ExperimentBasedArchivingTask.class);
    static final String MINIMUM_FREE_SPACE_KEY = "minimum-free-space-in-MB";
    static final String EXCLUDED_DATA_SET_TYPES_KEY = "excluded-data-set-types";
    static final String MONITORED_DIR = "monitored-dir";
    static final String FREE_SPACE_PROVIDER_PREFIX = "free-space-provider.";
    static final String DATA_SET_SIZE_PREFIX = "estimated-data-set-size-in-KB.";
    static final String DEFAULT_DATA_SET_TYPE = "DEFAULT";
    private static final EnumSet<DataSetArchivingStatus> ARCHIVE_STATES = EnumSet.of(DataSetArchivingStatus.ARCHIVE_PENDING, DataSetArchivingStatus.ARCHIVED);
    private final IEncapsulatedOpenBISService service;
    private IFreeSpaceProvider freeSpaceProvider;
    private File monitoredDirectory;
    private long minimumFreeSpace;
    private Set<String> excludedDataSetTypes;
    private Map<String, Long> estimatedDataSetSizes;

    public ExperimentBasedArchivingTask() {
        this(ServiceProvider.getOpenBISService());
    }

    ExperimentBasedArchivingTask(IEncapsulatedOpenBISService service) {
        this.service = service;
    }

    public boolean requiresDataStoreLock() {
        return true;
    }

    public void setUp(String pluginName, Properties properties) {
        this.freeSpaceProvider = this.setUpFreeSpaceProvider(properties);
        this.monitoredDirectory = this.setUpMonitoredDirectory(properties);
        this.minimumFreeSpace = 0x100000L * PropertyUtils.getLong((Properties)properties, (String)MINIMUM_FREE_SPACE_KEY, (long)1024L);
        this.excludedDataSetTypes = new HashSet<String>(Arrays.asList(PropertyParametersUtil.parseItemisedProperty((String)properties.getProperty(EXCLUDED_DATA_SET_TYPES_KEY, ""), (String)EXCLUDED_DATA_SET_TYPES_KEY)));
        this.estimatedDataSetSizes = this.setUpEstimatedDataSetSizes(properties);
    }

    private File setUpMonitoredDirectory(Properties properties) {
        File monitoredDir;
        String monitoredDirPath = PropertyUtils.getProperty((Properties)properties, (String)MONITORED_DIR);
        File file = monitoredDir = monitoredDirPath == null ? null : new File(monitoredDirPath);
        if (monitoredDir == null || !monitoredDir.isDirectory()) {
            throw new ConfigurationFailureException("Directory '" + monitoredDirPath + "' doesn't exists or isn't a directory.");
        }
        return monitoredDir;
    }

    private IFreeSpaceProvider setUpFreeSpaceProvider(Properties properties) {
        ExtendedProperties providerProps = ExtendedProperties.getSubset((Properties)properties, (String)FREE_SPACE_PROVIDER_PREFIX, (boolean)true);
        String freeSpaceProviderClassName = PropertyUtils.getProperty((Properties)providerProps, (String)"class", (String)SimpleFreeSpaceProvider.class.getName());
        Class<?> clazz = null;
        try {
            clazz = Class.forName(freeSpaceProviderClassName);
        }
        catch (ClassNotFoundException cnfe) {
            throw ConfigurationFailureException.fromTemplate((String)"Cannot find configured free space provider class '%s'", (Object[])new Object[]{freeSpaceProviderClassName});
        }
        if (ClassUtils.hasConstructor(clazz, (Object[])new Object[]{properties})) {
            return (IFreeSpaceProvider)ClassUtils.create(IFreeSpaceProvider.class, clazz, (Object[])new Object[]{providerProps});
        }
        return (IFreeSpaceProvider)ClassUtils.create(IFreeSpaceProvider.class, clazz, (Object[])new Object[0]);
    }

    private Map<String, Long> setUpEstimatedDataSetSizes(Properties properties) {
        Log4jSimpleLogger log = new Log4jSimpleLogger(operationLog);
        ExtendedProperties dataSetSizeProps = ExtendedProperties.getSubset((Properties)properties, (String)DATA_SET_SIZE_PREFIX, (boolean)true);
        HashMap<String, Long> result = new HashMap<String, Long>();
        for (Object key : dataSetSizeProps.keySet()) {
            String dataSetType = ((String)key).toUpperCase();
            long estimatedSizeInBytes = 1024L * PropertyUtils.getPosLong((Properties)dataSetSizeProps, (String)dataSetType, (long)0L, (ISimpleLogger)log);
            if (estimatedSizeInBytes <= 0L) continue;
            result.put(dataSetType, estimatedSizeInBytes);
        }
        if (result.get(DEFAULT_DATA_SET_TYPE) == null) {
            operationLog.warn((Object)"No default estimated data set size specified.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        int numberOfArchivePending = this.service.listPhysicalDataSetsByArchivingStatus(DataSetArchivingStatus.ARCHIVE_PENDING, null).size();
        if (numberOfArchivePending > 0) {
            operationLog.info((Object)("Does nothing because there are " + numberOfArchivePending + " data sets in status " + DataSetArchivingStatus.ARCHIVE_PENDING + "."));
            return;
        }
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)"Check free diskspace.");
        }
        long freeSpace = this.getFreeSpace();
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)String.format("Free space: %s, minimal free space required: %s", FileUtils.byteCountToDisplaySize((long)freeSpace), FileUtils.byteCountToDisplaySize((long)this.minimumFreeSpace)));
        }
        if (freeSpace >= this.minimumFreeSpace) {
            return;
        }
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)"Free space is below threshold, searching for datasets to archive.");
        }
        ArrayList<ExperimentDataSetsInfo> infos = new ArrayList<ExperimentDataSetsInfo>();
        for (Project project : this.service.listProjects()) {
            ProjectIdentifier projectIdentifier = new ProjectIdentifierFactory(project.getIdentifier()).createIdentifier();
            for (Experiment experiment : this.service.listExperiments(projectIdentifier)) {
                List<AbstractExternalData> dataSets = this.service.listDataSetsByExperimentID(experiment.getId());
                infos.add(new ExperimentDataSetsInfo(experiment.getIdentifier(), dataSets));
            }
        }
        Collections.sort(infos, new ExperimentDataSetsInfoComparator());
        NotificationMessageBuilder notificationMessageBuilder = new NotificationMessageBuilder();
        try {
            for (int i = 0; i < infos.size() && freeSpace < this.minimumFreeSpace; ++i) {
                ExperimentDataSetsInfo info = (ExperimentDataSetsInfo)infos.get(i);
                long estimatedSpaceFreed = info.estimateSize(notificationMessageBuilder);
                if (!this.archive(info, notificationMessageBuilder)) continue;
                freeSpace += estimatedSpaceFreed;
            }
        }
        finally {
            if (notificationMessageBuilder.hasMissingEstimates()) {
                notificationLog.error((Object)notificationMessageBuilder.renderMissingEstimates());
            }
            if (notificationMessageBuilder.hasMessages()) {
                notificationLog.info((Object)notificationMessageBuilder.renderMessages());
            }
        }
    }

    private long getFreeSpace() {
        try {
            return 1024L * this.freeSpaceProvider.freeSpaceKb(new HostAwareFile(this.monitoredDirectory));
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
    }

    private boolean archive(ExperimentDataSetsInfo info, NotificationMessageBuilder builder) {
        List<PhysicalDataSet> dataSets = info.getDataSetsToBeArchived();
        if (dataSets.isEmpty()) {
            return false;
        }
        ArrayList<String> dataSetCodes = new ArrayList<String>();
        for (PhysicalDataSet dataSet : dataSets) {
            dataSetCodes.add(dataSet.getCode());
        }
        String message = "#" + dataSetCodes.size() + " data sets of experiment " + info.getExperimentIdentifier() + ": " + dataSetCodes;
        operationLog.info((Object)("Starting archiving " + message));
        this.service.archiveDataSets(dataSetCodes, true, new HashMap<String, String>());
        builder.addArchivingMessage(message);
        return true;
    }

    private final class ExperimentDataSetsInfoComparator
    implements Comparator<ExperimentDataSetsInfo> {
        private ExperimentDataSetsInfoComparator() {
        }

        @Override
        public int compare(ExperimentDataSetsInfo i1, ExperimentDataSetsInfo i2) {
            Date d1 = i1.getLastModificationDate();
            Date d2 = i2.getLastModificationDate();
            if (d1 != null && d2 != null) {
                return d1.compareTo(d2);
            }
            if (d1 == null && d2 != null) {
                return 1;
            }
            if (d1 != null && d2 == null) {
                return -1;
            }
            return 0;
        }
    }

    private final class ExperimentDataSetsInfo {
        private Date lastModificationDate;
        private List<PhysicalDataSet> dataSetsToBeArchived = new ArrayList<PhysicalDataSet>();
        private final String experimentIdentifier;

        ExperimentDataSetsInfo(String experimentIdentifier, List<AbstractExternalData> dataSets) {
            this.experimentIdentifier = experimentIdentifier;
            for (AbstractExternalData dataSet : dataSets) {
                DataSetArchivingStatus status;
                if (!(dataSet instanceof PhysicalDataSet)) continue;
                PhysicalDataSet realDataSet = (PhysicalDataSet)dataSet;
                if (ExperimentBasedArchivingTask.this.excludedDataSetTypes.contains(realDataSet.getDataSetType().getCode()) || DataSetArchivingStatus.LOCKED.equals((Object)(status = realDataSet.getStatus())) || ARCHIVE_STATES.contains(status)) continue;
                this.dataSetsToBeArchived.add(realDataSet);
                Date modificationDate = dataSet.getModificationDate();
                if (modificationDate == null) {
                    modificationDate = dataSet.getRegistrationDate();
                }
                if (this.lastModificationDate != null && !this.lastModificationDate.before(modificationDate)) continue;
                this.lastModificationDate = modificationDate;
            }
        }

        public long estimateSize(NotificationMessageBuilder builder) {
            long sum = 0L;
            for (PhysicalDataSet dataSetToBeArchived : this.getDataSetsToBeArchived()) {
                sum += this.getOrEstimateSize(dataSetToBeArchived, builder);
            }
            return sum;
        }

        private long getOrEstimateSize(PhysicalDataSet dataSet, NotificationMessageBuilder builder) {
            Long size = dataSet.getSize();
            if (size != null) {
                return size;
            }
            String dataSetType = dataSet.getDataSetType().getCode().toUpperCase();
            Long estimatedDataSetSize = (Long)ExperimentBasedArchivingTask.this.estimatedDataSetSizes.get(dataSetType);
            if (estimatedDataSetSize == null) {
                estimatedDataSetSize = (Long)ExperimentBasedArchivingTask.this.estimatedDataSetSizes.get(ExperimentBasedArchivingTask.DEFAULT_DATA_SET_TYPE);
            }
            if (estimatedDataSetSize == null) {
                builder.addMissingEstimatesFor(dataSetType);
                estimatedDataSetSize = 0L;
            }
            return estimatedDataSetSize;
        }

        public String getExperimentIdentifier() {
            return this.experimentIdentifier;
        }

        public Date getLastModificationDate() {
            return this.lastModificationDate;
        }

        public List<PhysicalDataSet> getDataSetsToBeArchived() {
            return this.dataSetsToBeArchived;
        }
    }

    private static final class NotificationMessageBuilder {
        private final StringBuilder archivingMessages = new StringBuilder();
        private final Set<String> missingEstimates = new TreeSet<String>();

        private NotificationMessageBuilder() {
        }

        void addArchivingMessage(String message) {
            this.archivingMessages.append('\n').append("Archived " + message);
        }

        void addMissingEstimatesFor(String dataSetType) {
            this.missingEstimates.add(dataSetType);
        }

        public boolean hasMessages() {
            return this.archivingMessages.length() > 0;
        }

        boolean hasMissingEstimates() {
            return !this.missingEstimates.isEmpty();
        }

        String renderMissingEstimates() {
            StringBuilder builder = new StringBuilder();
            builder.append("Failed to estimate the avarage size for the following data set types: ");
            builder.append(this.missingEstimates).append("\n");
            builder.append("Please, configure the maintenance task with a property '");
            builder.append(ExperimentBasedArchivingTask.DATA_SET_SIZE_PREFIX);
            builder.append("<data set type>' for each of these data set types. ");
            builder.append("Alternatively, the property '");
            builder.append(ExperimentBasedArchivingTask.DATA_SET_SIZE_PREFIX).append(ExperimentBasedArchivingTask.DEFAULT_DATA_SET_TYPE);
            builder.append("' can be specified.");
            return builder.toString();
        }

        String renderMessages() {
            return "Archiving summary:" + this.archivingMessages;
        }
    }
}

