/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.plugins;

import ch.systemsx.cisd.common.string.Template;
import ch.systemsx.cisd.etlserver.plugins.GenericFastaFileBuilder;
import java.io.File;

class FastaFileBuilderForDataSetFiles
extends GenericFastaFileBuilder {
    private static final Template ID_EXTENSION_TEMPLATE = new Template("[Data set: ${data_set}, File: ${file}]");
    private final String dataSetCode;
    private String idExtension;

    FastaFileBuilderForDataSetFiles(File tempFolder, String dataSetCode) {
        super(tempFolder, dataSetCode);
        this.dataSetCode = dataSetCode;
    }

    void setFilePath(String filePath) {
        this.writeFastaEntry();
        Template template = ID_EXTENSION_TEMPLATE.createFreshCopy();
        template.bind("data_set", this.dataSetCode);
        template.bind("file", filePath);
        this.idExtension = template.createText();
    }

    void handle(String line) {
        GenericFastaFileBuilder.EntryType entryType = this.tryToGetEntryType(line);
        if (entryType != null) {
            if (this.idExtension == null) {
                throw new IllegalStateException("File path not set [Data Set: " + this.dataSetCode + "].");
            }
            this.startEntry(entryType, line.substring(1) + " " + this.idExtension, null);
        } else {
            this.appendToSequence(line);
        }
    }

    @Override
    String createErrorMessageForUndefinedEntry(String line) {
        return "Invalid line " + this.idExtension + ". Line with identifier expected: " + line;
    }

    private GenericFastaFileBuilder.EntryType tryToGetEntryType(String line) {
        return line.startsWith(">") ? GenericFastaFileBuilder.EntryType.FASTA : (line.startsWith("@") ? GenericFastaFileBuilder.EntryType.FASTQ : null);
    }
}

