/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.plugins;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.maintenance.IMaintenanceTask;
import ch.systemsx.cisd.etlserver.plugins.MonitoredDirectory;
import ch.systemsx.cisd.etlserver.plugins.WriteDirectoryNameToDropboxAction;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import org.apache.log4j.Logger;

public class FileSystemMonitoringMaintenanceTask
implements IMaintenanceTask {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, FileSystemMonitoringMaintenanceTask.class);
    public static final String READY_TO_IMPORT_MARKER_FILE = "ready-to-import-marker-file";
    public static final String IMPORT_STATE_MARKER_FILE_PREFIX = "import-state-marker-file-prefix";
    public static final String MONITORED_DIRECTORIES = "monitored-directories";
    public static final String DROPBOX_DIRECTORY = "dropbox-directory";
    public static final String DEFAULT_READY_TO_IMPORT_MARKER_FILE = ".ready-to-import";
    public static final String DEFAULT_IMPORT_STATE_MARKER_FILE_PREFIX = ".import-";
    private String dropboxDirectory;
    private String readyToImportMarkerFile;
    private String importStateMarkerFilePrefix;
    private Collection<MonitoredDirectory> monitoredDirectories;

    public void setUp(String pluginName, Properties properties) {
        this.readyToImportMarkerFile = properties.getProperty(READY_TO_IMPORT_MARKER_FILE);
        this.importStateMarkerFilePrefix = properties.getProperty(IMPORT_STATE_MARKER_FILE_PREFIX);
        this.dropboxDirectory = properties.getProperty(DROPBOX_DIRECTORY);
        String directories = properties.getProperty(MONITORED_DIRECTORIES);
        if (this.readyToImportMarkerFile == null || this.readyToImportMarkerFile.length() == 0) {
            this.readyToImportMarkerFile = DEFAULT_READY_TO_IMPORT_MARKER_FILE;
        }
        if (this.importStateMarkerFilePrefix == null || this.importStateMarkerFilePrefix.length() == 0) {
            this.importStateMarkerFilePrefix = DEFAULT_IMPORT_STATE_MARKER_FILE_PREFIX;
        }
        this.monitoredDirectories = new HashSet<MonitoredDirectory>();
        if (directories != null) {
            for (String fileName : directories.split("\\,")) {
                File monitoredDirectory = new File(fileName.trim());
                try {
                    this.monitoredDirectories.add(new MonitoredDirectory(monitoredDirectory, this.readyToImportMarkerFile, this.importStateMarkerFilePrefix));
                }
                catch (RuntimeException e) {
                    operationLog.error((Object)("Cannot monitor directory " + monitoredDirectory.getAbsolutePath() + ": " + e.getMessage()));
                }
            }
        }
    }

    public void execute() {
        if (this.monitoredDirectories.isEmpty()) {
            operationLog.warn((Object)"No directories to monitor - doing nothing.");
            return;
        }
        if (this.dropboxDirectory == null || this.dropboxDirectory.length() == 0) {
            operationLog.warn((Object)"Dropbox directory not defined - doing nothing.");
            return;
        }
        for (MonitoredDirectory directory : this.monitoredDirectories) {
            directory.perform(new WriteDirectoryNameToDropboxAction(new File(this.dropboxDirectory)));
        }
    }
}

