/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.plugins;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.filesystem.SoftLinkMaker;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.logging.LogInitializer;
import ch.systemsx.cisd.common.maintenance.IDataStoreLockingMaintenanceTask;
import ch.systemsx.cisd.common.properties.ExtendedProperties;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.common.reflection.ClassUtils;
import ch.systemsx.cisd.etlserver.plugins.HierarchicalPath;
import ch.systemsx.cisd.etlserver.plugins.IHierarchicalStorageLinkNamingStrategy;
import ch.systemsx.cisd.etlserver.plugins.TemplateBasedLinkNamingStrategy;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.MetaDataBuilder;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ContainerDataSet;
import ch.systemsx.cisd.openbis.generic.shared.dto.SimpleDataSetInformationDTO;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class HierarchicalStorageUpdater
implements IDataStoreLockingMaintenanceTask {
    public static final String STOREROOT_DIR_LINK_PATH_KEY = "storeroot-dir-link-path";
    public static final String HIERARCHY_ROOT_DIR_KEY = "hierarchy-root-dir";
    public static final String HIERARCHY_LINK_NAMING_STRATEGY = "link-naming-strategy";
    public static final String LINK_SOURCE_SUBFOLDER = "link-source-subpath";
    public static final String LINK_FROM_FIRST_CHILD = "link-from-first-child";
    public static final String WITH_META_DATA = "with-meta-data";
    public static final String LINK_DIRECTORY = "data";
    private static final String META_DATA_TSV_FILE = "meta-data.tsv";
    private static final String MODIFICATION_TIMESTAMP_FILE = "modification_timestamp";
    private static final String REBUILDING_HIERARCHICAL_STORAGE = "Rebuilding hierarchical storage";
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, HierarchicalStorageUpdater.class);
    private IEncapsulatedOpenBISService openBISService;
    private IHierarchicalStorageLinkNamingStrategy linkNamingStrategy;
    private File storeRoot;
    private File hierarchyRoot;
    private boolean withMetaData;
    private Map<String, LinkSourceDescriptor> linkSourceDescriptors;
    private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");

    public void setUp(String pluginName, Properties pluginProperties) {
        LogInitializer.init();
        String storeRootFileName = pluginProperties.getProperty(STOREROOT_DIR_LINK_PATH_KEY);
        if (storeRootFileName == null) {
            storeRootFileName = PropertyUtils.getMandatoryProperty((Properties)pluginProperties, (String)"storeroot-dir");
        }
        String hierarchyRootFileName = PropertyUtils.getMandatoryProperty((Properties)pluginProperties, (String)HIERARCHY_ROOT_DIR_KEY);
        this.openBISService = ServiceProvider.getOpenBISService();
        this.linkNamingStrategy = this.createLinkNamingStrategy(pluginProperties);
        this.storeRoot = new File(storeRootFileName);
        this.hierarchyRoot = new File(hierarchyRootFileName);
        this.linkSourceDescriptors = this.initializeLinkSourceDescriptors(pluginProperties);
        this.withMetaData = PropertyUtils.getBoolean((Properties)pluginProperties, (String)WITH_META_DATA, (boolean)false);
        operationLog.info((Object)("Plugin initialized with: store root = " + storeRootFileName + ", hierarchy root = " + hierarchyRootFileName));
    }

    public void execute() {
        this.rebuildHierarchy();
    }

    public boolean requiresDataStoreLock() {
        return true;
    }

    private IHierarchicalStorageLinkNamingStrategy createLinkNamingStrategy(Properties properties) {
        String linkNamingStrategyClassName = PropertyUtils.getProperty((Properties)properties, (String)HIERARCHY_LINK_NAMING_STRATEGY, (String)TemplateBasedLinkNamingStrategy.class.getName());
        ExtendedProperties strategyProperties = ExtendedProperties.getSubset((Properties)properties, (String)"link-naming-strategy.", (boolean)true);
        try {
            return (IHierarchicalStorageLinkNamingStrategy)ClassUtils.create(IHierarchicalStorageLinkNamingStrategy.class, Class.forName(linkNamingStrategyClassName), (Object[])new Object[]{strategyProperties});
        }
        catch (ClassNotFoundException ex) {
            throw ConfigurationFailureException.fromTemplate((String)"Wrong '%s' property: %s", (Object[])new Object[]{HIERARCHY_LINK_NAMING_STRATEGY, ex.getMessage()});
        }
    }

    private Map<String, LinkSourceDescriptor> initializeLinkSourceDescriptors(Properties pluginProperties) {
        HashMap<String, LinkSourceDescriptor> result = new HashMap<String, LinkSourceDescriptor>();
        ExtendedProperties subFolderProps = ExtendedProperties.getSubset((Properties)pluginProperties, (String)"link-source-subpath.", (boolean)true);
        ExtendedProperties linkFromFirstChildProps = ExtendedProperties.getSubset((Properties)pluginProperties, (String)"link-from-first-child.", (boolean)true);
        HashSet dataSetTypes = new HashSet();
        dataSetTypes.addAll(subFolderProps.keySet());
        dataSetTypes.addAll(linkFromFirstChildProps.keySet());
        for (Object o : dataSetTypes) {
            String dataSetType = (String)o;
            String subFolder = subFolderProps.getProperty(dataSetType);
            boolean linkFromFirstChild = Boolean.parseBoolean(linkFromFirstChildProps.getProperty(dataSetType));
            LinkSourceDescriptor descriptor = new LinkSourceDescriptor(subFolder, linkFromFirstChild);
            result.put(dataSetType, descriptor);
        }
        return result;
    }

    private Set<String> startingWith(String prefix, Set<String> set) {
        HashSet<String> result = new HashSet<String>();
        for (String s : set) {
            if (!s.startsWith(prefix)) continue;
            result.add(s);
        }
        return result;
    }

    private void rebuildHierarchy() {
        operationLog.info((Object)REBUILDING_HIERARCHICAL_STORAGE);
        List<DataSetInformation> newLinkMappings = this.collectDataSet();
        Set<String> existingPaths = this.linkNamingStrategy.extractPaths(this.hierarchyRoot);
        for (DataSetInformation dataSetInformation : newLinkMappings) {
            String targetPath = dataSetInformation.targetFile.getAbsolutePath();
            Set<String> existing = this.startingWith(targetPath, existingPaths);
            if (existing.size() > 0) {
                existingPaths.removeAll(existing);
                if (dataSetInformation.containerDto != null) {
                    File[] containerMetadata;
                    for (File cm : containerMetadata = dataSetInformation.targetFile.getParentFile().listFiles(new FileFilter(){

                        @Override
                        public boolean accept(File file) {
                            return file.isFile() && !FileUtilities.isSymbolicLink((File)file);
                        }
                    })) {
                        existingPaths.remove(cm.getAbsolutePath());
                    }
                }
                this.handleExistingEntry(dataSetInformation);
                continue;
            }
            this.handleNonExistingEntry(dataSetInformation);
        }
        this.deleteObsoleteLinks(existingPaths);
        operationLog.info((Object)"Rebuilding hierarchical storage finished");
    }

    private void handleNonExistingEntry(DataSetInformation info) {
        if (this.withMetaData) {
            this.createDataSetFolder(info);
        } else {
            this.createLink(info.targetFile, info.linkSource);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleExistingEntry(DataSetInformation info) {
        String errorMsgLinksOnlyModeChanged = "The state of hierarchical store is corrupted or property 'with-meta-data' or 'component-template' has been modified after hierarchical store has been built. In this case the hierarchical store directory should be deleted manually. It will be recreated after DSS start up.";
        if (this.withMetaData) {
            if (FileUtilities.isSymbolicLink((File)info.targetFile)) {
                throw new IllegalStateException(errorMsgLinksOnlyModeChanged);
            }
            if (!info.targetFile.isDirectory()) throw new IllegalStateException(errorMsgLinksOnlyModeChanged);
            Date storedModificationDate = this.getModificationDateFromFile(info);
            if (storedModificationDate != null && !storedModificationDate.before(info.dto.getModificationDate())) return;
            this.createDataSetFolder(info);
            return;
        } else {
            if (!FileUtilities.isSymbolicLink((File)info.targetFile)) throw new IllegalStateException(errorMsgLinksOnlyModeChanged);
            return;
        }
    }

    private void createDataSetFolder(DataSetInformation info) {
        this.createLink(new File(info.targetFile, LINK_DIRECTORY), info.linkSource);
        this.createModificationDateFile(info);
        this.createMetaDataFile(info);
    }

    private void createMetaDataFile(DataSetInformation info) {
        File file = new File(info.targetFile, META_DATA_TSV_FILE);
        String content = MetaDataBuilder.createMetaData(info.dto);
        FileUtilities.writeToFile((File)file, (String)content);
        if (info.containerDto != null && !(file = new File(info.targetFile + "/..", META_DATA_TSV_FILE)).exists()) {
            content = MetaDataBuilder.createMetaData((AbstractExternalData)info.containerDto);
            FileUtilities.writeToFile((File)file, (String)content);
        }
    }

    private void createModificationDateFile(DataSetInformation info) {
        File file = new File(info.targetFile, MODIFICATION_TIMESTAMP_FILE);
        FileUtilities.writeToFile((File)file, (String)this.dateFormat.format(info.dto.getModificationDate()));
        if (info.containerDto != null) {
            file = new File(info.targetFile + "/..", MODIFICATION_TIMESTAMP_FILE);
            FileUtilities.writeToFile((File)file, (String)this.dateFormat.format(info.containerDto.getModificationDate()));
        }
    }

    private Date getModificationDateFromFile(DataSetInformation info) {
        File file = new File(info.targetFile, MODIFICATION_TIMESTAMP_FILE);
        if (!file.exists()) {
            return null;
        }
        String content = FileUtilities.loadToString((File)file);
        try {
            return this.dateFormat.parse(content);
        }
        catch (ParseException pe) {
            operationLog.error((Object)("Modificaction date of dataset stored in Hierarchical store in file " + file.getAbsolutePath() + " is corrupted"));
            return null;
        }
    }

    private HashMap<String, AbstractExternalData> getAbstractExternalDataByCode(Collection<SimpleDataSetInformationDTO> dataSets) {
        ArrayList<String> codes = new ArrayList<String>();
        for (SimpleDataSetInformationDTO dataSet : dataSets) {
            codes.add(dataSet.getDataSetCode());
        }
        List<AbstractExternalData> listDataSetsByCode = this.openBISService.listDataSetsByCode(codes);
        HashMap<String, AbstractExternalData> dataSetsByCode = new HashMap<String, AbstractExternalData>();
        for (AbstractExternalData abstractExternalData : listDataSetsByCode) {
            dataSetsByCode.put(abstractExternalData.getCode(), abstractExternalData);
        }
        return dataSetsByCode;
    }

    private List<DataSetInformation> collectDataSet() {
        List<SimpleDataSetInformationDTO> dataSets = this.openBISService.listPhysicalDataSets();
        HashMap<String, AbstractExternalData> dataSetsByCode = this.getAbstractExternalDataByCode(dataSets);
        ArrayList<DataSetInformation> result = new ArrayList<DataSetInformation>();
        for (SimpleDataSetInformationDTO dataSet : dataSets) {
            AbstractExternalData abstractData = dataSetsByCode.get(dataSet.getDataSetCode());
            Set<HierarchicalPath> paths = this.linkNamingStrategy.createHierarchicalPaths(abstractData);
            for (HierarchicalPath hierarchicalPath : paths) {
                File targetFile = new File(this.hierarchyRoot, hierarchicalPath.getPath());
                File share = new File(this.storeRoot, dataSet.getDataSetShareId());
                File dataSetLocationRoot = new File(share, dataSet.getDataSetLocation());
                File linkSource = this.determineLinkSource(dataSetLocationRoot, dataSet.getDataSetType());
                DataSetInformation info = new DataSetInformation();
                info.dto = abstractData;
                info.linkSource = linkSource;
                info.targetFile = targetFile;
                info.containerDto = hierarchicalPath.getContainer();
                if (linkSource == null) {
                    String logMessage = String.format("Can not determine the link source file for data set '%s', dataSetType='%s'. Link creation will be skipped.", dataSetLocationRoot, dataSet.getDataSetType());
                    operationLog.warn((Object)logMessage);
                }
                if (!this.withMetaData && linkSource == null) continue;
                result.add(info);
            }
        }
        return result;
    }

    private File determineLinkSource(File dataSetLocationRoot, String dataSetType) {
        LinkSourceDescriptor linkSourceDescriptor = this.getLinkSourceDescriptor(dataSetType);
        File source = dataSetLocationRoot;
        if (linkSourceDescriptor != null) {
            String subPath = linkSourceDescriptor.getSubFolder();
            if (!StringUtils.isBlank((CharSequence)subPath) && !(source = new File(source.getAbsolutePath() + File.separator + subPath)).exists()) {
                String logMessage = String.format("Invalid '%s' configuration for data set '%s'. Subfolder '%s' does not exist", LINK_SOURCE_SUBFOLDER, dataSetLocationRoot, source);
                operationLog.warn((Object)logMessage);
                return null;
            }
            if (linkSourceDescriptor.isLinkFromFirstChild() && source.isDirectory()) {
                File[] rootChildren = source.listFiles();
                if (rootChildren == null || rootChildren.length == 0) {
                    String logMessage = String.format("Invalid '%s' configuration for data set '%s'. Subfolder '%s' has no children", LINK_FROM_FIRST_CHILD, dataSetLocationRoot, source);
                    operationLog.warn((Object)logMessage);
                    return null;
                }
                source = rootChildren[0];
            }
        }
        return source;
    }

    private LinkSourceDescriptor getLinkSourceDescriptor(String dataSetType) {
        return this.linkSourceDescriptors.get(dataSetType);
    }

    private void deleteObsoleteLinks(Set<String> toBeDeleted) {
        for (String pathToDelete : toBeDeleted) {
            File toDelete = new File(pathToDelete);
            File parent = toDelete.getParentFile();
            this.deleteWithSymbolicLinks(toDelete);
            while (parent != null && !this.isSameFile(parent, this.hierarchyRoot) && parent.list().length == 0) {
                toDelete = parent;
                parent = toDelete.getParentFile();
                this.delete(toDelete);
            }
        }
    }

    private boolean isSameFile(File file1, File file2) {
        try {
            return file1.getCanonicalPath().equals(file2.getCanonicalPath());
        }
        catch (IOException ioex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ioex);
        }
    }

    private void deleteWithSymbolicLinks(File toDelete) {
        if (!FileUtilities.isSymbolicLink((File)toDelete) && toDelete.isDirectory()) {
            for (File file : toDelete.listFiles()) {
                boolean ok = this.delete(file);
                if (ok) continue;
                operationLog.error((Object)("Cannot delete the file: " + file.getPath()));
            }
        }
        this.delete(toDelete);
    }

    private boolean delete(File file) {
        if (this.canBeDeleted(file)) {
            operationLog.info((Object)("Deleting " + file.getAbsolutePath()));
            return file.delete();
        }
        operationLog.error((Object)(file.getPath() + " is not a symbolic link and will not be deleted."));
        return false;
    }

    private boolean canBeDeleted(File file) {
        if (this.isUnderHierarchyRoot(file)) {
            return FileUtilities.isSymbolicLink((File)file) || file.isDirectory() || file.getName().equals(MODIFICATION_TIMESTAMP_FILE) || file.getName().equals(META_DATA_TSV_FILE);
        }
        operationLog.warn((Object)("Aborting an attempt to delete content outside of hierarchy root : " + file.getAbsolutePath() + ". Please analyze, this is a programming error."));
        return false;
    }

    private boolean isUnderHierarchyRoot(File file) {
        return file.getAbsolutePath().startsWith(this.hierarchyRoot.getAbsolutePath());
    }

    private void createLink(File targetFile, File sourceFile) {
        if (targetFile.exists()) {
            targetFile.delete();
        }
        targetFile.getParentFile().mkdirs();
        if (sourceFile != null && sourceFile.exists()) {
            SoftLinkMaker.createSymbolicLink((File)sourceFile.getAbsoluteFile(), (File)targetFile.getAbsoluteFile());
        }
    }

    private class DataSetInformation {
        AbstractExternalData dto;
        ContainerDataSet containerDto;
        File targetFile;
        File linkSource;

        private DataSetInformation() {
        }
    }

    private static class LinkSourceDescriptor {
        private final String subFolder;
        private final boolean linkFromFirstChild;

        public LinkSourceDescriptor(String subFolder, boolean linkFromFirstChild) {
            this.subFolder = subFolder;
            this.linkFromFirstChild = linkFromFirstChild;
        }

        public String getSubFolder() {
            return this.subFolder;
        }

        public boolean isLinkFromFirstChild() {
            return this.linkFromFirstChild;
        }
    }
}

