/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.plugins;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.etlserver.plugins.ImportState;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class ImportStateMarkerFile {
    public static final File[] listMarkerFiles(final String prefix, File dir) {
        File[] markerFiles = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.getName().startsWith(prefix)) {
                    String state = file.getName().substring(prefix.length());
                    try {
                        ImportState.valueOf(state.toUpperCase());
                    }
                    catch (IllegalArgumentException e) {
                        return false;
                    }
                    return true;
                }
                return false;
            }
        });
        return markerFiles;
    }

    public static final File setMarkerFile(String prefix, File dir, ImportState state) {
        return ImportStateMarkerFile.setMarkerFile(prefix, dir, state, null);
    }

    public static final File setMarkerFile(final String prefix, File dir, ImportState state, String content) {
        File[] filesWithMatchingPrefix;
        for (File fileWithMatchingPrefix : filesWithMatchingPrefix = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().startsWith(prefix);
            }
        })) {
            FileUtilities.delete((File)fileWithMatchingPrefix);
        }
        try {
            File markerFile = new File(dir, prefix + state.name().toLowerCase());
            markerFile.createNewFile();
            if (content != null) {
                FileUtils.writeStringToFile((File)markerFile, (String)content);
            }
            return markerFile;
        }
        catch (IOException e) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)e);
        }
    }
}

