/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.plugins;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.etlserver.plugins.DirectoryAction;
import ch.systemsx.cisd.etlserver.plugins.ImportState;
import ch.systemsx.cisd.etlserver.plugins.ImportStateMarkerFile;
import java.io.File;
import java.io.FileFilter;
import org.apache.log4j.Logger;

public class MonitoredDirectory {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, MonitoredDirectory.class);
    private final File directory;
    private final String readyToImportMarkerFile;
    private final String importStateMarkerFilePrefix;

    public MonitoredDirectory(File directory, String readyToImportMarkerFile, String importStateMarkerFilePrefix) {
        if (directory.isFile()) {
            throw new IllegalArgumentException("Monitored directory " + directory.getAbsolutePath() + " is a file.");
        }
        if (!directory.exists()) {
            throw new IllegalArgumentException("Monitored directory " + directory.getAbsolutePath() + " does not exist.");
        }
        if (!directory.canWrite()) {
            throw new IllegalArgumentException("Cannot write to monitored directory " + directory.getAbsolutePath());
        }
        if (!directory.canRead()) {
            throw new IllegalArgumentException("Cannot read from monitored directory " + directory.getAbsolutePath());
        }
        this.directory = directory;
        this.readyToImportMarkerFile = readyToImportMarkerFile;
        this.importStateMarkerFilePrefix = importStateMarkerFilePrefix;
    }

    public void perform(DirectoryAction action) {
        for (File subdir : this.listSubDirectoriesOf(this.directory)) {
            File readyFile = new File(subdir, this.readyToImportMarkerFile);
            File[] stateFiles = ImportStateMarkerFile.listMarkerFiles(this.importStateMarkerFilePrefix, subdir);
            if (!readyFile.exists() || stateFiles.length != 0) continue;
            try {
                action.performOn(subdir);
                ImportStateMarkerFile.setMarkerFile(this.importStateMarkerFilePrefix, subdir, ImportState.QUEUED);
            }
            catch (Exception ex) {
                operationLog.error((Object)("Could not perform an action: " + action + " on a monitored directory: " + subdir), (Throwable)ex);
            }
        }
    }

    private File[] listSubDirectoriesOf(File dir) {
        File[] subdirectories = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        return subdirectories;
    }
}

