/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.plugins;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.maintenance.IMaintenanceTask;
import ch.systemsx.cisd.openbis.dss.generic.server.IDataSetCommandExecutor;
import ch.systemsx.cisd.openbis.dss.generic.server.IDataSetCommandExecutorProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.QueueingDataSetStatusUpdaterService;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetCodesWithStatus;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetArchivingStatus;
import ch.systemsx.cisd.openbis.generic.shared.dto.SimpleDataSetInformationDTO;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.springframework.transaction.annotation.Transactional;

public class ResetArchivePendingTask
implements IMaintenanceTask {
    private static final String COMMAND_EXECUTOR_BEAN = "data-set-command-executor-provider";
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, ResetArchivePendingTask.class);

    public void setUp(String pluginName, Properties properties) {
        operationLog.info((Object)("Task " + pluginName + " initialized."));
    }

    @Transactional
    public void execute() {
        operationLog.info((Object)(ResetArchivePendingTask.class.getSimpleName() + " Started"));
        IEncapsulatedOpenBISService service = ServiceProvider.getOpenBISService();
        List<SimpleDataSetInformationDTO> inArchivePendings = service.listPhysicalDataSetsByArchivingStatus(DataSetArchivingStatus.ARCHIVE_PENDING, false);
        if (!inArchivePendings.isEmpty()) {
            operationLog.info((Object)("Found " + inArchivePendings.size() + " datasets in " + DataSetArchivingStatus.ARCHIVE_PENDING.name() + " status."));
            IDataSetCommandExecutorProvider commandExecutorProvider = (IDataSetCommandExecutorProvider)ServiceProvider.getApplicationContext().getBean(COMMAND_EXECUTOR_BEAN);
            HashSet<String> inQueue = new HashSet<String>();
            List<IDataSetCommandExecutor> executors = commandExecutorProvider.getAllExecutors();
            for (IDataSetCommandExecutor iDataSetCommandExecutor : executors) {
                inQueue.addAll(iDataSetCommandExecutor.getDataSetCodesFromCommandQueue());
            }
            operationLog.info((Object)("Found " + inQueue.size() + " datasets in the " + executors.size() + " command queues."));
            ArrayList<String> dataSetsToUpdate = new ArrayList<String>();
            for (SimpleDataSetInformationDTO inArchivePending : inArchivePendings) {
                if (inQueue.contains(inArchivePending.getDataSetCode())) continue;
                dataSetsToUpdate.add(inArchivePending.getDataSetCode());
                operationLog.info((Object)(inArchivePending.getDataSetCode() + " scheduled to update because not present in archive and not found in any command queue."));
            }
            operationLog.info((Object)("Going to update " + dataSetsToUpdate.size() + " datasets."));
            DataSetCodesWithStatus dataSetCodesWithStatus = new DataSetCodesWithStatus(dataSetsToUpdate, DataSetArchivingStatus.AVAILABLE, false);
            QueueingDataSetStatusUpdaterService.update(dataSetCodesWithStatus);
        }
        operationLog.info((Object)(ResetArchivePendingTask.class.getSimpleName() + " Finished"));
    }
}

