/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.plugins;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.openbis.dss.generic.shared.AbstractShareFinder;
import ch.systemsx.cisd.openbis.dss.generic.shared.ISpeedChecker;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.Share;
import ch.systemsx.cisd.openbis.generic.shared.dto.SimpleDataSetInformationDTO;
import java.util.List;
import java.util.Properties;

public class SimpleShufflingShareFinder
extends AbstractShareFinder {
    @Private
    public static final String MINIMUM_FREE_SPACE_KEY = "minimum-free-space-in-MB";
    private final long minimumFreeSpace;

    public SimpleShufflingShareFinder(Properties properties) {
        this.minimumFreeSpace = 0x100000L * PropertyUtils.getLong((Properties)properties, (String)MINIMUM_FREE_SPACE_KEY, (long)1024L);
    }

    @Override
    protected Share tryToFindShare(SimpleDataSetInformationDTO dataSet, List<Share> shares, ISpeedChecker speedChecker) {
        Share shareWithMostFree = null;
        Share homeShare = null;
        long maxFreeSpace = 0L;
        for (Share share : shares) {
            long freeSpace;
            if (!speedChecker.check(dataSet, share)) continue;
            if (share.getShareId().equals(dataSet.getDataSetShareId())) {
                homeShare = share;
            }
            if ((freeSpace = share.calculateFreeSpace()) <= maxFreeSpace) continue;
            maxFreeSpace = freeSpace;
            shareWithMostFree = share;
        }
        if (maxFreeSpace - dataSet.getDataSetSize() > this.minimumFreeSpace && homeShare != shareWithMostFree) {
            return shareWithMostFree;
        }
        return null;
    }
}

