/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.plugins;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.properties.ExtendedProperties;
import ch.systemsx.cisd.etlserver.plugins.HierarchicalPath;
import ch.systemsx.cisd.etlserver.plugins.IHierarchicalStorageLinkNamingStrategy;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ContainerDataSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class TemplateBasedLinkNamingStrategy
implements IHierarchicalStorageLinkNamingStrategy {
    public static final String DEFAULT_LINK_TEMPLATE = "${space}/${project}/${experiment}/${dataSetType}+${sample}+${dataSet}";
    private static final String LINKS_TEMPLATE_PROP_NAME = "template";
    public static final String COMPONENT_LINKS_TEMPLATE_PROP_NAME = "component-template";
    private static final String NOT_DIRECTLY_CONNECTED = "NOT_DIRECTLY_CONNECTED";
    private final String linkTemplate;
    private final String componentLinkTemplate;

    public TemplateBasedLinkNamingStrategy(String template, String componentTemplate) {
        this.linkTemplate = template == null ? DEFAULT_LINK_TEMPLATE : template;
        this.componentLinkTemplate = componentTemplate;
    }

    public TemplateBasedLinkNamingStrategy(Properties configurationProperties) {
        this(configurationProperties.getProperty(LINKS_TEMPLATE_PROP_NAME), configurationProperties.getProperty(COMPONENT_LINKS_TEMPLATE_PROP_NAME));
    }

    @Override
    public Set<HierarchicalPath> createHierarchicalPaths(AbstractExternalData data) {
        if (data.getContainerDataSets().size() == 0 || this.componentLinkTemplate == null) {
            ExtendedProperties props = new ExtendedProperties();
            for (PathVariable pathElement : PathVariable.values()) {
                String pathElementName = pathElement.name();
                String pathElementValue = pathElement.extractValueFromData(data);
                if (pathElementValue == null) {
                    pathElementValue = "";
                }
                props.put((Object)pathElementName, (Object)pathElementValue);
            }
            return Collections.singleton(new HierarchicalPath(this.evaluateTemplate(props, this.linkTemplate), null));
        }
        HashSet<HierarchicalPath> results = new HashSet<HierarchicalPath>();
        for (ContainerDataSet container : data.getContainerDataSets()) {
            ExtendedProperties props = new ExtendedProperties();
            for (PathVariable pathElement : PathVariable.values()) {
                String pathElementName = pathElement.name();
                String pathElementValue = pathElement.extractValueFromData(data, container);
                if (pathElementValue == null) {
                    pathElementValue = "";
                }
                props.put((Object)pathElementName, (Object)pathElementValue);
            }
            results.add(new HierarchicalPath(this.evaluateTemplate(props, this.componentLinkTemplate), container));
        }
        return results;
    }

    @Override
    public Set<String> extractPaths(File root) {
        HashSet<String> set = new HashSet<String>();
        TemplateBasedLinkNamingStrategy.accumulatePaths(set, root);
        return set;
    }

    private String evaluateTemplate(ExtendedProperties props, String template) {
        props.put((Object)LINKS_TEMPLATE_PROP_NAME, (Object)template);
        return props.getProperty(LINKS_TEMPLATE_PROP_NAME);
    }

    @Private
    static void accumulatePaths(HashSet<String> paths, File dir) {
        File[] children = dir.listFiles();
        if (children != null) {
            for (File child : children) {
                if (child.isDirectory() && !FileUtilities.isSymbolicLink((File)child)) {
                    TemplateBasedLinkNamingStrategy.accumulatePaths(paths, child);
                    continue;
                }
                String absolutePath = child.getAbsolutePath();
                paths.add(absolutePath);
            }
        }
    }

    static enum PathVariable {
        dataSet{

            @Override
            String extractValueFromData(AbstractExternalData data, ContainerDataSet container) {
                return data.getCode();
            }
        }
        ,
        dataSetType{

            @Override
            String extractValueFromData(AbstractExternalData data, ContainerDataSet container) {
                return data.getDataSetType().getCode();
            }
        }
        ,
        sample{

            @Override
            String extractValueFromData(AbstractExternalData data, ContainerDataSet container) {
                return PathVariable.getPathElement(data.getSampleCode());
            }
        }
        ,
        experiment{

            @Override
            String extractValueFromData(AbstractExternalData data, ContainerDataSet container) {
                Experiment experiment = data.getExperiment();
                return PathVariable.getPathElement(experiment == null ? null : experiment.getCode());
            }
        }
        ,
        project{

            @Override
            String extractValueFromData(AbstractExternalData data, ContainerDataSet container) {
                Experiment experiment = data.getExperiment();
                return PathVariable.getPathElement(experiment == null ? null : experiment.getProject().getCode());
            }
        }
        ,
        space{

            @Override
            String extractValueFromData(AbstractExternalData data, ContainerDataSet container) {
                return data.getSpace().getCode();
            }
        }
        ,
        containerDataSet{

            @Override
            String extractValueFromData(AbstractExternalData data, ContainerDataSet container) {
                if (container != null) {
                    return container.getCode();
                }
                return null;
            }
        }
        ,
        containerDataSetType{

            @Override
            String extractValueFromData(AbstractExternalData data, ContainerDataSet container) {
                if (container != null) {
                    return container.getDataSetType().getCode();
                }
                return null;
            }
        }
        ,
        containerSample{

            @Override
            String extractValueFromData(AbstractExternalData data, ContainerDataSet container) {
                if (container != null) {
                    return PathVariable.getPathElement(container.getSampleCode());
                }
                return null;
            }
        };


        String extractValueFromData(AbstractExternalData data) {
            return this.extractValueFromData(data, null);
        }

        abstract String extractValueFromData(AbstractExternalData var1, ContainerDataSet var2);

        private static String getPathElement(String pathElement) {
            return pathElement == null ? TemplateBasedLinkNamingStrategy.NOT_DIRECTLY_CONNECTED : pathElement;
        }
    }
}

