/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.postregistration;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.logging.ISimpleLogger;
import ch.systemsx.cisd.common.logging.LogLevel;
import ch.systemsx.cisd.common.string.Template;
import ch.systemsx.cisd.etlserver.postregistration.ICleanupTask;
import ch.systemsx.cisd.etlserver.postregistration.IPostRegistrationTaskExecutor;
import ch.systemsx.cisd.openbis.dss.generic.shared.ArchiverTaskContext;
import ch.systemsx.cisd.openbis.dss.generic.shared.IArchiverPlugin;
import ch.systemsx.cisd.openbis.dss.generic.shared.IDataSetDirectoryProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.IHierarchicalContentProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.ProcessingStatus;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetArchivingStatus;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatasetLocation;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PhysicalDataSet;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import ch.systemsx.cisd.openbis.generic.shared.translator.DataSetTranslator;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

class ArchivingExecutor
implements IPostRegistrationTaskExecutor {
    private final String dataSetCode;
    private final IEncapsulatedOpenBISService service;
    private final IDataSetDirectoryProvider dataSetDirectoryProvider;
    private final IHierarchicalContentProvider hierarchicalContentProvider;
    private final IArchiverPlugin archiver;
    private final boolean updateStatus;
    private final Template notificationTemplate;
    private final Logger operationLog;
    private final Logger notificationLog;

    ArchivingExecutor(String dataSetCode, boolean updateStatus, Template notificationTemplate, IEncapsulatedOpenBISService service, IArchiverPlugin archiver, IDataSetDirectoryProvider dataSetDirectoryProvider, IHierarchicalContentProvider hierarchicalContentProvider, Logger operationLog, Logger notificationLog) {
        this.dataSetCode = dataSetCode;
        this.updateStatus = updateStatus;
        this.notificationTemplate = notificationTemplate;
        this.service = service;
        this.archiver = archiver;
        this.dataSetDirectoryProvider = dataSetDirectoryProvider;
        this.hierarchicalContentProvider = hierarchicalContentProvider;
        this.operationLog = operationLog;
        this.notificationLog = notificationLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        boolean statusUpdated;
        if (this.archiver == null) {
            this.operationLog.error((Object)"Post-registration archiving cannot be completed, because there is no archiver configured. Please configure an archiver and restart. ");
            return;
        }
        AbstractExternalData dataSet = ArchivingExecutor.tryGetExternalData(this.dataSetCode, this.service);
        if (dataSet == null) {
            this.operationLog.warn((Object)("Data set '" + this.dataSetCode + "' is no longer available in openBIS.Archiving post-registration task will be skipped..."));
            return;
        }
        if (dataSet instanceof PhysicalDataSet && ((PhysicalDataSet)dataSet).isPresentInArchive()) {
            return;
        }
        if (!this.updateStatus) {
            this.operationLog.info((Object)("Archiving data set '" + this.dataSetCode + "' without updating archiving status."));
        }
        boolean bl = statusUpdated = this.updateStatus ? this.service.compareAndSetDataSetStatus(this.dataSetCode, DataSetArchivingStatus.AVAILABLE, DataSetArchivingStatus.BACKUP_PENDING, false) : true;
        if (statusUpdated) {
            DatasetDescription dataSetDescription = DataSetTranslator.translateToDescription((AbstractExternalData)dataSet);
            List<DatasetDescription> dataSetAsList = Collections.singletonList(dataSetDescription);
            ArchiverTaskContext context = new ArchiverTaskContext(this.dataSetDirectoryProvider, this.hierarchicalContentProvider);
            ProcessingStatus processingStatus = this.archiver.archive(dataSetAsList, context, false);
            boolean presentInArchive = true;
            try {
                if (!processingStatus.getErrorStatuses().isEmpty()) {
                    this.notifyAdministrator(processingStatus, this.notificationTemplate.createFreshCopy());
                    presentInArchive = false;
                    throw new EnvironmentFailureException("Archiving of data set " + this.dataSetCode + " failed.");
                }
            }
            finally {
                if (this.updateStatus) {
                    this.service.compareAndSetDataSetStatus(this.dataSetCode, DataSetArchivingStatus.BACKUP_PENDING, DataSetArchivingStatus.AVAILABLE, presentInArchive);
                }
            }
        }
    }

    private void notifyAdministrator(ProcessingStatus processingStatus, Template template) {
        template.bind("dataSet", this.dataSetCode);
        StringBuilder builder = new StringBuilder();
        for (Status status : processingStatus.getErrorStatuses()) {
            if (status.tryGetErrorMessage() == null) continue;
            builder.append("Error encountered : " + status.tryGetErrorMessage());
            builder.append("\n");
        }
        template.bind("errors", builder.toString());
        this.notificationLog.error((Object)template.createText());
    }

    @Override
    public ICleanupTask createCleanupTask() {
        return new ArchivingCleanupTask(this.dataSetCode, this.updateStatus, this.service, this.archiver);
    }

    private static AbstractExternalData tryGetExternalData(String dataSetCode, IEncapsulatedOpenBISService service) {
        List<String> codeAsList = Collections.singletonList(dataSetCode);
        List<AbstractExternalData> dataList = service.listDataSetsByCode(codeAsList);
        if (dataList == null || dataList.isEmpty()) {
            return null;
        }
        AbstractExternalData data = dataList.get(0);
        return data;
    }

    private static DatasetDescription tryGetDatasetWithLocation(String dataSetCode, IEncapsulatedOpenBISService service) {
        AbstractExternalData data = ArchivingExecutor.tryGetExternalData(dataSetCode, service);
        return data != null ? DataSetTranslator.translateToDescription((AbstractExternalData)data) : null;
    }

    private static class ArchivingCleanupTask
    implements ICleanupTask {
        private static final long serialVersionUID = 1L;
        private final String dataSetCode;
        private transient IEncapsulatedOpenBISService service;
        private transient IArchiverPlugin archiver;
        private final boolean updateStatus;

        ArchivingCleanupTask(String dataSetCode, boolean updateStatus, IEncapsulatedOpenBISService service, IArchiverPlugin archiver) {
            this.dataSetCode = dataSetCode;
            this.updateStatus = updateStatus;
            this.service = service;
            this.archiver = archiver;
        }

        @Override
        public void cleanup(ISimpleLogger logger) {
            boolean statusUpdated;
            if (this.updateStatus && !(statusUpdated = this.getService().compareAndSetDataSetStatus(this.dataSetCode, DataSetArchivingStatus.BACKUP_PENDING, DataSetArchivingStatus.AVAILABLE, false))) {
                return;
            }
            DatasetDescription dataSet = ArchivingExecutor.tryGetDatasetWithLocation(this.dataSetCode, this.getService());
            if (this.getArchiver() != null && dataSet != null && dataSet.getDataSetLocation() != null) {
                DatasetLocation dataset = new DatasetLocation();
                dataset.setDatasetCode(this.dataSetCode);
                dataset.setDataSetLocation(dataSet.getDataSetLocation());
                List<DatasetLocation> dataSetAsList = Collections.singletonList(dataset);
                this.getArchiver().deleteFromArchive(dataSetAsList);
                logger.log(LogLevel.INFO, "Successfully cleaned up leftovers from incomplete archiving of dataset '" + this.dataSetCode + "'.");
            }
        }

        private IEncapsulatedOpenBISService getService() {
            if (this.service == null) {
                this.service = ServiceProvider.getOpenBISService();
            }
            return this.service;
        }

        private IArchiverPlugin getArchiver() {
            if (this.archiver == null) {
                this.archiver = ServiceProvider.getDataStoreService().getArchiverPlugin();
            }
            return this.archiver;
        }
    }
}

