/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.postregistration;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.string.Template;
import ch.systemsx.cisd.etlserver.plugins.AutoArchiverTask;
import ch.systemsx.cisd.etlserver.postregistration.AbstractPostRegistrationTaskForPhysicalDataSets;
import ch.systemsx.cisd.etlserver.postregistration.ArchivingExecutor;
import ch.systemsx.cisd.etlserver.postregistration.IPostRegistrationTaskExecutor;
import ch.systemsx.cisd.openbis.dss.generic.shared.IArchiverPlugin;
import ch.systemsx.cisd.openbis.dss.generic.shared.IDataSetDirectoryProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IDataStoreServiceInternal;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.IHierarchicalContentProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ArchivingPostRegistrationTask
extends AbstractPostRegistrationTaskForPhysicalDataSets {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, ArchivingPostRegistrationTask.class);
    private static final Logger notificationLog = LogFactory.getLogger((LogCategory)LogCategory.NOTIFY, ArchivingPostRegistrationTask.class);

    public ArchivingPostRegistrationTask(Properties properties, IEncapsulatedOpenBISService service) {
        super(properties, service);
    }

    @Override
    public IPostRegistrationTaskExecutor createExecutor(String dataSetCode) {
        IDataStoreServiceInternal dataStoreService = ServiceProvider.getDataStoreService();
        IArchiverPlugin archiver = dataStoreService.getArchiverPlugin();
        IDataSetDirectoryProvider dataSetDirectoryProvider = dataStoreService.getDataSetDirectoryProvider();
        IHierarchicalContentProvider hierarchicalContentProvider = ServiceProvider.getHierarchicalContentProvider();
        Template notificationTemplate = new Template("Eager archiving of dataset '${dataSet}' has failed.\n${errors}\nIf you wish to archive the dataset in the future, you can configure an '" + AutoArchiverTask.class.getSimpleName() + "'.");
        return new ArchivingExecutor(dataSetCode, true, notificationTemplate, this.service, archiver, dataSetDirectoryProvider, hierarchicalContentProvider, operationLog, notificationLog);
    }
}

