/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.postregistration;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.filesystem.IFreeSpaceProvider;
import ch.systemsx.cisd.common.filesystem.SimpleFreeSpaceProvider;
import ch.systemsx.cisd.common.logging.ISimpleLogger;
import ch.systemsx.cisd.common.logging.Log4jSimpleLogger;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.logging.LogLevel;
import ch.systemsx.cisd.common.properties.PropertyParametersUtil;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.common.reflection.ClassUtils;
import ch.systemsx.cisd.etlserver.plugins.DataSetMover;
import ch.systemsx.cisd.etlserver.plugins.IDataSetMover;
import ch.systemsx.cisd.etlserver.postregistration.AbstractPostRegistrationTaskForPhysicalDataSets;
import ch.systemsx.cisd.etlserver.postregistration.ICleanupTask;
import ch.systemsx.cisd.etlserver.postregistration.IPostRegistrationTaskExecutor;
import ch.systemsx.cisd.etlserver.postregistration.NoCleanupTask;
import ch.systemsx.cisd.openbis.dss.generic.shared.HierarchicalContentChecksumProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IChecksumProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IConfigProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.IShareFinder;
import ch.systemsx.cisd.openbis.dss.generic.shared.IShareIdManager;
import ch.systemsx.cisd.openbis.dss.generic.shared.IncomingShareIdProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.SegmentedStoreUtils;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.Share;
import ch.systemsx.cisd.openbis.generic.shared.dto.SimpleDataSetInformationDTO;
import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;

public class EagerShufflingTask
extends AbstractPostRegistrationTaskForPhysicalDataSets {
    private static final int SHARES_CACHING_TIMEOUT = 3600000;
    @Private
    public static final String SHARE_FINDER_KEY = "share-finder";
    @Private
    public static final String FREE_SPACE_LIMIT_KEY = "free-space-limit-in-MB-triggering-notification";
    @Private
    public static final String STOP_ON_NO_SHARE_FOUND_KEY = "stop-on-no-share-found";
    @Private
    public static final String VERIFY_CHECKSUM_KEY = "verify-checksum";
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, EagerShufflingTask.class);
    private static final Logger notificationLog = LogFactory.getLogger((LogCategory)LogCategory.NOTIFY, EagerShufflingTask.class);
    private final IShareIdManager shareIdManager;
    private final IFreeSpaceProvider freeSpaceProvider;
    private final IDataSetMover dataSetMover;
    private final IChecksumProvider checksumProvider;
    private final ISimpleLogger logger;
    private final ISimpleLogger notifyer;
    private final File storeRoot;
    private final String dataStoreCode;
    private final Set<String> incomingShares;
    private IShareFinder finder;
    private long freeSpaceLimitTriggeringNotification;
    private boolean stopOnNoShareFound;
    private boolean verifyChecksum;
    private List<Share> shares;
    private Date sharesTimestamp;

    private static SimpleDataSetInformationDTO findDataSet(List<Share> shares, String dataSetCode) {
        for (Share share : shares) {
            List<SimpleDataSetInformationDTO> dataSets = share.getDataSetsOrderedBySize();
            for (SimpleDataSetInformationDTO dataSet : dataSets) {
                if (!dataSet.getDataSetCode().equals(dataSetCode)) continue;
                return dataSet;
            }
        }
        throw new IllegalStateException("Data set " + dataSetCode + " not found.");
    }

    public EagerShufflingTask(Properties properties, IEncapsulatedOpenBISService service) {
        this(properties, IncomingShareIdProvider.getIdsOfIncomingShares(), service, ServiceProvider.getShareIdManager(), (IFreeSpaceProvider)new SimpleFreeSpaceProvider(), new DataSetMover(service, ServiceProvider.getShareIdManager()), ServiceProvider.getConfigProvider(), new HierarchicalContentChecksumProvider(ServiceProvider.getHierarchicalContentProvider()), (ISimpleLogger)new Log4jSimpleLogger(operationLog), (ISimpleLogger)new Log4jSimpleLogger(notificationLog));
    }

    @Private
    public EagerShufflingTask(Properties properties, Set<String> incomingShares, IEncapsulatedOpenBISService service, IShareIdManager shareIdManager, IFreeSpaceProvider freeSpaceProvider, IDataSetMover dataSetMover, IConfigProvider configProvider, IChecksumProvider checksumProvider, ISimpleLogger logger, ISimpleLogger notifyer) {
        super(properties, service);
        this.incomingShares = incomingShares;
        this.shareIdManager = shareIdManager;
        this.freeSpaceProvider = freeSpaceProvider;
        this.dataSetMover = dataSetMover;
        this.checksumProvider = checksumProvider;
        this.logger = logger;
        this.notifyer = notifyer;
        this.dataStoreCode = configProvider.getDataStoreCode();
        this.storeRoot = configProvider.getStoreRoot();
        if (!this.storeRoot.isDirectory()) {
            throw new ConfigurationFailureException("Store root does not exists or is not a directory: " + this.storeRoot.getAbsolutePath());
        }
        Properties props = PropertyParametersUtil.extractSingleSectionProperties((Properties)properties, (String)SHARE_FINDER_KEY, (boolean)false).getProperties();
        this.finder = (IShareFinder)ClassUtils.create(IShareFinder.class, (String)props.getProperty("class"), (Object[])new Object[]{props});
        this.freeSpaceLimitTriggeringNotification = 0x100000L * (long)PropertyUtils.getInt((Properties)properties, (String)FREE_SPACE_LIMIT_KEY, (int)0);
        this.stopOnNoShareFound = PropertyUtils.getBoolean((Properties)properties, (String)STOP_ON_NO_SHARE_FOUND_KEY, (boolean)false);
        this.verifyChecksum = PropertyUtils.getBoolean((Properties)properties, (String)VERIFY_CHECKSUM_KEY, (boolean)true);
    }

    private IChecksumProvider getChecksumProvider() {
        if (this.verifyChecksum) {
            return this.checksumProvider;
        }
        return null;
    }

    @Override
    public void clearCache() {
        this.sharesTimestamp = null;
    }

    @Override
    public IPostRegistrationTaskExecutor createExecutor(String dataSetCode) {
        return new Executor(dataSetCode);
    }

    private List<Share> getShares() {
        if (this.shares == null || this.sharesTimestamp == null || this.sharesTimestamp.getTime() + 3600000L < System.currentTimeMillis()) {
            this.shares = SegmentedStoreUtils.getSharesWithDataSets(this.storeRoot, this.dataStoreCode, SegmentedStoreUtils.FilterOptions.AVAILABLE_FOR_SHUFFLING, this.incomingShares, this.freeSpaceProvider, this.service, this.logger);
            this.sharesTimestamp = new Date();
        }
        return this.shares;
    }

    private static final class CleanupTask
    implements ICleanupTask {
        private static final long serialVersionUID = 1L;
        private final SimpleDataSetInformationDTO dataSet;
        private final File storeRoot;
        private final String newShareId;

        CleanupTask(SimpleDataSetInformationDTO dataSet, File storeRoot, String newShareId) {
            this.dataSet = dataSet;
            this.storeRoot = storeRoot;
            this.newShareId = newShareId;
        }

        @Override
        public void cleanup(ISimpleLogger logger) {
            IShareIdManager shareIdManager = ServiceProvider.getShareIdManager();
            SegmentedStoreUtils.cleanUp(this.dataSet, this.storeRoot, this.newShareId, shareIdManager, logger);
        }
    }

    private final class Executor
    implements IPostRegistrationTaskExecutor {
        private final String dataSetCode;
        private SimpleDataSetInformationDTO dataSet;
        private Share shareWithMostFreeOrNull;

        Executor(String dataSetCode) {
            this.dataSetCode = dataSetCode;
        }

        @Override
        public ICleanupTask createCleanupTask() {
            List currentShares = EagerShufflingTask.this.getShares();
            this.dataSet = EagerShufflingTask.findDataSet(currentShares, this.dataSetCode);
            if (!this.dataSet.getStatus().isAvailable()) {
                EagerShufflingTask.this.logger.log(LogLevel.WARN, "Data set " + this.dataSetCode + " couldn't been shuffled because its archiving status is " + this.dataSet.getStatus());
                return new NoCleanupTask();
            }
            this.shareWithMostFreeOrNull = EagerShufflingTask.this.finder.tryToFindShare(this.dataSet, currentShares);
            if (this.shareWithMostFreeOrNull == null) {
                String message = "No share found for shuffling data set " + this.dataSetCode + ".";
                if (EagerShufflingTask.this.stopOnNoShareFound) {
                    EagerShufflingTask.this.notifyer.log(LogLevel.ERROR, message);
                    throw new EnvironmentFailureException(message);
                }
                EagerShufflingTask.this.logger.log(LogLevel.WARN, message);
                return new NoCleanupTask();
            }
            return new CleanupTask(this.dataSet, EagerShufflingTask.this.storeRoot, this.shareWithMostFreeOrNull.getShareId());
        }

        @Override
        public void execute() {
            if (this.shareWithMostFreeOrNull != null) {
                String shareId = this.shareWithMostFreeOrNull.getShareId();
                try {
                    if (EagerShufflingTask.this.service.isDataSetOnTrashCanOrDeleted(this.dataSetCode)) {
                        EagerShufflingTask.this.logger.log(LogLevel.WARN, "Data set " + this.dataSetCode + " will not be moved from share " + this.dataSet.getDataSetShareId() + " to " + shareId + " because it is in the trash can or has been deleted.");
                    } else {
                        long freeSpaceBefore = this.shareWithMostFreeOrNull.calculateFreeSpace();
                        File share = new File(EagerShufflingTask.this.storeRoot, EagerShufflingTask.this.shareIdManager.getShareId(this.dataSetCode));
                        EagerShufflingTask.this.dataSetMover.moveDataSetToAnotherShare(new File(share, this.dataSet.getDataSetLocation()), this.shareWithMostFreeOrNull.getShare(), EagerShufflingTask.this.getChecksumProvider(), EagerShufflingTask.this.logger);
                        EagerShufflingTask.this.logger.log(LogLevel.INFO, "Data set " + this.dataSetCode + " successfully moved from share " + this.dataSet.getDataSetShareId() + " to " + shareId + ".");
                        long freeSpaceAfter = this.shareWithMostFreeOrNull.calculateFreeSpace();
                        if (freeSpaceBefore > EagerShufflingTask.this.freeSpaceLimitTriggeringNotification && freeSpaceAfter < EagerShufflingTask.this.freeSpaceLimitTriggeringNotification) {
                            EagerShufflingTask.this.notifyer.log(LogLevel.WARN, "After moving data set " + this.dataSetCode + " to share " + shareId + " that share has only " + FileUtilities.byteCountToDisplaySize((long)freeSpaceAfter) + " free space. It might be necessary to add a new share.");
                        }
                    }
                }
                catch (Throwable t) {
                    EagerShufflingTask.this.logger.log(LogLevel.ERROR, "Couldn't move data set " + this.dataSetCode + " to share " + shareId + ".", t);
                    throw t;
                }
            }
        }
    }
}

