/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.postregistration;

import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.logging.ISimpleLogger;
import ch.systemsx.cisd.common.logging.Log4jSimpleLogger;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.logging.LogLevel;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.common.string.Template;
import ch.systemsx.cisd.etlserver.postregistration.AbstractPostRegistrationTask;
import ch.systemsx.cisd.etlserver.postregistration.ICleanupTask;
import ch.systemsx.cisd.etlserver.postregistration.IPostRegistrationTaskExecutor;
import ch.systemsx.cisd.etlserver.postregistration.NoCleanupTask;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import java.io.File;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class NotifyingTask
extends AbstractPostRegistrationTask {
    private static final String MESSAGE_TEMPLATE_KEY = "message-template";
    private static final String DESTINATION_PATH_TEMPLATE_KEY = "destination-path-template";
    private static final String INCLUDE_DATASET_TYPES_PATTERN = "include-dataset-type-patterns";
    private static final String PROPERTY_PREFIX = "property.";
    private static final String DATA_SET_CODE_PLACE_HOLDER = "data-set-code";
    private final ISimpleLogger logger;
    private final Template messageTemplate;
    private final Template destinationPathTemplate;
    private final String[] includeDatasetTypePatternsOrNull;

    public NotifyingTask(Properties properties, IEncapsulatedOpenBISService service) {
        this(properties, service, (ISimpleLogger)new Log4jSimpleLogger(LogFactory.getLogger((LogCategory)LogCategory.OPERATION, NotifyingTask.class)));
    }

    NotifyingTask(Properties properties, IEncapsulatedOpenBISService service, ISimpleLogger logger) {
        super(properties, service);
        this.logger = logger;
        this.messageTemplate = new Template(PropertyUtils.getMandatoryProperty((Properties)properties, (String)MESSAGE_TEMPLATE_KEY));
        this.destinationPathTemplate = new Template(PropertyUtils.getMandatoryProperty((Properties)properties, (String)DESTINATION_PATH_TEMPLATE_KEY));
        String includePattern = PropertyUtils.getProperty((Properties)properties, (String)INCLUDE_DATASET_TYPES_PATTERN);
        this.includeDatasetTypePatternsOrNull = NotifyingTask.parseTokens(includePattern);
    }

    private static String[] parseTokens(String tokensString) {
        if (StringUtils.isBlank((CharSequence)tokensString)) {
            return null;
        }
        String[] tokens = tokensString.split(",");
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = tokens[i].trim();
        }
        return tokens;
    }

    @Override
    public boolean requiresDataStoreLock() {
        return false;
    }

    @Override
    public IPostRegistrationTaskExecutor createExecutor(String dataSetCode, boolean container) {
        AbstractExternalData dataSet = this.service.tryGetDataSet(dataSetCode);
        if (dataSet == null) {
            throw new IllegalArgumentException("Unknown data set: " + dataSetCode);
        }
        return new Executor(dataSet, this.messageTemplate.createFreshCopy(), this.destinationPathTemplate.createFreshCopy(), this.includeDatasetTypePatternsOrNull, this.logger);
    }

    private static final class UnknownPropertyRequested
    extends Exception {
        private static final long serialVersionUID = 1L;

        public UnknownPropertyRequested(String message) {
            super(message);
        }
    }

    private static final class Executor
    implements IPostRegistrationTaskExecutor {
        private final ISimpleLogger logger;
        private final AbstractExternalData dataSet;
        private final Template messageTemplate;
        private final Template destinationPathTemplate;
        private final String[] includeDatasetTypePatternsOrNull;

        public Executor(AbstractExternalData dataSet, Template messageTemplate, Template destinationPathTemplate, String[] includeDatasetTypePatternsOrNull, ISimpleLogger logger) {
            this.dataSet = dataSet;
            this.messageTemplate = messageTemplate;
            this.destinationPathTemplate = destinationPathTemplate;
            this.includeDatasetTypePatternsOrNull = includeDatasetTypePatternsOrNull;
            this.logger = logger;
        }

        @Override
        public ICleanupTask createCleanupTask() {
            return new NoCleanupTask();
        }

        @Override
        public void execute() {
            if (this.typeMatches()) {
                String fileName;
                String messageText;
                try {
                    messageText = this.fillTemplate(this.messageTemplate);
                    fileName = this.fillTemplate(this.destinationPathTemplate);
                }
                catch (UnknownPropertyRequested ex) {
                    this.logger.log(LogLevel.WARN, String.format("Could not produce post registration confirmation file for dataset '%s': %s", this.dataSet.getCode(), ex.getMessage()));
                    return;
                }
                FileUtilities.writeToFile((File)new File(fileName), (String)messageText);
            }
        }

        private boolean typeMatches() {
            if (this.includeDatasetTypePatternsOrNull == null) {
                return true;
            }
            String datasetTypeCode = this.dataSet.getEntityType().getCode();
            for (String datasetTypePattern : this.includeDatasetTypePatternsOrNull) {
                if (!datasetTypeCode.matches(datasetTypePattern)) continue;
                return true;
            }
            return false;
        }

        private String fillTemplate(Template template) throws UnknownPropertyRequested {
            Set placeholderNames = template.getPlaceholderNames();
            for (String placeholderName : placeholderNames) {
                if (placeholderName.equals(NotifyingTask.DATA_SET_CODE_PLACE_HOLDER)) {
                    template.bind(NotifyingTask.DATA_SET_CODE_PLACE_HOLDER, this.dataSet.getCode());
                    continue;
                }
                if (placeholderName.startsWith(NotifyingTask.PROPERTY_PREFIX)) {
                    String propertyName = placeholderName.substring(NotifyingTask.PROPERTY_PREFIX.length());
                    template.bind(placeholderName, this.getProperty(propertyName));
                    continue;
                }
                throw new IllegalArgumentException("No binding found for place holder '" + placeholderName + "'.");
            }
            String messageText = template.createText();
            return messageText;
        }

        private String getProperty(String propertyName) throws UnknownPropertyRequested {
            for (IEntityProperty property : this.dataSet.getProperties()) {
                if (!property.getPropertyType().getCode().equalsIgnoreCase(propertyName)) continue;
                return property.tryGetAsString();
            }
            throw new UnknownPropertyRequested(String.format("Property '%s' is not set.", propertyName));
        }
    }
}

