/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.postregistration;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.id.DataSetPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.id.IDataSetId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.update.DataSetUpdate;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.update.PhysicalDataUpdate;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.etlserver.postregistration.AbstractPostRegistrationTaskForPhysicalDataSets;
import ch.systemsx.cisd.etlserver.postregistration.ICleanupTask;
import ch.systemsx.cisd.etlserver.postregistration.IPostRegistrationTaskExecutor;
import ch.systemsx.cisd.etlserver.postregistration.NoCleanupTask;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PhysicalDataSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

public class RequestArchivingPostRegistrationTask
extends AbstractPostRegistrationTaskForPhysicalDataSets {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, RequestArchivingPostRegistrationTask.class);

    public RequestArchivingPostRegistrationTask(Properties properties, IEncapsulatedOpenBISService service) {
        super(properties, service);
    }

    @Override
    protected IPostRegistrationTaskExecutor createExecutor(final String dataSetCode) {
        return new IPostRegistrationTaskExecutor(){

            private boolean isArchivedOrArchivingRequested() {
                List<String> codeAsList = Collections.singletonList(dataSetCode);
                List<AbstractExternalData> dataList = RequestArchivingPostRegistrationTask.this.service.listDataSetsByCode(codeAsList);
                if (dataList == null || dataList.isEmpty()) {
                    return false;
                }
                AbstractExternalData dataSet = dataList.get(0);
                return dataSet instanceof PhysicalDataSet && (((PhysicalDataSet)dataSet).isPresentInArchive() || ((PhysicalDataSet)dataSet).isArchivingRequested());
            }

            @Override
            public void execute() {
                if (this.isArchivedOrArchivingRequested()) {
                    operationLog.info((Object)("DataSet " + dataSetCode + " is either in archive or archiving is requested."));
                    return;
                }
                DataSetUpdate dataSetUpdate = new DataSetUpdate();
                dataSetUpdate.setDataSetId((IDataSetId)new DataSetPermId(dataSetCode));
                PhysicalDataUpdate physicalDataUpdate = new PhysicalDataUpdate();
                physicalDataUpdate.setArchivingRequested(true);
                dataSetUpdate.setPhysicalData(physicalDataUpdate);
                RequestArchivingPostRegistrationTask.this.getV3api().updateDataSets(RequestArchivingPostRegistrationTask.this.service.getSessionToken(), Arrays.asList(dataSetUpdate));
                operationLog.info((Object)("Archiving requested for data set " + dataSetCode));
            }

            @Override
            public ICleanupTask createCleanupTask() {
                return new NoCleanupTask();
            }
        };
    }
}

